/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.repackage.cofh.lib.gui.element;

import com.pahimar.ee3.util.ResourceLocationHelper;
import com.pahimar.repackage.cofh.lib.gui.GuiBase;
import com.pahimar.repackage.cofh.lib.gui.element.ElementBase;
import com.pahimar.repackage.cofh.lib.render.RenderHelper;
import com.pahimar.repackage.cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class ElementButton
extends ElementBase {
    int sheetX;
    int sheetY;
    int hoverX;
    int hoverY;
    int disabledX = 0;
    int disabledY = 0;
    boolean tooltipLocalized = false;
    String tooltip;

    public ElementButton(GuiBase gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int sizeX, int sizeY, String texture) {
        this(gui, posX, posY, name, sheetX, sheetY, hoverX, hoverY, sizeX, sizeY, 256, 256, texture);
    }

    public ElementButton(GuiBase gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int sizeX, int sizeY, ResourceLocation texture) {
        this(gui, posX, posY, name, sheetX, sheetY, hoverX, hoverY, sizeX, sizeY, 256, 256, texture);
    }

    public ElementButton(GuiBase gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int sizeX, int sizeY, int texW, int texH, String texture) {
        this(gui, posX, posY, name, sheetX, sheetY, hoverX, hoverY, sizeX, sizeY, texW, texH, ResourceLocationHelper.getResourceLocation(texture));
    }

    public ElementButton(GuiBase gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int sizeX, int sizeY, int texW, int texH, ResourceLocation texture) {
        super(gui, posX, posY);
        this.setName(name);
        this.setSize(sizeX, sizeY);
        this.setTexture(texture, texW, texH);
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.hoverX = hoverX;
        this.hoverY = hoverY;
    }

    public ElementButton(GuiBase gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int disabledX, int disabledY, int sizeX, int sizeY, int texW, int texH, String texture) {
        this(gui, posX, posY, name, sheetX, sheetY, hoverX, hoverY, disabledX, disabledY, sizeX, sizeY, texW, texH, ResourceLocationHelper.getResourceLocation(texture));
    }

    public ElementButton(GuiBase gui, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int disabledX, int disabledY, int sizeX, int sizeY, int texW, int texH, ResourceLocation texture) {
        super(gui, posX, posY);
        this.setName(name);
        this.setSize(sizeX, sizeY);
        this.setTexture(texture, texW, texH);
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.hoverX = hoverX;
        this.hoverY = hoverY;
        this.disabledX = disabledX;
        this.disabledY = disabledY;
    }

    public ElementButton clearToolTip() {
        this.tooltip = null;
        return this;
    }

    public ElementButton setToolTip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ElementButton setToolTipLocalized(boolean localized) {
        this.tooltipLocalized = localized;
        return this;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        RenderHelper.bindTexture(this.texture);
        if (this.isEnabled()) {
            if (this.intersectsWith(mouseX, mouseY)) {
                this.drawTexturedModalRect(this.posX, this.posY, this.hoverX, this.hoverY, this.sizeX, this.sizeY);
            } else {
                this.drawTexturedModalRect(this.posX, this.posY, this.sheetX, this.sheetY, this.sizeX, this.sizeY);
            }
        } else {
            this.drawTexturedModalRect(this.posX, this.posY, this.disabledX, this.disabledY, this.sizeX, this.sizeY);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.tooltip != null) {
            if (this.tooltipLocalized) {
                list.add(this.tooltip);
            } else {
                list.add(StringHelper.localize(this.tooltip));
            }
        }
    }

    @Override
    public boolean onMousePressed(int x, int y, int mouseButton) {
        if (this.isEnabled()) {
            this.gui.handleElementButtonClick(this.getName(), mouseButton);
            return true;
        }
        return false;
    }

    public void setSheetX(int pos) {
        this.sheetX = pos;
    }

    public void setSheetY(int pos) {
        this.sheetY = pos;
    }

    public void setHoverX(int pos) {
        this.hoverX = pos;
    }

    public void setHoverY(int pos) {
        this.hoverY = pos;
    }

    public ElementButton setDisabledX(int pos) {
        this.disabledX = pos;
        return this;
    }

    public ElementButton setDisabledY(int pos) {
        this.disabledY = pos;
        return this;
    }

    public void setActive() {
        this.setEnabled(true);
    }

    public void setDisabled() {
        this.setEnabled(false);
    }
}

