/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.settings;

import com.pahimar.ee3.api.array.AlchemyArrayRegistryProxy;
import com.pahimar.ee3.util.INBTTaggable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ChalkSettings
implements INBTTaggable {
    private int index;
    private int size;
    private int rotation;
    private final int MAX_SIZE = 3;

    public ChalkSettings() {
        this(0, 1, 0);
    }

    public ChalkSettings(int index, int size, int rotation) {
        this.index = index;
        this.size = size;
        this.rotation = rotation;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        if (this.index < 0) {
            this.index = 0;
        } else if (this.index >= AlchemyArrayRegistryProxy.getRegisteredAlchemyArrays().size()) {
            this.index = AlchemyArrayRegistryProxy.getRegisteredAlchemyArrays().size() - 1;
        }
    }

    public void incrementIndex() {
        ++this.index;
        if (this.index >= AlchemyArrayRegistryProxy.getRegisteredAlchemyArrays().size()) {
            this.index = 0;
        }
    }

    public void decrementIndex() {
        --this.index;
        if (this.index < 0) {
            this.index = AlchemyArrayRegistryProxy.getRegisteredAlchemyArrays().size() - 1;
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size < 1 ? 1 : (size > 3 ? 3 : size);
    }

    public void incrementSize() {
        if (this.size < 3) {
            ++this.size;
        }
    }

    public void decrementSize() {
        if (this.size > 1) {
            --this.size;
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation < 0 ? 0 : rotation % 4;
    }

    public void rotateClockwise() {
        this.rotation = (this.rotation + 1) % 4;
    }

    public void rotateCounterClockwise() {
        --this.rotation;
        if (this.rotation < 0) {
            this.rotation = 3;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("chalk_settings") && nbtTagCompound.func_74781_a("chalk_settings").func_74732_a() == 10) {
            NBTTagCompound chalkSettings = nbtTagCompound.func_74775_l("chalk_settings");
            if (chalkSettings.func_74764_b("index")) {
                this.index = chalkSettings.func_74762_e("index");
                if (this.index < 0 || this.index >= AlchemyArrayRegistryProxy.getRegisteredAlchemyArrays().size()) {
                    this.index = 0;
                }
            } else {
                this.index = 0;
            }
            if (chalkSettings.func_74764_b("size")) {
                this.size = chalkSettings.func_74762_e("size");
                if (this.size < 1) {
                    this.size = 1;
                } else if (this.size > 3) {
                    this.size = 3;
                }
            } else {
                this.size = 1;
            }
            if (chalkSettings.func_74764_b("rotation")) {
                this.rotation = chalkSettings.func_74762_e("rotation");
                this.rotation = this.rotation < 0 ? 0 : (this.rotation %= 4);
            } else {
                this.rotation = 0;
            }
        } else {
            this.index = 0;
            this.size = 1;
            this.rotation = 0;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound chalkSettings = new NBTTagCompound();
        chalkSettings.func_74768_a("index", this.index);
        chalkSettings.func_74768_a("size", this.size);
        chalkSettings.func_74768_a("rotation", this.rotation);
        nbtTagCompound.func_74782_a("chalk_settings", (NBTBase)chalkSettings);
    }

    @Override
    public String getTagLabel() {
        return this.getClass().getName();
    }
}

