/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.message;

import com.pahimar.ee3.tileentity.TileEntityEE;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;

public class MessageTileEntityEE
implements IMessage,
IMessageHandler<MessageTileEntityEE, IMessage> {
    public int x;
    public int y;
    public int z;
    public byte orientation;
    public byte state;
    public String customName;
    public UUID ownerUUID;

    public MessageTileEntityEE() {
    }

    public MessageTileEntityEE(TileEntityEE tileEntityEE) {
        this.x = tileEntityEE.field_145851_c;
        this.y = tileEntityEE.field_145848_d;
        this.z = tileEntityEE.field_145849_e;
        this.orientation = (byte)tileEntityEE.getOrientation().ordinal();
        this.state = (byte)tileEntityEE.getState();
        this.customName = tileEntityEE.getCustomName();
        this.ownerUUID = tileEntityEE.getOwnerUUID();
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.orientation = buf.readByte();
        this.state = buf.readByte();
        int customNameLength = buf.readInt();
        this.customName = new String(buf.readBytes(customNameLength).array());
        this.ownerUUID = buf.readBoolean() ? new UUID(buf.readLong(), buf.readLong()) : null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.orientation);
        buf.writeByte((int)this.state);
        buf.writeInt(this.customName.length());
        buf.writeBytes(this.customName.getBytes());
        if (this.ownerUUID != null) {
            buf.writeBoolean(true);
            buf.writeLong(this.ownerUUID.getMostSignificantBits());
            buf.writeLong(this.ownerUUID.getLeastSignificantBits());
        } else {
            buf.writeBoolean(false);
        }
    }

    public IMessage onMessage(MessageTileEntityEE message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.x, message.y, message.z);
        if (tileEntity instanceof TileEntityEE) {
            ((TileEntityEE)tileEntity).setOrientation(message.orientation);
            ((TileEntityEE)tileEntity).setState(message.state);
            ((TileEntityEE)tileEntity).setCustomName(message.customName);
            ((TileEntityEE)tileEntity).setOwnerUUID(message.ownerUUID);
        }
        return null;
    }

    public String toString() {
        return String.format("MessageTileEntityEE - x:%s, y:%s, z:%s, orientation:%s, state:%s, customName:%s, ownerUUID:%s", this.x, this.y, this.z, this.orientation, this.state, this.customName, this.ownerUUID);
    }
}

