/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.message;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.reference.Settings;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class MessageSoundEvent
implements IMessage,
IMessageHandler<MessageSoundEvent, IMessage> {
    private long mostSigUUID;
    private long leastSigUUID;
    private String soundName;
    private float xCoord;
    private float yCoord;
    private float zCoord;
    private float volume;
    private float pitch;

    public MessageSoundEvent() {
    }

    public MessageSoundEvent(EntityPlayer entityPlayer, String soundName, float volume, float pitch) {
        this.mostSigUUID = entityPlayer.func_110124_au().getMostSignificantBits();
        this.leastSigUUID = entityPlayer.func_110124_au().getLeastSignificantBits();
        this.soundName = soundName;
        this.xCoord = (float)entityPlayer.field_70165_t;
        this.yCoord = (float)entityPlayer.field_70163_u;
        this.zCoord = (float)entityPlayer.field_70161_v;
        this.volume = volume;
        this.pitch = pitch;
    }

    public MessageSoundEvent(String soundName, float xCoord, float yCoord, float zCoord, float volume, float pitch) {
        this.mostSigUUID = 0L;
        this.leastSigUUID = 0L;
        this.soundName = soundName;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.volume = volume;
        this.pitch = pitch;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.mostSigUUID = byteBuf.readLong();
        this.leastSigUUID = byteBuf.readLong();
        int soundNameLength = byteBuf.readInt();
        this.soundName = new String(byteBuf.readBytes(soundNameLength).array());
        this.xCoord = byteBuf.readFloat();
        this.yCoord = byteBuf.readFloat();
        this.zCoord = byteBuf.readFloat();
        this.volume = byteBuf.readFloat();
        this.pitch = byteBuf.readFloat();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeLong(this.mostSigUUID);
        byteBuf.writeLong(this.leastSigUUID);
        byteBuf.writeInt(this.soundName.length());
        byteBuf.writeBytes(this.soundName.getBytes());
        byteBuf.writeFloat(this.xCoord);
        byteBuf.writeFloat(this.yCoord);
        byteBuf.writeFloat(this.zCoord);
        byteBuf.writeFloat(this.volume);
        byteBuf.writeFloat(this.pitch);
    }

    public IMessage onMessage(MessageSoundEvent event, MessageContext context) {
        UUID originUUID = new UUID(event.mostSigUUID, event.leastSigUUID);
        if (Settings.Sounds.soundMode.equalsIgnoreCase("All")) {
            EquivalentExchange3.proxy.playSound(event.soundName, event.xCoord, event.yCoord, event.zCoord, event.volume, event.pitch);
        } else if (Settings.Sounds.soundMode.equalsIgnoreCase("Self") && FMLClientHandler.instance().getClient().field_71439_g.func_110124_au().equals(originUUID)) {
            EquivalentExchange3.proxy.playSound(event.soundName, event.xCoord, event.yCoord, event.zCoord, event.volume, event.pitch);
        }
        return null;
    }
}

