/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.message;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.util.LogHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class MessageSetEnergyValue
implements IMessage,
IMessageHandler<MessageSetEnergyValue, IMessage> {
    public WrappedStack wrappedStack;
    public EnergyValue energyValue;

    public MessageSetEnergyValue() {
    }

    public MessageSetEnergyValue(WrappedStack wrappedStack, EnergyValue energyValue) {
        this.wrappedStack = wrappedStack;
        this.energyValue = energyValue;
    }

    public void fromBytes(ByteBuf buf) {
        byte[] compressedWrappedStack = null;
        int wrappedStackByteCount = buf.readInt();
        if (wrappedStackByteCount > 0) {
            compressedWrappedStack = buf.readBytes(wrappedStackByteCount).array();
        }
        byte[] compressedEnergyValue = null;
        int energyValueByteCount = buf.readInt();
        if (energyValueByteCount > 0) {
            compressedEnergyValue = buf.readBytes(energyValueByteCount).array();
        }
        if (compressedWrappedStack != null && compressedEnergyValue != null) {
            try {
                this.wrappedStack = WrappedStack.fromNBTTagCompound(CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(compressedWrappedStack)));
                this.energyValue = EnergyValue.loadEnergyValueFromNBT(CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(compressedEnergyValue)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        byte[] compressedWrappedStack = null;
        byte[] compressedEnergyValue = null;
        try {
            compressedWrappedStack = CompressedStreamTools.func_74798_a((NBTTagCompound)WrappedStack.toNBTTagCompound(this.wrappedStack));
            compressedEnergyValue = CompressedStreamTools.func_74798_a((NBTTagCompound)EnergyValue.writeEnergyValueToNBT(this.energyValue));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (compressedWrappedStack != null && compressedEnergyValue != null) {
            buf.writeInt(compressedWrappedStack.length);
            buf.writeBytes(compressedWrappedStack);
            buf.writeInt(compressedEnergyValue.length);
            buf.writeBytes(compressedEnergyValue);
        } else {
            buf.writeInt(0);
        }
    }

    public IMessage onMessage(MessageSetEnergyValue message, MessageContext ctx) {
        if (message.wrappedStack != null && message.energyValue != null) {
            EnergyValueRegistry.getInstance().setEnergyValue(message.wrappedStack, message.energyValue);
            LogHelper.info(String.format("Client successfully received new EnergyValue '%s' for object '%s'", message.energyValue, message.wrappedStack));
        } else {
            LogHelper.info("Client failed to receive new EnergyValue from server");
        }
        return null;
    }
}

