/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.exchange;

import com.pahimar.ee3.exchange.CachedOreDictionary;
import com.pahimar.ee3.reference.Comparators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class OreStack
implements Comparable<OreStack> {
    public String oreName;
    public int stackSize;
    public static Comparator<OreStack> comparator = new Comparator<OreStack>(){

        @Override
        public int compare(OreStack oreStack1, OreStack oreStack2) {
            if (oreStack1 != null && oreStack1.oreName != null) {
                if (oreStack2 != null && oreStack2.oreName != null) {
                    if (oreStack1.oreName.equalsIgnoreCase(oreStack2.oreName)) {
                        return oreStack1.stackSize - oreStack2.stackSize;
                    }
                    return oreStack1.oreName.compareToIgnoreCase(oreStack2.oreName);
                }
                return -1;
            }
            if (oreStack2 != null) {
                return 1;
            }
            return 0;
        }
    };

    private OreStack() {
    }

    public OreStack(String oreName) {
        this(oreName, 1);
    }

    public OreStack(String oreName, int stackSize) {
        this.oreName = oreName;
        this.stackSize = stackSize;
    }

    public static boolean compareOreNames(OreStack oreStack1, OreStack oreStack2) {
        if (oreStack1 != null && oreStack2 != null && oreStack1.oreName != null && oreStack2.oreName != null) {
            return oreStack1.oreName.equalsIgnoreCase(oreStack2.oreName);
        }
        return false;
    }

    public static OreStack getOreStackFromList(Object ... objects) {
        return OreStack.getOreStackFromList(Arrays.asList(objects));
    }

    public static OreStack getOreStackFromList(List<?> objectList) {
        if (objectList.size() > 0) {
            TreeMap<String, Integer> oreNameCountMap = new TreeMap<String, Integer>(Comparators.stringComparator);
            for (Object listElement : objectList) {
                if (!(listElement instanceof ItemStack)) continue;
                ItemStack itemStack = (ItemStack)listElement;
                for (String oreName : CachedOreDictionary.getInstance().getOreNamesForItemStack(itemStack)) {
                    if (oreNameCountMap.containsKey(oreName)) {
                        oreNameCountMap.put(oreName, (Integer)oreNameCountMap.get(oreName) + 1);
                        continue;
                    }
                    oreNameCountMap.put(oreName, 1);
                }
            }
            ArrayList<OreStack> candidateOreStacks = new ArrayList<OreStack>();
            for (String oreName : oreNameCountMap.keySet()) {
                if (((Integer)oreNameCountMap.get(oreName)).intValue() != objectList.size()) continue;
                candidateOreStacks.add(new OreStack(oreName));
            }
            if (candidateOreStacks.size() == 1) {
                return (OreStack)candidateOreStacks.get(0);
            }
            return null;
        }
        return null;
    }

    public static int compare(OreStack oreStack1, OreStack oreStack2) {
        return comparator.compare(oreStack1, oreStack2);
    }

    public boolean equals(Object object) {
        return object instanceof OreStack && comparator.compare(this, (OreStack)object) == 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74778_a("oreName", this.oreName);
        nbtTagCompound.func_74768_a("stackSize", this.stackSize);
        return nbtTagCompound;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.oreName = nbtTagCompound.func_74779_i("oreName");
        this.stackSize = nbtTagCompound.func_74762_e("stackSize");
    }

    public static OreStack loadOreStackFromNBT(NBTTagCompound nbtTagCompound) {
        OreStack oreStack = new OreStack();
        oreStack.readFromNBT(nbtTagCompound);
        return oreStack.oreName != null ? oreStack : null;
    }

    public String toString() {
        return String.format("%sxoreStack.%s", this.stackSize, this.oreName);
    }

    @Override
    public int compareTo(OreStack oreStack) {
        return comparator.compare(this, oreStack);
    }
}

