/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.renderer.tileentity;

import com.pahimar.ee3.client.renderer.model.ModelGlassBell;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.tileentity.TileEntityGlassBell;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityRendererGlassBell
extends TileEntitySpecialRenderer {
    private final ModelGlassBell modelGlassBell = new ModelGlassBell();
    private final RenderItem customRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }
    };

    public TileEntityRendererGlassBell() {
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float tick) {
        if (tileEntity instanceof TileEntityGlassBell) {
            TileEntityGlassBell tileEntityGlassBell = (TileEntityGlassBell)tileEntity;
            GL11.glDisable((int)2884);
            GL11.glPushMatrix();
            this.renderGlassBellByOrientation(x, y, z, tileEntityGlassBell.getOrientation());
            this.func_147499_a(Textures.Model.GLASS_BELL);
            this.modelGlassBell.render();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            if (tileEntityGlassBell.outputItemStack != null) {
                float scaleFactor = this.getGhostItemScaleFactor(tileEntityGlassBell.outputItemStack);
                float rotationAngle = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
                EntityItem ghostEntityItem = new EntityItem(tileEntityGlassBell.func_145831_w());
                ghostEntityItem.field_70290_d = 0.0f;
                ghostEntityItem.func_92058_a(tileEntityGlassBell.outputItemStack);
                this.translateGhostItemByOrientation(ghostEntityItem.func_92059_d(), x, y, z, tileEntityGlassBell.getOrientation());
                GL11.glScalef((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
                GL11.glRotatef((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
                this.customRenderItem.func_76986_a(ghostEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
            GL11.glPopMatrix();
            GL11.glEnable((int)2884);
        }
    }

    private void renderGlassBellByOrientation(double x, double y, double z, ForgeDirection forgeDirection) {
        switch (forgeDirection) {
            case DOWN: {
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + 2.0f), (float)((float)z + 0.0f));
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                return;
            }
            case UP: {
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + -1.0f), (float)((float)z + 1.0f));
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                return;
            }
            case NORTH: {
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)((float)x + 1.0f), (float)((float)y + 0.0f), (float)((float)z + 2.0f));
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                return;
            }
            case SOUTH: {
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + 0.0f), (float)((float)z + -1.0f));
                return;
            }
            case EAST: {
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)((float)x + -1.0f), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                return;
            }
            case WEST: {
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)((float)x + 2.0f), (float)((float)y + 0.0f), (float)((float)z + 1.0f));
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                return;
            }
            case UNKNOWN: {
                return;
            }
        }
    }

    private void translateGhostItemByOrientation(ItemStack ghostItemStack, double x, double y, double z, ForgeDirection forgeDirection) {
        if (ghostItemStack != null) {
            if (ghostItemStack.func_77973_b() instanceof ItemBlock) {
                switch (forgeDirection) {
                    case DOWN: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.7f), (float)((float)z + 0.5f));
                        return;
                    }
                    case UP: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.25f), (float)((float)z + 0.5f));
                        return;
                    }
                    case NORTH: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.7f));
                        return;
                    }
                    case SOUTH: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.3f));
                        return;
                    }
                    case EAST: {
                        GL11.glTranslatef((float)((float)x + 0.3f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                        return;
                    }
                    case WEST: {
                        GL11.glTranslatef((float)((float)x + 0.7f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                        return;
                    }
                    case UNKNOWN: {
                        return;
                    }
                }
            } else {
                switch (forgeDirection) {
                    case DOWN: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.6f), (float)((float)z + 0.5f));
                        return;
                    }
                    case UP: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.2f), (float)((float)z + 0.5f));
                        return;
                    }
                    case NORTH: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.4f), (float)((float)z + 0.7f));
                        return;
                    }
                    case SOUTH: {
                        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.4f), (float)((float)z + 0.3f));
                        return;
                    }
                    case EAST: {
                        GL11.glTranslatef((float)((float)x + 0.3f), (float)((float)y + 0.4f), (float)((float)z + 0.5f));
                        return;
                    }
                    case WEST: {
                        GL11.glTranslatef((float)((float)x + 0.7f), (float)((float)y + 0.4f), (float)((float)z + 0.5f));
                        return;
                    }
                    case UNKNOWN: {
                        return;
                    }
                }
            }
        }
    }

    private float getGhostItemScaleFactor(ItemStack itemStack) {
        float scaleFactor = 1.0f;
        if (itemStack != null) {
            int numBlocks = 1;
            if (itemStack.field_77994_a > 1) {
                numBlocks = 2;
            } else if (itemStack.field_77994_a > 5) {
                numBlocks = 3;
            } else if (itemStack.field_77994_a > 20) {
                numBlocks = 4;
            } else if (itemStack.field_77994_a > 40) {
                numBlocks = 5;
            }
            if (itemStack.func_77973_b() instanceof ItemBlock) {
                switch (numBlocks) {
                    case 1: {
                        return 0.9f;
                    }
                    case 2: {
                        return 0.9f;
                    }
                    case 3: {
                        return 0.9f;
                    }
                    case 4: {
                        return 0.9f;
                    }
                    case 5: {
                        return 0.8f;
                    }
                }
                return 0.9f;
            }
            switch (numBlocks) {
                case 1: {
                    return 0.65f;
                }
                case 2: {
                    return 0.65f;
                }
                case 3: {
                    return 0.65f;
                }
                case 4: {
                    return 0.65f;
                }
            }
            return 0.65f;
        }
        return scaleFactor;
    }
}

