/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.tiles;

import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import unwrittenfun.minecraft.immersiveintegration.ImmersiveIntegration;
import unwrittenfun.minecraft.immersiveintegration.client.gui.GuiIndustrialCokeOven;
import unwrittenfun.minecraft.immersiveintegration.gui.IGuiProvider;
import unwrittenfun.minecraft.immersiveintegration.gui.containers.ContainerIndustrialCokeOven;
import unwrittenfun.minecraft.immersiveintegration.tiles.IMultiblockTile;
import unwrittenfun.minecraft.immersiveintegration.utils.TileUtils;

public class TileIndustrialCokeOven
extends TileEntity
implements IMultiblockTile,
IGuiProvider,
ISidedInventory,
IFluidHandler {
    public int[] offset;
    public ItemStack replaced;
    public boolean formed;
    public ItemStack[] items = new ItemStack[10];
    public FluidTank tank = new FluidTank(64000);
    public int[] processTime = new int[4];
    public int[] processTimeMax = new int[4];
    public int clientFluidAmount = 0;
    public int[] clientProgress = new int[4];
    public Random random = new Random();

    public void func_145845_h() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.isFormed()) {
            if (this.isMaster()) {
                ItemStack filledContainer;
                for (int i = 0; i < 4; ++i) {
                    CokeOvenRecipe recipe;
                    int slot = i * 2 + 1;
                    if (this.processTime[i] > 0) {
                        ItemStack outputStack;
                        int n = i;
                        this.processTime[n] = this.processTime[n] + 1;
                        if (this.processTime[i] <= this.processTimeMax[i]) continue;
                        recipe = CokeOvenRecipe.findRecipe((ItemStack)this.func_70301_a(slot));
                        if (recipe != null && TileUtils.addStack((IInventory)this, outputStack = recipe.output.func_77946_l(), i * 2, true) == 0) {
                            if (this.random.nextInt(ImmersiveIntegration.cfg.cokeOvenDoubleChance) == 0) {
                                ++outputStack.field_77994_a;
                            }
                            TileUtils.addStack((IInventory)this, outputStack, i * 2, false);
                            this.func_70298_a(slot, 1);
                            this.tank.fill(new FluidStack(IEContent.fluidCreosote, (int)((float)recipe.creosoteOutput * ImmersiveIntegration.cfg.cokeOvenCreosoteMultiplier)), true);
                        }
                        this.processTime[i] = 0;
                        this.processTimeMax[i] = 0;
                        continue;
                    }
                    recipe = CokeOvenRecipe.findRecipe((ItemStack)this.func_70301_a(slot));
                    if (!this.isValidRecipe(recipe, i)) continue;
                    this.processTime[i] = 1;
                    this.processTimeMax[i] = (int)((float)recipe.time * ImmersiveIntegration.cfg.cokeOvenTimeMultiplier);
                }
                if (this.tank.getFluidAmount() > 0 && this.tank.getFluid() != null && (this.func_70301_a(9) == null || this.func_70301_a((int)9).field_77994_a < this.func_70301_a(9).func_77976_d()) && (filledContainer = Utils.fillFluidContainer((FluidTank)this.tank, (ItemStack)this.func_70301_a(8), (ItemStack)this.func_70301_a(9))) != null) {
                    if (this.func_70301_a(9) != null && OreDictionary.itemMatches((ItemStack)this.func_70301_a(9), (ItemStack)filledContainer, (boolean)true)) {
                        this.func_70301_a((int)9).field_77994_a += filledContainer.field_77994_a;
                    } else if (this.func_70301_a(9) == null) {
                        this.func_70299_a(9, filledContainer.func_77946_l());
                    }
                    this.func_70298_a(8, filledContainer.field_77994_a);
                }
            } else if (this.isIOSide()) {
                this.doAutoOutput(this.getFacing());
                this.doAutoOutput(this.getFacing().getOpposite());
            }
        }
    }

    public void doAutoOutput(ForgeDirection side) {
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
        if (tileEntity instanceof IInventory && !(tileEntity instanceof TileIndustrialCokeOven)) {
            IInventory inv = (IInventory)tileEntity;
            for (int i = 0; i < 4; ++i) {
                this.outputStackInSlot(i * 2, inv, side.getOpposite());
            }
            this.outputStackInSlot(9, inv, side.getOpposite());
        }
    }

    public void outputStackInSlot(int slot, IInventory inv, ForgeDirection side) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            int leftover = TileUtils.addStackToInventory(inv, side, stack);
            if (leftover <= 0) {
                this.func_70299_a(slot, null);
            } else {
                stack.field_77994_a = leftover;
            }
        }
    }

    public boolean isIOSide() {
        int x = this.getFacing().offsetX != 0 ? 2 : 0;
        int z = this.getFacing().offsetX != 0 ? 0 : 2;
        return !(this.offset[1] != -1 || Math.abs(this.offset[x]) != 3 && Math.abs(this.offset[x]) != 1 || Math.abs(this.offset[z]) != 4 && this.offset[z] != 0);
    }

    private boolean isValidRecipe(CokeOvenRecipe recipe, int i) {
        return recipe != null && (this.func_70301_a(i * 2) == null || recipe.output.func_77969_a(this.func_70301_a(i * 2)) && this.func_70301_a(i * 2).func_77976_d() - this.func_70301_a((int)(i * 2)).field_77994_a >= recipe.output.field_77994_a);
    }

    @Override
    public int[] getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int[] offset) {
        this.offset = offset;
    }

    @Override
    public ItemStack getReplaced() {
        return this.replaced;
    }

    @Override
    public void setReplaced(ItemStack stack) {
        this.replaced = stack;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.func_145832_p() == 1 || this.func_145832_p() == 2) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 10), (double)(this.field_145848_d - 10), (double)(this.field_145849_e - 10), (double)(this.field_145851_c + 10), (double)(this.field_145848_d + 10), (double)(this.field_145849_e + 10));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public boolean isFormed() {
        return this.formed;
    }

    @Override
    public void setFormed(boolean formed) {
        if (this.formed && !formed) {
            TileUtils.dropInventory(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.formed = formed;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeCustomNBT(compound);
        TileUtils.writeInventoryToNBT(compound, (IInventory)this);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCustomNBT(compound);
        TileUtils.readInventoryFromNBT(compound, (IInventory)this);
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        compound.func_74783_a("offset", this.offset);
        compound.func_74757_a("formed", this.formed);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        compound.func_74783_a("processTime", this.processTime);
        compound.func_74783_a("processTimeMax", this.processTimeMax);
        if (this.replaced != null) {
            NBTTagCompound stackCompound = new NBTTagCompound();
            this.replaced.func_77955_b(stackCompound);
            compound.func_74782_a("replaced", (NBTBase)stackCompound);
        }
    }

    public void readCustomNBT(NBTTagCompound compound) {
        this.offset = compound.func_74759_k("offset");
        this.formed = compound.func_74767_n("formed");
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.processTime = compound.func_74759_k("processTime");
        if (this.processTime.length != 4) {
            this.processTime = new int[4];
        }
        this.processTimeMax = compound.func_74759_k("processTimeMax");
        if (this.processTimeMax.length != 4) {
            this.processTimeMax = new int[4];
        }
        if (compound.func_74764_b("replaced")) {
            NBTTagCompound stackCompound = compound.func_74775_l("replaced");
            this.replaced = ItemStack.func_77949_a((NBTTagCompound)stackCompound);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeCustomNBT(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
    }

    @Override
    public Object getContainer(int id, EntityPlayer player) {
        return new ContainerIndustrialCokeOven(this, player.field_71071_by);
    }

    @Override
    public Object getGuiContainer(int id, EntityPlayer player) {
        return new GuiIndustrialCokeOven((ContainerIndustrialCokeOven)((Object)this.getContainer(id, player)));
    }

    public boolean isMaster() {
        return this.isFormed() && this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0;
    }

    public TileIndustrialCokeOven getMaster() {
        if (!this.isFormed() || this.isMaster() || !this.func_145830_o()) {
            return null;
        }
        TileEntity master = this.field_145850_b.func_147438_o(this.field_145851_c - this.offset[0], this.field_145848_d - this.offset[1], this.field_145849_e - this.offset[2]);
        return master instanceof TileIndustrialCokeOven ? (TileIndustrialCokeOven)master : null;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int slot) {
        TileIndustrialCokeOven master = this.getMaster();
        if (master != null) {
            return master.func_70301_a(slot);
        }
        return slot < this.func_70302_i_() ? this.items[slot] : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        TileIndustrialCokeOven master = this.getMaster();
        if (master != null) {
            return master.func_70298_a(slot, amount);
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (this.isFormed()) {
            TileIndustrialCokeOven master = this.getMaster();
            if (master != null) {
                master.func_70299_a(slot, stack);
                return;
            }
            this.items[slot] = stack;
            this.func_70296_d();
        }
    }

    public String func_145825_b() {
        return "Industrial Coke Oven";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        TileIndustrialCokeOven master = this.getMaster();
        if (master != null) {
            return master.func_94041_b(slot, stack);
        }
        if (slot < 8) {
            if (slot % 2 == 1) {
                return CokeOvenRecipe.findRecipe((ItemStack)stack) != null;
            }
        } else {
            if (slot == 8) {
                return FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
            }
            if (slot == 9) {
                return FluidContainerRegistry.isFilledContainer((ItemStack)stack) && FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack).containsFluid(new FluidStack(IEContent.fluidCreosote, 1));
            }
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.isFormed()) {
            TileIndustrialCokeOven master = this.getMaster();
            if (master != null) {
                return this.getMaster().drain(from, resource, doDrain);
            }
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.isFormed()) {
            TileIndustrialCokeOven master = this.getMaster();
            if (master != null) {
                return this.getMaster().drain(from, maxDrain, doDrain);
            }
            FluidStack fluidStack = this.tank.drain(maxDrain, doDrain);
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return fluidStack;
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.isFormed();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.isFormed()) {
            TileIndustrialCokeOven master = this.getMaster();
            if (master != null) {
                return this.getMaster().getTankInfo(from);
            }
            return new FluidTankInfo[]{this.tank.getInfo()};
        }
        return new FluidTankInfo[0];
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public int getProgressFor(int i) {
        if (this.processTimeMax[i] == 0) {
            return 12;
        }
        return (int)((float)this.processTime[i] / (float)this.processTimeMax[i] * 12.0f);
    }

    public void func_70296_d() {
        super.func_70296_d();
        for (int i = 0; i < 4; ++i) {
            int slot = i * 2 + 1;
            if (this.processTime[i] <= 0) continue;
            CokeOvenRecipe recipe = CokeOvenRecipe.findRecipe((ItemStack)this.func_70301_a(slot));
            if (this.isValidRecipe(recipe, i)) {
                this.processTimeMax[i] = (int)((float)recipe.time * ImmersiveIntegration.cfg.cokeOvenTimeMultiplier);
                continue;
            }
            this.processTime[i] = 0;
            this.processTimeMax[i] = 0;
        }
    }

    public int[] func_94128_d(int side) {
        if (this.isFormed()) {
            int z;
            ForgeDirection sideDir = ForgeDirection.getOrientation((int)side);
            if (Math.abs(sideDir.offsetX) != Math.abs(this.getFacing().offsetX) || Math.abs(sideDir.offsetZ) != Math.abs(this.getFacing().offsetZ)) {
                return new int[0];
            }
            int mult = this.getFacing().offsetX != 0 ? this.getFacing().offsetX : -this.getFacing().offsetZ;
            int x = this.getFacing().offsetX != 0 ? 2 : 0;
            int n = z = this.getFacing().offsetX != 0 ? 0 : 2;
            if (this.offset[1] == -1) {
                if (this.offset[z] == 0 && this.offset[x] == -3 * mult || Math.abs(this.offset[z]) == 4 && this.offset[x] == 3 * mult) {
                    return new int[]{0, 2, 4, 6, 8, 9, 7};
                }
                if (this.offset[z] == 0 && this.offset[x] == -1 * mult || Math.abs(this.offset[z]) == 4 && this.offset[x] == mult) {
                    return new int[]{0, 2, 4, 6, 8, 9, 5};
                }
                if (this.offset[z] == 0 && this.offset[x] == mult || Math.abs(this.offset[z]) == 4 && this.offset[x] == -1 * mult) {
                    return new int[]{0, 2, 4, 6, 8, 9, 3};
                }
                if (this.offset[z] == 0 && this.offset[x] == 3 * mult || Math.abs(this.offset[z]) == 4 && this.offset[x] == -3 * mult) {
                    return new int[]{0, 2, 4, 6, 8, 9, 1};
                }
            }
        }
        return new int[0];
    }

    public ForgeDirection getFacing() {
        return ForgeDirection.getOrientation((int)this.offset[3]);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.isFormed() && slot != 9 && this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return this.isFormed() && (slot % 2 == 0 && slot < 8 || slot == 9);
    }
}

