/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.tiles;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;
import unwrittenfun.minecraft.immersiveintegration.utils.TileUtils;

public class TileInductionChargerLV
extends TileEntity
implements IEnergyReceiver,
IEBlockInterfaces.IBlockOverlayText {
    public ItemStack chargingStack;
    public EntityItem chargingStackEntity;
    public EnergyStorage energyStorage = new EnergyStorage(this.getCapacity(), this.getMaxInOut());
    protected int syncTicks = 0;

    public void func_145845_h() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.chargingStack != null) {
            IEnergyContainerItem energyContainer = (IEnergyContainerItem)this.chargingStack.func_77973_b();
            int energyToInsert = this.energyStorage.extractEnergy(this.getMaxInOut(), true);
            int energyExtracted = energyContainer.receiveEnergy(this.chargingStack, energyToInsert, false);
            this.energyStorage.extractEnergy(energyExtracted, false);
            if (this.syncTicks >= 20) {
                this.syncTicks = 0;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            ++this.syncTicks;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.chargingStack != null) {
            TileUtils.dropItemStack(this.chargingStack, this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        }
    }

    public int getCapacity() {
        return Config.getInt((String)"capacitorLV_storage") / 2;
    }

    public int getMaxInOut() {
        return Config.getInt((String)"capacitorLV_input");
    }

    public void setChargingStack(ItemStack stack) {
        if (stack == null) {
            this.chargingStack = null;
        } else {
            this.chargingStack = stack.func_77946_l();
            this.chargingStack.field_77994_a = 1;
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeDataToNBT(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readDataFromNBT(compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readDataFromNBT(pkt.func_148857_g());
        if (this.chargingStack == null) {
            this.chargingStackEntity = null;
        } else {
            this.chargingStackEntity = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.chargingStack);
            this.chargingStackEntity.field_70290_d = 0.0f;
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeDataToNBT(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, compound);
    }

    public void writeDataToNBT(NBTTagCompound compound) {
        if (this.chargingStack != null) {
            NBTTagCompound stackCompound = new NBTTagCompound();
            this.chargingStack.func_77955_b(stackCompound);
            compound.func_74782_a("ChargingStack", (NBTBase)stackCompound);
        }
        this.energyStorage.writeToNBT(compound);
    }

    public void readDataFromNBT(NBTTagCompound compound) {
        this.chargingStack = compound.func_74764_b("ChargingStack") ? ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("ChargingStack")) : null;
        this.energyStorage.readFromNBT(compound);
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP;
    }

    public String[] getOverlayText(EntityPlayer player, MovingObjectPosition mop, boolean hammer) {
        if (this.chargingStack != null) {
            IEnergyContainerItem energyContainer = (IEnergyContainerItem)this.chargingStack.func_77973_b();
            return new String[]{this.chargingStack.func_82833_r(), energyContainer.getEnergyStored(this.chargingStack) + "/" + energyContainer.getMaxEnergyStored(this.chargingStack) + "RF"};
        }
        return new String[0];
    }
}

