/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.ClientProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BlockLoader;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.tileentities.TileEntityCookieJar;
import jds.bibliocraft.tileentities.TileEntityDinnerPlate;
import jds.bibliocraft.tileentities.TileEntityDiscRack;
import jds.bibliocraft.tileentities.TileEntityMarkerPole;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.FoodStats;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockStuff
extends Block {
    private int vertAngleSetter = 0;
    private int clicks = 0;

    public BlockStuff() {
        super(Material.field_151576_e);
        this.func_149647_a(BlockLoader.biblioTab);
        this.func_149672_a(Block.field_149766_f);
        this.func_149675_a(true);
    }

    public float func_149712_f(World world, int i, int j, int k) {
        int metadata = world.func_72805_g(i, j, k);
        switch (metadata) {
            case 0: {
                return 2.0f;
            }
            case 1: {
                return 1.0f;
            }
        }
        return 3.0f;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int face, float hitX, float hitY, float hitZ) {
        ItemStack inhand;
        int metadata = world.func_72805_g(i, j, k);
        if (!world.field_72995_K) {
            ItemStack drillTest = player.func_70694_bm();
            if (drillTest != null && drillTest.func_77973_b() instanceof ItemDrill) {
                return false;
            }
            switch (metadata) {
                case 0: {
                    TileEntityCookieJar cookiejar = (TileEntityCookieJar)world.func_147438_o(i, j, k);
                    if (cookiejar != null) {
                        cookiejar.setIsOpen(true);
                        world.func_147464_a(i, j, k, (Block)this, this.func_149738_a(world));
                    }
                    player.openGui((Object)BiblioCraft.instance, 0, world, i, j, k);
                    return true;
                }
                case 2: {
                    this.activateDinnerPlate(world, i, j, k, player, face, hitX, hitY, hitZ);
                    return true;
                }
                case 3: {
                    this.activateDiscRack(world, i, j, k, player, face, hitX, hitY, hitZ);
                    return true;
                }
            }
            return true;
        }
        return metadata != 3 || !world.field_72995_K || (inhand = player.func_70694_bm()) == null || !(inhand.func_77973_b() instanceof ItemDrill);
    }

    public void activateDiscRack(World world, int i, int j, int k, EntityPlayer player, int face, float hitX, float hitY, float hitZ) {
        ItemStack playerStack = player.func_70694_bm();
        TileEntityDiscRack rackTile = (TileEntityDiscRack)world.func_147438_o(i, j, k);
        if (rackTile != null) {
            int angle = rackTile.getAngle();
            int vertAngle = rackTile.getVertAngle();
            boolean isRotated = rackTile.getWallRotation();
            int discSlot = this.getDiscSlot(hitX, hitY, hitZ, angle, vertAngle, isRotated);
            if (playerStack != null) {
                String discName = playerStack.func_77977_a().toLowerCase();
                if ((playerStack.func_77973_b() instanceof ItemRecord || Config.testDiscValidity(discName)) && rackTile.addDisc(discSlot, playerStack)) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    return;
                }
            } else if (player.func_70093_af() && this.dropDiscItem(world, i, j, k, rackTile, this.getDiscSlot(hitX, hitY, hitZ, angle, vertAngle, isRotated))) {
                rackTile.func_70299_a(discSlot, null);
                return;
            }
        }
        player.openGui((Object)BiblioCraft.instance, 0, world, i, j, k);
    }

    public int getDiscSlot(float hitX, float hitY, float hitZ, int angle, int vertAngle, boolean wallRotated) {
        int discSlot = 0;
        block0 : switch (vertAngle) {
            case 0: {
                switch (angle) {
                    case 0: {
                        discSlot = this.getDiscSlotPos(hitX);
                        break;
                    }
                    case 1: {
                        discSlot = this.getDiscSlotNeg(hitZ);
                        break;
                    }
                    case 2: {
                        discSlot = this.getDiscSlotNeg(hitX);
                        break;
                    }
                    case 3: {
                        discSlot = this.getDiscSlotPos(hitZ);
                    }
                }
                break;
            }
            case 1: {
                if (!wallRotated) {
                    discSlot = this.getDiscSlotPos(hitY);
                    break;
                }
                switch (angle) {
                    case 0: {
                        discSlot = this.getDiscSlotPos(hitZ);
                        break;
                    }
                    case 1: {
                        discSlot = this.getDiscSlotNeg(hitX);
                        break;
                    }
                    case 2: {
                        discSlot = this.getDiscSlotNeg(hitZ);
                        break;
                    }
                    case 3: {
                        discSlot = this.getDiscSlotPos(hitX);
                    }
                }
                break;
            }
            case 2: {
                switch (angle) {
                    case 0: {
                        discSlot = this.getDiscSlotNeg(hitX);
                        break block0;
                    }
                    case 1: {
                        discSlot = this.getDiscSlotPos(hitZ);
                        break block0;
                    }
                    case 2: {
                        discSlot = this.getDiscSlotPos(hitX);
                        break block0;
                    }
                    case 3: {
                        discSlot = this.getDiscSlotNeg(hitZ);
                    }
                }
            }
        }
        return discSlot;
    }

    public int getDiscSlotPos(float hit) {
        if (hit >= 0.87f) {
            return 8;
        }
        if (hit < 0.87f && hit >= 0.766f) {
            return 7;
        }
        if (hit < 0.766f && hit >= 0.662f) {
            return 6;
        }
        if (hit < 0.662f && hit >= 0.558f) {
            return 5;
        }
        if (hit < 0.558f && hit >= 0.454f) {
            return 4;
        }
        if (hit < 0.454f && hit >= 0.35f) {
            return 3;
        }
        if (hit < 0.35f && hit >= 0.246f) {
            return 2;
        }
        if (hit < 0.246f && hit >= 0.142f) {
            return 1;
        }
        if (hit < 0.142f) {
            return 0;
        }
        return 0;
    }

    public int getDiscSlotNeg(float hit) {
        if (hit >= 0.87f) {
            return 0;
        }
        if (hit < 0.87f && hit >= 0.766f) {
            return 1;
        }
        if (hit < 0.766f && hit >= 0.662f) {
            return 2;
        }
        if (hit < 0.662f && hit >= 0.558f) {
            return 3;
        }
        if (hit < 0.558f && hit >= 0.454f) {
            return 4;
        }
        if (hit < 0.454f && hit >= 0.35f) {
            return 5;
        }
        if (hit < 0.35f && hit >= 0.246f) {
            return 6;
        }
        if (hit < 0.246f && hit >= 0.142f) {
            return 7;
        }
        if (hit < 0.142f) {
            return 8;
        }
        return 0;
    }

    private boolean dropDiscItem(World world, int i, int j, int k, TileEntityDiscRack rackTile, int slot) {
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (!(tileEntity instanceof IInventory)) {
            return false;
        }
        IInventory inventory = (IInventory)tileEntity;
        ItemStack stuff = rackTile.func_70301_a(slot);
        if (stuff != null && stuff.field_77994_a > 0) {
            float iAdjust = 0.0f;
            EntityItem entityItem = new EntityItem(world, (double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), new ItemStack(stuff.func_77973_b(), stuff.field_77994_a, stuff.func_77960_j()));
            if (stuff.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)stuff.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityItem);
            stuff.field_77994_a = 0;
            return true;
        }
        return false;
    }

    public void activateDinnerPlate(World world, int i, int j, int k, EntityPlayer player, int face, float hitX, float hitY, float hitZ) {
        ItemStack playerStack = player.func_70694_bm();
        TileEntityDinnerPlate plateTile = (TileEntityDinnerPlate)world.func_147438_o(i, j, k);
        if (plateTile != null) {
            int addedFood;
            if (playerStack != null && playerStack.func_77973_b() instanceof ItemFood && (addedFood = plateTile.addFood(playerStack)) != -1) {
                if (addedFood == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                } else {
                    ItemStack newStack = playerStack.func_77946_l();
                    newStack.field_77994_a = addedFood;
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newStack);
                }
                return;
            }
            if (plateTile.isPlateEmpty() || player.func_70093_af()) {
                player.openGui((Object)BiblioCraft.instance, 0, world, i, j, k);
                return;
            }
            FoodStats playerFoodStats = player.func_71024_bL();
            if (playerFoodStats.func_75121_c()) {
                ++this.clicks;
                switch (this.clicks) {
                    case 1: {
                        world.func_72956_a((Entity)player, "random.eat", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        break;
                    }
                    case 2: {
                        world.func_72956_a((Entity)player, "random.eat", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        break;
                    }
                    case 3: {
                        world.func_72956_a((Entity)player, "random.eat", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        break;
                    }
                    default: {
                        ItemStack food2;
                        ItemStack food1;
                        ItemStack food0;
                        ItemStack slot0 = plateTile.func_70301_a(0);
                        ItemStack slot1 = plateTile.func_70301_a(1);
                        ItemStack slot2 = plateTile.func_70301_a(2);
                        if (slot0 != null && playerFoodStats.func_75121_c() && slot0.func_77973_b() instanceof ItemFood && plateTile.isFoodHaveBowl(food0 = plateTile.getFood(0), world, player)) {
                            this.dropEmptyBowl(world, i, j, k);
                        }
                        if (slot1 != null && playerFoodStats.func_75121_c() && slot1.func_77973_b() instanceof ItemFood && plateTile.isFoodHaveBowl(food1 = plateTile.getFood(1), world, player)) {
                            this.dropEmptyBowl(world, i, j, k);
                        }
                        if (slot2 != null && playerFoodStats.func_75121_c() && slot2.func_77973_b() instanceof ItemFood && plateTile.isFoodHaveBowl(food2 = plateTile.getFood(2), world, player)) {
                            this.dropEmptyBowl(world, i, j, k);
                        }
                        world.func_72956_a((Entity)player, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        this.clicks = 0;
                        break;
                    }
                }
            }
        }
    }

    private void dropEmptyBowl(World world, int i, int j, int k) {
        ItemStack bowl = new ItemStack(Items.field_151054_z, 0);
        bowl.field_77994_a = 1;
        if (bowl != null && bowl.field_77994_a > 0) {
            float iAdjust = 0.0f;
            EntityItem entityItem = new EntityItem(world, (double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), new ItemStack(bowl.func_77973_b(), bowl.field_77994_a, bowl.func_77960_j()));
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityItem);
            bowl.field_77994_a = 0;
        }
    }

    public void func_149719_a(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntity tileEntity = blockAccess.func_147438_o(i, j, k);
        if (tileEntity != null) {
            int meta = tileEntity.func_145832_p();
            switch (meta) {
                case 0: {
                    this.func_149676_a(0.18f, 0.0f, 0.18f, 0.82f, 0.75f, 0.82f);
                    break;
                }
                case 1: {
                    this.func_149676_a(0.45f, 0.45f, 0.45f, 0.55f, 0.55f, 0.55f);
                    break;
                }
                case 2: {
                    this.func_149676_a(0.15f, 0.0f, 0.15f, 0.85f, 0.1f, 0.85f);
                    break;
                }
                case 3: {
                    if (tileEntity instanceof TileEntityDiscRack) {
                        TileEntityDiscRack rackTile = (TileEntityDiscRack)tileEntity;
                        this.setDiscRackBlockBounds(rackTile);
                        break;
                    }
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                default: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
    }

    public void setDiscRackBlockBounds(TileEntityDiscRack rackTile) {
        int rackAngle = rackTile.getAngle();
        int vertRackAngle = rackTile.getVertAngle();
        boolean rotated = rackTile.getWallRotation();
        block0 : switch (rackAngle) {
            case 0: {
                switch (vertRackAngle) {
                    case 0: {
                        this.func_149676_a(0.0f, 0.0f, 0.25f, 1.0f, 0.35f, 0.75f);
                        break;
                    }
                    case 1: {
                        if (!rotated) {
                            this.func_149676_a(0.65f, 0.0f, 0.25f, 1.0f, 1.0f, 0.75f);
                            break;
                        }
                        this.func_149676_a(0.65f, 0.25f, 0.0f, 1.0f, 0.75f, 1.0f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.0f, 0.65f, 0.25f, 1.0f, 1.0f, 0.75f);
                    }
                }
                break;
            }
            case 1: {
                switch (vertRackAngle) {
                    case 0: {
                        this.func_149676_a(0.25f, 0.0f, 0.0f, 0.75f, 0.35f, 1.0f);
                        break;
                    }
                    case 1: {
                        if (!rotated) {
                            this.func_149676_a(0.25f, 0.0f, 0.65f, 0.75f, 1.0f, 1.0f);
                            break;
                        }
                        this.func_149676_a(0.0f, 0.25f, 0.65f, 1.0f, 0.75f, 1.0f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.25f, 0.65f, 0.0f, 0.75f, 1.0f, 1.0f);
                    }
                }
                break;
            }
            case 2: {
                switch (vertRackAngle) {
                    case 0: {
                        this.func_149676_a(0.0f, 0.0f, 0.25f, 1.0f, 0.35f, 0.75f);
                        break;
                    }
                    case 1: {
                        if (!rotated) {
                            this.func_149676_a(0.0f, 0.0f, 0.25f, 0.35f, 1.0f, 0.75f);
                            break;
                        }
                        this.func_149676_a(0.0f, 0.25f, 0.0f, 0.35f, 0.75f, 1.0f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.0f, 0.65f, 0.25f, 1.0f, 1.0f, 0.75f);
                    }
                }
                break;
            }
            case 3: {
                switch (vertRackAngle) {
                    case 0: {
                        this.func_149676_a(0.25f, 0.0f, 0.0f, 0.75f, 0.35f, 1.0f);
                        break block0;
                    }
                    case 1: {
                        if (!rotated) {
                            this.func_149676_a(0.25f, 0.0f, 0.0f, 0.75f, 1.0f, 0.35f);
                            break block0;
                        }
                        this.func_149676_a(0.0f, 0.25f, 0.0f, 1.0f, 0.75f, 0.35f);
                        break block0;
                    }
                    case 2: {
                        this.func_149676_a(0.25f, 0.65f, 0.0f, 0.75f, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase player, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ++angle;
        angle %= 4;
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null) {
            if (tile instanceof TileEntityDinnerPlate) {
                TileEntityDinnerPlate pt = (TileEntityDinnerPlate)tile;
                pt.setAngle(angle);
            }
            if (tile instanceof TileEntityDiscRack) {
                TileEntityDiscRack dt = (TileEntityDiscRack)tile;
                dt.setAngle(angle);
                dt.setVertAngle(this.vertAngleSetter);
            }
        }
    }

    public int func_149660_a(World world, int i, int j, int k, int side, float hitX, float hitY, float hitZ, int meta) {
        this.vertAngleSetter = side == 0 ? 2 : (side == 1 ? 0 : 1);
        return meta;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs tab, List subItems) {
        if (Config.enableCookieJar) {
            subItems.add(new ItemStack((Block)this, 1, 0));
        }
        if (Config.enableDinnerPlate) {
            subItems.add(new ItemStack((Block)this, 1, 2));
        }
        if (Config.enableDiscRack) {
            subItems.add(new ItemStack((Block)this, 1, 3));
        }
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.stuffRenderID;
    }

    public void func_149749_a(World world, int i, int j, int k, Block par5, int meta) {
        this.dropItems(world, i, j, k);
        world.func_147475_p(i, j, k);
        super.func_149749_a(world, i, j, k, par5, meta);
    }

    private void dropItems(World world, int i, int j, int k) {
        Random rando = new Random();
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int x = 0; x < inventory.func_70302_i_(); ++x) {
            ItemStack item = inventory.func_70301_a(x);
            if (item == null || item.field_77994_a <= 0) continue;
            float ri = rando.nextFloat() * 0.8f + 0.1f;
            float rj = rando.nextFloat() * 0.8f + 0.1f;
            float rk = rando.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)i + ri), (double)((float)j + rj), (double)((float)k + rk), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rando.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rando.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rando.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public boolean hasTileEntity(int metadata) {
        switch (metadata) {
            case 0: {
                if (!Config.enableCookieJar) break;
                return true;
            }
            case 1: {
                if (!Config.enableTapemeasure) break;
                return true;
            }
            case 2: {
                if (!Config.enableDinnerPlate) break;
                return true;
            }
            case 3: {
                if (!Config.enableDiscRack) break;
                return true;
            }
        }
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                if (!Config.enableCookieJar) break;
                return new TileEntityCookieJar();
            }
            case 1: {
                if (!Config.enableTapemeasure) break;
                return new TileEntityMarkerPole();
            }
            case 2: {
                if (!Config.enableDinnerPlate) break;
                return new TileEntityDinnerPlate();
            }
            case 3: {
                if (!Config.enableDiscRack) break;
                return new TileEntityDiscRack();
            }
        }
        return null;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("glass");
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess blocka, int i, int j, int k, int face) {
        int metadata = blocka.func_72805_g(i, j, k);
        if (metadata == 0) {
            boolean ison;
            TileEntityCookieJar cookiejar = (TileEntityCookieJar)blocka.func_147438_o(i, j, k);
            if (cookiejar != null && (ison = cookiejar.getIsOpen())) {
                return 15;
            }
            return 0;
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess blocka, int i, int j, int k, int face) {
        return this.func_149709_b(blocka, i, j, k, face);
    }

    public int func_149738_a(World par1World) {
        return 30;
    }

    public void func_149674_a(World world, int i, int j, int k, Random par5Random) {
        boolean ison;
        TileEntityCookieJar cookiejar;
        int metadata;
        if (!world.field_72995_K && (metadata = world.func_72805_g(i, j, k)) == 0 && (cookiejar = (TileEntityCookieJar)world.func_147438_o(i, j, k)) != null && (ison = cookiejar.getIsOpen())) {
            cookiejar.setIsOpen(false);
        }
    }

    public Item func_149650_a(int meta, Random rando, int par3) {
        if (meta == 1) {
            return Item.func_150898_a((Block)Blocks.field_150350_a);
        }
        return Item.func_150898_a((Block)this);
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            int blocktype = tile.field_145847_g;
            switch (blocktype) {
                case 2: {
                    if (!(tile instanceof TileEntityDinnerPlate)) break;
                    TileEntityDinnerPlate te = (TileEntityDinnerPlate)tile;
                    int angle = te.getAngle();
                    switch (axis) {
                        case DOWN: {
                            if (angle <= 0) {
                                te.setAngle(3);
                                break;
                            }
                            te.setAngle(angle - 1);
                            break;
                        }
                        case UP: {
                            if (angle >= 3) {
                                te.setAngle(0);
                                break;
                            }
                            te.setAngle(angle + 1);
                            break;
                        }
                        case UNKNOWN: {
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    return true;
                }
                case 3: {
                    if (!(tile instanceof TileEntityDiscRack)) break;
                    TileEntityDiscRack te = (TileEntityDiscRack)tile;
                    int angle = te.getAngle();
                    switch (axis) {
                        case DOWN: {
                            if (angle <= 0) {
                                te.setAngle(3);
                                break;
                            }
                            te.setAngle(angle - 1);
                            break;
                        }
                        case UP: {
                            if (angle >= 3) {
                                te.setAngle(0);
                                break;
                            }
                            te.setAngle(angle + 1);
                            break;
                        }
                        case UNKNOWN: {
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        int meta = worldObj.func_72805_g(x, y, z);
        if (meta == 2 || meta == 3) {
            ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
            return axises;
        }
        return null;
    }
}

