/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import micdoodle8.mods.galacticraft.api.recipe.CircuitFabricatorRecipes;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityCircuitFabricator
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IPacketReceiver {
    public static final int PROCESS_TIME_REQUIRED = 300;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack producingStack = null;
    private long ticks;
    private ItemStack[] containingItems = new ItemStack[7];

    public TileEntityCircuitFabricator() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 40.0f : 20.0f);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.updateInput();
        if (!this.field_145850_b.field_72995_K) {
            boolean updateInv = false;
            if (this.hasEnoughEnergyToRun) {
                if (this.canCompress()) {
                    ++this.processTicks;
                    if (this.processTicks == 300) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.anvil_land", 0.2f, 0.5f);
                        this.processTicks = 0;
                        this.compressItems();
                        updateInv = true;
                    }
                } else {
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 0L;
        }
        ++this.ticks;
    }

    public void updateInput() {
        this.producingStack = CircuitFabricatorRecipes.getOutputForInput(Arrays.copyOfRange(this.containingItems, 1, 6));
    }

    private boolean canCompress() {
        ItemStack itemstack = this.producingStack;
        if (itemstack == null) {
            return false;
        }
        if (this.containingItems[6] == null) {
            return true;
        }
        if (this.containingItems[6] != null && !this.containingItems[6].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.containingItems[6] == null ? 0 : this.containingItems[6].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public void compressItems() {
        if (this.canCompress()) {
            ItemStack resultItemStack = this.producingStack;
            if (this.containingItems[6] == null) {
                this.containingItems[6] = resultItemStack.func_77946_l();
            } else if (this.containingItems[6].func_77969_a(resultItemStack)) {
                if (this.containingItems[6].field_77994_a + resultItemStack.field_77994_a > 64) {
                    for (int i = 0; i < this.containingItems[6].field_77994_a + resultItemStack.field_77994_a - 64; ++i) {
                        float var = 0.7f;
                        double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + dx, (double)this.field_145848_d + dy, (double)this.field_145849_e + dz, new ItemStack(resultItemStack.func_77973_b(), 1, resultItemStack.func_77960_j()));
                        entityitem.field_145804_b = 10;
                        this.field_145850_b.func_72838_d((Entity)entityitem);
                    }
                }
                this.containingItems[6].field_77994_a += resultItemStack.field_77994_a;
            }
        }
        for (int i = 1; i < 6; ++i) {
            this.func_70298_a(i, 1);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("tile.machine2.5.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return itemStack != null && ItemElectricBase.isElectricItem(itemStack.func_77973_b());
        }
        if (slotID > 5) {
            return false;
        }
        ArrayList<ItemStack> list = CircuitFabricatorRecipes.slotValidItems.get(slotID - 1);
        for (ItemStack test : list) {
            if (!test.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        boolean siliconFlag;
        if (side == 0) {
            return new int[]{6};
        }
        boolean bl = siliconFlag = this.containingItems[2] != null && (this.containingItems[3] == null || this.containingItems[3].field_77994_a < this.containingItems[2].field_77994_a);
        if (siliconFlag) {
            int[] nArray2 = new int[5];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArray = nArray2;
            nArray2[4] = 5;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 4;
            nArray = nArray3;
            nArray3[4] = 5;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID < 6 && this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID == 6;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }
}

