/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.IPlantableBlock;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBasicMoon
extends BlockAdvancedTile
implements IDetectableResource,
IPlantableBlock,
ITerraformableBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] moonBlockIcons;

    public BlockBasicMoon() {
        super(Material.field_151576_e);
        this.field_149782_v = 1.5f;
        this.field_149781_w = 2.5f;
        this.func_149663_c("moonBlock");
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 15) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z);
        }
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 15) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z);
        }
        return super.func_149633_g(world, x, y, z);
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 15) {
            return false;
        }
        return super.isNormalCube(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.moonBlockIcons = new IIcon[17];
        this.moonBlockIcons[0] = par1IconRegister.func_94245_a("galacticraftmoon:top");
        this.moonBlockIcons[1] = par1IconRegister.func_94245_a("galacticraftmoon:brick");
        this.moonBlockIcons[2] = par1IconRegister.func_94245_a("galacticraftmoon:middle");
        this.moonBlockIcons[3] = par1IconRegister.func_94245_a("galacticraftmoon:top_side");
        this.moonBlockIcons[4] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_1");
        this.moonBlockIcons[5] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_2");
        this.moonBlockIcons[6] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_3");
        this.moonBlockIcons[7] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_4");
        this.moonBlockIcons[8] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_5");
        this.moonBlockIcons[9] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_6");
        this.moonBlockIcons[10] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_7");
        this.moonBlockIcons[11] = par1IconRegister.func_94245_a("galacticraftmoon:grass_step_8");
        this.moonBlockIcons[12] = par1IconRegister.func_94245_a("galacticraftmoon:moonore_copper");
        this.moonBlockIcons[13] = par1IconRegister.func_94245_a("galacticraftmoon:moonore_tin");
        this.moonBlockIcons[14] = par1IconRegister.func_94245_a("galacticraftmoon:moonore_cheese");
        this.moonBlockIcons[15] = par1IconRegister.func_94245_a("galacticraftmoon:bottom");
        this.moonBlockIcons[16] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "blank");
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 15) {
            return 10000.0f;
        }
        if (metadata == 14) {
            return 40.0f;
        }
        if (metadata == 4) {
            return 6.0f;
        }
        if (metadata < 3) {
            return 3.0f;
        }
        return this.field_149781_w / 5.0f;
    }

    public float func_149712_f(World par1World, int par2, int par3, int par4) {
        int meta = par1World.func_72805_g(par2, par3, par4);
        if (meta == 3 || meta >= 5 && meta <= 13) {
            return 0.5f;
        }
        if (meta == 14) {
            return 4.0f;
        }
        if (meta > 13) {
            return -1.0f;
        }
        if (meta < 2) {
            return 5.0f;
        }
        if (meta == 2) {
            return 3.0f;
        }
        return this.field_149782_v;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        if (meta == 3 || meta >= 5 && meta <= 13) {
            return true;
        }
        return super.canHarvestBlock(player, meta);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta >= 5 && meta <= 13) {
            if (side != 1) {
                if (side != 0) return this.moonBlockIcons[3];
                return this.moonBlockIcons[2];
            }
            switch (meta - 5) {
                case 0: {
                    return this.moonBlockIcons[0];
                }
                case 1: {
                    return this.moonBlockIcons[4];
                }
                case 2: {
                    return this.moonBlockIcons[5];
                }
                case 3: {
                    return this.moonBlockIcons[6];
                }
                case 4: {
                    return this.moonBlockIcons[7];
                }
                case 5: {
                    return this.moonBlockIcons[8];
                }
                case 6: {
                    return this.moonBlockIcons[9];
                }
                case 7: {
                    return this.moonBlockIcons[10];
                }
                case 8: {
                    return this.moonBlockIcons[11];
                }
            }
            return null;
        }
        switch (meta) {
            case 0: {
                return this.moonBlockIcons[12];
            }
            case 1: {
                return this.moonBlockIcons[13];
            }
            case 2: {
                return this.moonBlockIcons[14];
            }
            case 3: {
                return this.moonBlockIcons[2];
            }
            case 4: {
                return this.moonBlockIcons[15];
            }
            case 14: {
                return this.moonBlockIcons[1];
            }
            case 15: {
                return this.moonBlockIcons[16];
            }
        }
        return this.moonBlockIcons[16];
    }

    public Item func_149650_a(int meta, Random random, int par3) {
        switch (meta) {
            case 2: {
                return GCItems.cheeseCurd;
            }
            case 15: {
                return Item.func_150898_a((Block)Blocks.field_150350_a);
            }
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_149692_a(int meta) {
        if (meta >= 5 && meta <= 13) {
            return 5;
        }
        if (meta == 2) {
            return 0;
        }
        return meta;
    }

    public int func_149643_k(World p_149643_1_, int p_149643_2_, int p_149643_3_, int p_149643_4_) {
        return p_149643_1_.func_72805_g(p_149643_2_, p_149643_3_, p_149643_4_);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        switch (meta) {
            case 2: {
                if (fortune >= 1) {
                    return random.nextFloat() < (float)fortune * 0.29f - 0.25f ? 2 : 1;
                }
                return 1;
            }
            case 15: {
                return 0;
            }
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        int var4;
        for (var4 = 0; var4 < 6; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
        for (var4 = 14; var4 < 15; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 15) {
            return new TileEntityDungeonSpawner();
        }
        return null;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 15;
    }

    @Override
    public boolean isValueable(int metadata) {
        switch (metadata) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata < 5 && metadata > 13) {
            return false;
        }
        plantable.getPlant(world, x, y + 1, z);
        return plantable instanceof BlockFlower;
    }

    @Override
    public int requiredLiquidBlocksNearby() {
        return 4;
    }

    @Override
    public boolean isPlantable(int metadata) {
        return metadata >= 5 && metadata <= 13;
    }

    @Override
    public boolean isTerraformable(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 5 && meta <= 13) {
            return !world.func_147439_a(x, y + 1, z).func_149662_c();
        }
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 2) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, metadata);
        }
        if (metadata == 15) {
            return null;
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        long chunkKey;
        List<Footprint> footprintList;
        Map<Long, List<Footprint>> footprintChunkMap;
        super.func_149749_a(world, x, y, z, block, par6);
        if (!world.field_72995_K && block == this && par6 == 5 && (footprintChunkMap = TickHandlerServer.serverFootprintMap.get(world.field_73011_w.field_76574_g)) != null && (footprintList = footprintChunkMap.get(chunkKey = ChunkCoordIntPair.func_77272_a((int)(x >> 4), (int)(z >> 4)))) != null && !footprintList.isEmpty()) {
            ArrayList<Footprint> toRemove = new ArrayList<Footprint>();
            for (Footprint footprint : footprintList) {
                if (!(footprint.position.x > (double)x) || !(footprint.position.x < (double)(x + 1)) || !(footprint.position.z > (double)z) || !(footprint.position.z < (double)(z + 1))) continue;
                toRemove.add(footprint);
            }
            if (!toRemove.isEmpty()) {
                footprintList.removeAll(toRemove);
                footprintChunkMap.put(chunkKey, footprintList);
                TickHandlerServer.serverFootprintMap.put(world.field_73011_w.field_76574_g, footprintChunkMap);
                TickHandlerServer.footprintRefreshList.add(new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 50.0));
            }
        }
    }

    public boolean isReplaceableOreGen(World world, int x, int y, int z, Block target) {
        if (target != Blocks.field_150348_b) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        return meta == 3 || meta == 4;
    }
}

