/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils;

import com.rwtema.extrautils.network.NetworkHandler;
import com.rwtema.extrautils.network.packets.PacketTime;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class CommandTPSTimer
extends CommandBase {
    public static final CommandTPSTimer INSTANCE = new CommandTPSTimer();
    public static HashSet<String> playerSet = new HashSet();
    private static long[] clientTimer = new long[100];
    private static int clientCounter = 0;
    private static String displayString = "";
    public boolean display = false;

    public static void init() {
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
    }

    public static void add(String commandSenderName) {
        EntityPlayer playerInstance = null;
        for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            EntityPlayer player = (EntityPlayer)o;
            if (!commandSenderName.equals(player.func_70005_c_())) continue;
            playerInstance = player;
        }
        if (playerInstance == null) {
            return;
        }
        if (playerSet.contains(commandSenderName)) {
            playerSet.remove(commandSenderName);
            NetworkHandler.sendPacketToPlayer(new PacketTime(0L, 255), playerInstance);
        } else {
            playerSet.add(commandSenderName);
        }
    }

    public static void update(int counter, long time) {
        if (counter >= 100 || counter < 0) {
            CommandTPSTimer.INSTANCE.display = false;
            return;
        }
        CommandTPSTimer.INSTANCE.display = true;
        while (clientCounter != counter) {
            if (++clientCounter >= 100) {
                clientCounter = 0;
            }
            CommandTPSTimer.clientTimer[CommandTPSTimer.clientCounter] = time;
        }
        displayString = CommandTPSTimer.getDisplayString();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || playerSet.isEmpty()) {
            return;
        }
        MinecraftServer server = MinecraftServer.func_71276_C();
        int counter = server.func_71259_af() % 100;
        long[] longs = server.field_71311_j;
        if (longs == null) {
            return;
        }
        for (Object o : server.func_71203_ab().field_72404_b) {
            EntityPlayer player = (EntityPlayer)o;
            if (!playerSet.contains(player.func_70005_c_())) continue;
            NetworkHandler.sendPacketToPlayer(new PacketTime(longs[counter], counter), player);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDraw(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !this.display || displayString.length() == 0) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71441_e == null) {
            displayString = "";
            return;
        }
        FontRenderer fontrenderer = minecraft.field_71466_p;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74518_a();
        fontrenderer.func_85187_a(displayString, 0, 0, -1, true);
    }

    public static String getDisplayString() {
        long sum = 0L;
        long max = 0L;
        for (long l : clientTimer) {
            sum += l;
            max = Math.max(max, l);
        }
        return "TPS: " + CommandTPSTimer.formatTimer(clientTimer[clientCounter]) + ", " + CommandTPSTimer.formatTimer(sum / (long)clientTimer.length) + ", " + CommandTPSTimer.formatTimer(max);
    }

    public static String formatTimer(double time) {
        double tps = Math.min(1000.0 / (time * 1.0E-6), 20.0);
        boolean tpsDown = tps != 20.0;
        return String.format(Locale.ENGLISH, "%5.2f", time * 1.0E-6) + "(" + (tpsDown ? EnumChatFormatting.RED : "") + String.format(Locale.ENGLISH, "%5.2f", tps) + (tpsDown ? EnumChatFormatting.RESET : "") + ")";
    }

    public boolean func_71519_b(ICommandSender p_71519_1_) {
        return true;
    }

    public String func_71517_b() {
        return "xu_tps";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "xu_tps";
    }

    public void func_71515_b(ICommandSender p_71515_1_, String[] p_71515_2_) {
        displayString = "";
        NetworkHandler.sendPacketToServer(new PacketTime());
    }
}

