/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.tileentities;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import ic2.api.reactor.IReactor;
import ic2.core.IC2;
import ic2.core.block.reactor.tileentity.TileEntityReactorChamberElectric;
import ic2.core.network.NetworkManager;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.IRotation;
import shedar.mods.ic2.nuclearcontrol.ISlotItemFilter;
import shedar.mods.ic2.nuclearcontrol.items.ItemCard55Reactor;
import shedar.mods.ic2.nuclearcontrol.items.ItemCardReactorSensorLocation;
import shedar.mods.ic2.nuclearcontrol.items.ItemUpgrade;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityThermo;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearHelper;

public class TileEntityRemoteThermo
extends TileEntityThermo
implements IEnergySink,
ISlotItemFilter,
IRotation,
IInventory {
    public static final int SLOT_CHARGER = 0;
    public static final int SLOT_CARD = 1;
    private static final double BASE_PACKET_SIZE = 32.0;
    private static final int BASE_STORAGE = 600;
    private static final int STORAGE_PER_UPGRADE = 10000;
    private static final int ENERGY_SU_BATTERY = 1000;
    private static final int LOCATION_RANGE = 8;
    private int deltaX = 0;
    private int deltaY = 0;
    private int deltaZ = 0;
    private double prevMaxStorage;
    public double maxStorage = 600.0;
    public double prevMaxPacketSize;
    public double maxPacketSize = 32.0;
    private int prevTier;
    public int tier = 1;
    public int rotation = 0;
    public int prevRotation = 0;
    public double energy = 0.0;
    private boolean addedToEnergyNet = false;
    private ItemStack[] inventory = new ItemStack[5];

    @Override
    public List<String> getNetworkedFields() {
        List<String> list = super.getNetworkedFields();
        list.add("maxStorage");
        list.add("tier");
        list.add("maxPacketSize");
        list.add("rotation");
        return list;
    }

    @Override
    protected void checkStatus() {
        int fire;
        if (!this.addedToEnergyNet) {
            EnergyTileLoadEvent event = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.addedToEnergyNet = true;
        }
        this.func_70296_d();
        if (this.energy >= (double)IC2NuclearControl.instance.remoteThermalMonitorEnergyConsumption) {
            ChunkCoordinates target;
            IReactor reactor = NuclearHelper.getReactorAt(this.field_145850_b, this.field_145851_c + this.deltaX, this.field_145848_d + this.deltaY, this.field_145849_e + this.deltaZ);
            Object NR = null;
            if (reactor == null && this.inventory[1] != null && (target = new CardWrapperImpl(this.inventory[1], 1).getTarget()) != null) {
                int x = target.field_71574_a;
                int y = target.field_71572_b;
                int z = target.field_71573_c;
                reactor = ((TileEntityReactorChamberElectric)ItemCard55Reactor.getReactor(this.field_145850_b, x, y, z)).getReactor();
            }
            if (reactor != null || NR != null) {
                int reactorHeat;
                if (NR != null) {
                    reactor = NR.getReactor();
                }
                if (this.tickRate == -1) {
                    this.tickRate = reactor.getTickRate() / 2;
                    if (this.tickRate == 0) {
                        this.tickRate = 1;
                    }
                    this.updateTicker = this.tickRate;
                }
                fire = reactorHeat = reactor.getHeat();
            } else {
                fire = -1;
            }
        } else {
            fire = -2;
        }
        if (fire != this.getOnFire()) {
            this.setOnFire(fire);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double value) {
        this.energy = value;
    }

    public void setTier(int value) {
        this.tier = value;
        if (this.tier != this.prevTier) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "tier");
        }
        this.prevTier = this.tier;
    }

    @Override
    public void setRotation(int value) {
        this.rotation = value;
        if (this.rotation != this.prevRotation) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "rotation");
        }
        this.prevRotation = this.rotation;
    }

    public void setMaxPacketSize(double value) {
        this.maxPacketSize = value;
        if (this.maxPacketSize != this.prevMaxPacketSize) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "maxPacketSize");
        }
        this.prevMaxPacketSize = this.maxPacketSize;
    }

    public void setMaxStorage(double value) {
        this.maxStorage = value;
        if (this.maxStorage != this.prevMaxStorage) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "maxStorage");
        }
        this.prevMaxStorage = this.maxStorage;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            int consumption = IC2NuclearControl.instance.remoteThermalMonitorEnergyConsumption;
            if (this.inventory[0] != null && this.energy < this.maxStorage) {
                if (this.inventory[0].func_77973_b() instanceof IElectricItem) {
                    IElectricItem ielectricitem = (IElectricItem)this.inventory[0].func_77973_b();
                    if (ielectricitem.canProvideEnergy(this.inventory[0])) {
                        double k = ElectricItem.manager.discharge(this.inventory[0], this.maxStorage - this.energy, this.tier, false, false, false);
                        this.energy += k;
                    }
                } else if (Item.func_150891_b((Item)this.inventory[0].func_77973_b()) == Item.func_150891_b((Item)IC2Items.getItem((String)"suBattery").func_77973_b()) && (1000.0 <= this.maxStorage - this.energy || this.energy == 0.0)) {
                    --this.inventory[0].field_77994_a;
                    if (this.inventory[0].field_77994_a <= 0) {
                        this.inventory[0] = null;
                    }
                    this.energy += 1000.0;
                    if (this.energy > this.maxStorage) {
                        this.energy = this.maxStorage;
                    }
                }
            }
            this.energy = this.energy >= (double)consumption ? (this.energy -= (double)consumption) : 0.0;
            this.setEnergy(this.energy);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74769_h("energy");
        if (nbttagcompound.func_74764_b("rotation")) {
            this.prevRotation = this.rotation = nbttagcompound.func_74762_e("rotation");
        }
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound compound = nbttaglist.func_150305_b(i);
            byte slotNum = compound.func_74771_c("Slot");
            if (slotNum < 0 || slotNum >= this.inventory.length) continue;
            this.inventory[slotNum] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.func_70296_d();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74768_a("rotation", this.rotation);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(compound);
            nbttaglist.func_74742_a((NBTBase)compound);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("rotation") && this.prevRotation != this.rotation) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.prevRotation = this.rotation;
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            EnergyTileUnloadEvent event = new EnergyTileUnloadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.addedToEnergyNet = false;
        }
        super.func_145843_s();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotNum) {
        return this.inventory[slotNum];
    }

    public ItemStack func_70298_a(int slotNum, int amount) {
        if (this.inventory[slotNum] != null) {
            if (this.inventory[slotNum].field_77994_a <= amount) {
                ItemStack itemStack = this.inventory[slotNum];
                this.inventory[slotNum] = null;
                return itemStack;
            }
            ItemStack taken = this.inventory[slotNum].func_77979_a(amount);
            if (this.inventory[slotNum].field_77994_a == 0) {
                this.inventory[slotNum] = null;
            }
            return taken;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int slotNum, ItemStack itemStack) {
        this.inventory[slotNum] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "block.RemoteThermo";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70296_d() {
        super.func_70296_d();
        int upgradeCountTransormer = 0;
        int upgradeCountStorage = 0;
        int upgradeCountRange = 0;
        for (int i = 2; i < 5; ++i) {
            ItemStack itemStack = this.inventory[i];
            if (itemStack == null) continue;
            if (itemStack.func_77969_a(IC2Items.getItem((String)"transformerUpgrade"))) {
                upgradeCountTransormer += itemStack.field_77994_a;
                continue;
            }
            if (itemStack.func_77969_a(IC2Items.getItem((String)"energyStorageUpgrade"))) {
                upgradeCountStorage += itemStack.field_77994_a;
                continue;
            }
            if (!(itemStack.func_77973_b() instanceof ItemUpgrade) || itemStack.func_77960_j() != 0) continue;
            upgradeCountRange += itemStack.field_77994_a;
        }
        if (this.inventory[1] != null) {
            ChunkCoordinates target = new CardWrapperImpl(this.inventory[1], 1).getTarget();
            if (target != null) {
                this.deltaX = target.field_71574_a - this.field_145851_c;
                this.deltaY = target.field_71572_b - this.field_145848_d;
                this.deltaZ = target.field_71573_c - this.field_145849_e;
                if (upgradeCountRange > 7) {
                    upgradeCountRange = 7;
                }
                int range = 8 * (int)Math.pow(2.0, upgradeCountRange);
                if (Math.abs(this.deltaX) > range || Math.abs(this.deltaY) > range || Math.abs(this.deltaZ) > range) {
                    this.deltaZ = 0;
                    this.deltaY = 0;
                    this.deltaX = 0;
                }
            } else {
                this.deltaX = 0;
                this.deltaY = 0;
                this.deltaZ = 0;
            }
        } else {
            this.deltaX = 0;
            this.deltaY = 0;
            this.deltaZ = 0;
        }
        upgradeCountTransormer = Math.min(upgradeCountTransormer, 4);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.tier = upgradeCountTransormer + 1;
            this.setTier(this.tier);
            this.maxPacketSize = 32.0 * Math.pow(4.0, upgradeCountTransormer);
            this.setMaxPacketSize(this.maxPacketSize);
            this.maxStorage = 600 + 10000 * upgradeCountStorage;
            this.setMaxStorage(this.maxStorage);
            if (this.energy > this.maxStorage) {
                this.energy = this.maxStorage;
            }
            this.setEnergy(this.energy);
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double getDemandedEnergy() {
        return this.maxStorage - this.energy;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.energy += amount;
        double left = 0.0;
        if (this.energy > this.maxStorage) {
            left = this.energy - this.maxStorage;
            this.energy = this.maxStorage;
        }
        this.setEnergy(this.energy);
        return left;
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack itemstack) {
        switch (slotIndex) {
            case 0: {
                IElectricItem item;
                if (Item.func_150891_b((Item)itemstack.func_77973_b()) == Item.func_150891_b((Item)IC2Items.getItem((String)"suBattery").func_77973_b())) {
                    return true;
                }
                return itemstack.func_77973_b() instanceof IElectricItem && (item = (IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) && item.getTier(itemstack) <= this.tier;
            }
            case 1: {
                return itemstack.func_77973_b() instanceof ItemCardReactorSensorLocation || itemstack.func_77973_b() instanceof ItemCard55Reactor;
            }
        }
        return itemstack.func_77969_a(IC2Items.getItem((String)"transformerUpgrade")) || itemstack.func_77969_a(IC2Items.getItem((String)"energyStorageUpgrade")) || itemstack.func_77973_b() instanceof ItemUpgrade && itemstack.func_77960_j() == 0;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int face) {
        return !entityPlayer.func_70093_af() && this.getFacing() != face;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return !entityPlayer.func_70093_af();
    }

    @Override
    public int modifyTextureIndex(int texture) {
        return texture;
    }

    @Override
    public void rotate() {
        int r;
        switch (this.rotation) {
            case 0: {
                r = 1;
                break;
            }
            case 1: {
                r = 3;
                break;
            }
            case 3: {
                r = 2;
                break;
            }
            case 2: {
                r = 0;
                break;
            }
            default: {
                r = 0;
            }
        }
        this.setRotation(r);
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)IC2NuclearControl.blockNuclearControlMain, 1, 3);
    }

    public int getSinkTier() {
        return this.tier;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.isItemValid(slot, itemstack);
    }
}

