/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;

public class ConfigurationHandler {
    public Configuration configuration;

    public void init(File configFile) {
        if (this.configuration == null) {
            this.configuration = new Configuration(configFile);
        }
        this.loadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        try {
            IC2NuclearControl.instance.alarmRange = this.configuration.get("general", "alarmRange", 64).getInt();
            IC2NuclearControl.instance.maxAlarmRange = this.configuration.get("general", "maxAlarmRange", 128).getInt();
            IC2NuclearControl.instance.allowedAlarms = this.configuration.get("general", "allowedAlarms", "default,sci-fi").getString().replaceAll(" ", "");
            IC2NuclearControl.instance.remoteThermalMonitorEnergyConsumption = this.configuration.get("general", "remoteThermalMonitorEnergyConsumption", 1).getInt();
            IC2NuclearControl.instance.screenRefreshPeriod = this.configuration.get("general", "infoPanelRefreshPeriod", 20).getInt();
            IC2NuclearControl.instance.rangeTriggerRefreshPeriod = this.configuration.get("general", "rangeTriggerRefreshPeriod", 20).getInt();
            IC2NuclearControl.instance.SMPMaxAlarmRange = this.configuration.get("general", "SMPMaxAlarmRange", 256).getInt();
            IC2NuclearControl.instance.recipes = this.configuration.getString("recipes", "general", "normal", "Valid inputs: normal, old or gregtech");
        }
        catch (Exception e) {
            IC2NuclearControl.logger.error("Mod has a problem loading it's configuration", (Throwable)e);
        }
        finally {
            if (this.configuration.hasChanged()) {
                this.configuration.save();
            }
        }
    }

    public void save() {
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        this.loadConfiguration();
    }
}

