/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item;

import cofh.core.item.ItemArmorAdv;
import cofh.core.item.tool.ItemAxeAdv;
import cofh.core.item.tool.ItemBowAdv;
import cofh.core.item.tool.ItemFishingRodAdv;
import cofh.core.item.tool.ItemHoeAdv;
import cofh.core.item.tool.ItemPickaxeAdv;
import cofh.core.item.tool.ItemShearsAdv;
import cofh.core.item.tool.ItemShovelAdv;
import cofh.core.item.tool.ItemSickleAdv;
import cofh.core.item.tool.ItemSwordAdv;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.core.TFProps;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.util.EnumHelper;

public enum Equipment {
    Copper(1, 175, 4.0f, 0.5f, 6, 6, new int[]{1, 3, 3, 1}),
    Tin(1, 200, 4.5f, 1.0f, 7, 8, new int[]{1, 4, 3, 1}),
    Silver(2, 200, 6.0f, 1.5f, 20, 11, new int[]{2, 4, 4, 1}),
    Lead(1, 150, 5.0f, 1.0f, 9, 15, new int[]{3, 5, 4, 2}){

        @Override
        protected final void createArmor() {
            AttributeModifier attributeModifier = new AttributeModifier("lead weight bonus", 0.25, 0);
            AttributeModifier attributeModifier2 = new AttributeModifier("lead weight bonus", -0.15, 2);
            this.itemHelmet = new ItemArmorAdv(this.ARMOR_MATERIAL, 0);
            this.itemHelmet.putAttribute("generic.knockbackResistance", attributeModifier);
            this.itemHelmet.putAttribute("generic.movementSpeed", attributeModifier2);
            attributeModifier = new AttributeModifier("lead weight bonus", 0.25, 0);
            attributeModifier2 = new AttributeModifier("lead weight bonus", -0.15, 2);
            this.itemPlate = new ItemArmorAdv(this.ARMOR_MATERIAL, 1);
            this.itemPlate.putAttribute("generic.knockbackResistance", attributeModifier);
            this.itemPlate.putAttribute("generic.movementSpeed", attributeModifier2);
            attributeModifier = new AttributeModifier("lead weight bonus", 0.25, 0);
            attributeModifier2 = new AttributeModifier("lead weight bonus", -0.15, 2);
            this.itemLegs = new ItemArmorAdv(this.ARMOR_MATERIAL, 2);
            this.itemLegs.putAttribute("generic.knockbackResistance", attributeModifier);
            this.itemLegs.putAttribute("generic.movementSpeed", attributeModifier2);
            attributeModifier = new AttributeModifier("lead weight bonus", 0.25, 0);
            attributeModifier2 = new AttributeModifier("lead weight bonus", -0.15, 2);
            this.itemBoots = new ItemArmorAdv(this.ARMOR_MATERIAL, 3);
            this.itemBoots.putAttribute("generic.knockbackResistance", attributeModifier);
            this.itemBoots.putAttribute("generic.movementSpeed", attributeModifier2);
        }
    }
    ,
    Nickel(2, 300, 6.5f, 2.5f, 18, 15, new int[]{2, 5, 5, 2}),
    Electrum(0, 100, 14.0f, 0.5f, 30, 8, new int[]{2, 4, 4, 2}),
    Invar(2, 450, 7.0f, 3.0f, 16, 25, new int[]{2, 7, 5, 2}),
    Bronze(2, 500, 6.0f, 2.0f, 15, 17, new int[]{3, 6, 6, 2}),
    Platinum(4, 1700, 9.0f, 4.0f, 9, 40, new int[]{3, 8, 6, 3}){

        @Override
        protected final void createArmor() {
            AttributeModifier attributeModifier = new AttributeModifier("platinum weight bonus", 0.2, 0);
            AttributeModifier attributeModifier2 = new AttributeModifier("platinum weight bonus", -0.08, 2);
            this.itemHelmet = new ItemArmorAdv(this.ARMOR_MATERIAL, 0);
            this.itemHelmet.putAttribute("generic.knockbackResistance", attributeModifier);
            this.itemHelmet.putAttribute("generic.movementSpeed", attributeModifier2);
            attributeModifier = new AttributeModifier("platinum weight bonus", 0.2, 0);
            attributeModifier2 = new AttributeModifier("platinum weight bonus", -0.08, 2);
            this.itemPlate = new ItemArmorAdv(this.ARMOR_MATERIAL, 1);
            this.itemPlate.putAttribute("generic.knockbackResistance", attributeModifier);
            this.itemPlate.putAttribute("generic.movementSpeed", attributeModifier2);
            attributeModifier = new AttributeModifier("platinum weight bonus", 0.2, 0);
            attributeModifier2 = new AttributeModifier("platinum weight bonus", -0.08, 2);
            this.itemLegs = new ItemArmorAdv(this.ARMOR_MATERIAL, 2);
            this.itemLegs.putAttribute("generic.knockbackResistance", attributeModifier);
            this.itemLegs.putAttribute("generic.movementSpeed", attributeModifier2);
            attributeModifier = new AttributeModifier("platinum weight bonus", 0.2, 0);
            attributeModifier2 = new AttributeModifier("platinum weight bonus", -0.08, 2);
            this.itemBoots = new ItemArmorAdv(this.ARMOR_MATERIAL, 3);
            this.itemBoots.putAttribute("generic.knockbackResistance", attributeModifier);
            this.itemBoots.putAttribute("generic.movementSpeed", attributeModifier2);
        }
    };

    public final Item.ToolMaterial TOOL_MATERIAL;
    public final ItemArmor.ArmorMaterial ARMOR_MATERIAL;
    private final String ingot;
    private final float arrowSpeed = 2.0f;
    private float arrowDamage = 1.0f;
    private int luckModifier = 0;
    private int speedModifier = 0;
    public boolean enableArmor = true;
    public boolean[] enableTools = new boolean[9];
    public ItemArmorAdv itemHelmet;
    public ItemArmorAdv itemPlate;
    public ItemArmorAdv itemLegs;
    public ItemArmorAdv itemBoots;
    public ItemSwordAdv itemSword;
    public ItemShovelAdv itemShovel;
    public ItemPickaxeAdv itemPickaxe;
    public ItemAxeAdv itemAxe;
    public ItemHoeAdv itemHoe;
    public ItemShearsAdv itemShears;
    public ItemFishingRodAdv itemFishingRod;
    public ItemSickleAdv itemSickle;
    public ItemBowAdv itemBow;
    public ItemStack armorHelmet;
    public ItemStack armorPlate;
    public ItemStack armorLegs;
    public ItemStack armorBoots;
    public ItemStack toolSword;
    public ItemStack toolShovel;
    public ItemStack toolPickaxe;
    public ItemStack toolAxe;
    public ItemStack toolHoe;
    public ItemStack toolShears;
    public ItemStack toolFishingRod;
    public ItemStack toolSickle;
    public ItemStack toolBow;

    private Equipment(int n2, int n3, float f, float f2, int n4, int n5, int[] nArray) {
        this.TOOL_MATERIAL = EnumHelper.addToolMaterial((String)("TF:" + this.name().toUpperCase()), (int)n2, (int)n3, (float)f, (float)f2, (int)n4);
        this.ARMOR_MATERIAL = EnumHelper.addArmorMaterial((String)("TF:" + this.name().toUpperCase()), (int)n5, (int[])nArray, (int)n4);
        this.ingot = "ingot" + this.name();
        this.luckModifier = n2 / 2;
        this.speedModifier = (int)(f / 5.0f);
        this.arrowDamage = 1.0f + f2 / 8.0f;
    }

    protected void createArmor() {
        this.itemHelmet = new ItemArmorAdv(this.ARMOR_MATERIAL, 0);
        this.itemPlate = new ItemArmorAdv(this.ARMOR_MATERIAL, 1);
        this.itemLegs = new ItemArmorAdv(this.ARMOR_MATERIAL, 2);
        this.itemBoots = new ItemArmorAdv(this.ARMOR_MATERIAL, 3);
    }

    protected void createTools() {
        this.itemSword = new ItemSwordAdv(this.TOOL_MATERIAL);
        this.itemShovel = new ItemShovelAdv(this.TOOL_MATERIAL);
        this.itemPickaxe = new ItemPickaxeAdv(this.TOOL_MATERIAL);
        this.itemAxe = new ItemAxeAdv(this.TOOL_MATERIAL);
        this.itemHoe = new ItemHoeAdv(this.TOOL_MATERIAL);
        this.itemShears = new ItemShearsAdv(this.TOOL_MATERIAL);
        this.itemFishingRod = new ItemFishingRodAdv(this.TOOL_MATERIAL);
        this.itemSickle = new ItemSickleAdv(this.TOOL_MATERIAL);
        this.itemBow = new ItemBowAdv(this.TOOL_MATERIAL);
    }

    protected void preInitv() {
        String string = this.name();
        String string2 = string.toLowerCase();
        String string3 = "thermalfoundation.armor." + string2;
        String string4 = "thermalfoundation.tool." + string2;
        String string5 = "Equipment." + string;
        this.enableArmor = ThermalFoundation.config.get(string5, "Armor", true);
        this.enableArmor &= !TFProps.disableAllArmor;
        string5 = string5 + ".Tools";
        this.enableTools[0] = ThermalFoundation.config.get(string5, "Sword", true);
        this.enableTools[1] = ThermalFoundation.config.get(string5, "Shovel", true);
        this.enableTools[2] = ThermalFoundation.config.get(string5, "Pickaxe", true);
        this.enableTools[3] = ThermalFoundation.config.get(string5, "Axe", true);
        this.enableTools[4] = ThermalFoundation.config.get(string5, "Hoe", true);
        this.enableTools[5] = ThermalFoundation.config.get(string5, "Shears", true);
        this.enableTools[6] = ThermalFoundation.config.get(string5, "FishingRod", true);
        this.enableTools[7] = ThermalFoundation.config.get(string5, "Sickle", true);
        this.enableTools[8] = ThermalFoundation.config.get(string5, "Bow", true);
        for (int i = 0; i < this.enableTools.length; ++i) {
            int n = i;
            this.enableTools[n] = this.enableTools[n] & !TFProps.disableAllTools;
        }
        String[] stringArray = new String[]{"thermalfoundation:textures/armor/" + string + "_1.png", "thermalfoundation:textures/armor/" + string + "_2.png"};
        String string6 = "thermalfoundation:armor/" + string2 + "/" + string;
        String string7 = "thermalfoundation:tool/" + string2 + "/" + string;
        this.createArmor();
        this.itemHelmet.setRepairIngot(this.ingot).setArmorTextures(stringArray).func_77655_b(string3 + "Helmet");
        this.itemHelmet.func_111206_d(string6 + "Helmet").func_77637_a(ThermalFoundation.tabArmor);
        this.itemHelmet.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.itemPlate.setRepairIngot(this.ingot).setArmorTextures(stringArray).func_77655_b(string3 + "Plate");
        this.itemPlate.func_111206_d(string6 + "Chestplate").func_77637_a(ThermalFoundation.tabArmor);
        this.itemPlate.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.itemLegs.setRepairIngot(this.ingot).setArmorTextures(stringArray).func_77655_b(string3 + "Legs");
        this.itemLegs.func_111206_d(string6 + "Legs").func_77637_a(ThermalFoundation.tabArmor);
        this.itemLegs.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.itemBoots.setRepairIngot(this.ingot).setArmorTextures(stringArray).func_77655_b(string3 + "Boots");
        this.itemBoots.func_111206_d(string6 + "Boots").func_77637_a(ThermalFoundation.tabArmor);
        this.itemBoots.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.createTools();
        this.itemSword.setRepairIngot(this.ingot).func_77655_b(string4 + "Sword");
        this.itemSword.func_111206_d(string7 + "Sword").func_77637_a(ThermalFoundation.tabTools);
        this.itemSword.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.itemShovel.setRepairIngot(this.ingot).func_77655_b(string4 + "Shovel");
        this.itemShovel.func_111206_d(string7 + "Shovel").func_77637_a(ThermalFoundation.tabTools);
        this.itemShovel.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.itemPickaxe.setRepairIngot(this.ingot).func_77655_b(string4 + "Pickaxe");
        this.itemPickaxe.func_111206_d(string7 + "Pickaxe").func_77637_a(ThermalFoundation.tabTools);
        this.itemPickaxe.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.itemAxe.setRepairIngot(this.ingot).func_77655_b(string4 + "Axe");
        this.itemAxe.func_111206_d(string7 + "Axe").func_77637_a(ThermalFoundation.tabTools);
        this.itemAxe.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.itemHoe.setRepairIngot(this.ingot).func_77655_b(string4 + "Hoe");
        this.itemHoe.func_111206_d(string7 + "Hoe").func_77637_a(ThermalFoundation.tabTools);
        this.itemHoe.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.itemShears.setRepairIngot(this.ingot).func_77655_b(string4 + "Shears");
        this.itemShears.func_111206_d(string7 + "Shears").func_77637_a(ThermalFoundation.tabTools);
        this.itemShears.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.itemFishingRod.setRepairIngot(this.ingot).func_77655_b(string4 + "FishingRod");
        this.itemFishingRod.func_111206_d(string7 + "FishingRod").func_77637_a(ThermalFoundation.tabTools);
        this.itemFishingRod.setLuckModifier(this.luckModifier).setSpeedModifier(this.speedModifier);
        this.itemFishingRod.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.itemSickle.setRepairIngot(this.ingot).func_77655_b(string4 + "Sickle");
        this.itemSickle.func_111206_d(string7 + "Sickle").func_77637_a(ThermalFoundation.tabTools);
        this.itemSickle.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        this.itemBow.setRepairIngot(this.ingot).setArrowSpeed(2.0f).setArrowDamage(this.arrowDamage).func_77655_b(string4 + "Bow");
        this.itemBow.func_111206_d(string7 + "Bow").func_77637_a(ThermalFoundation.tabTools);
        this.itemBow.setShowInCreative(this.enableArmor | TFProps.showDisabledEquipment);
        GameRegistry.registerItem((Item)this.itemHelmet, (String)("armor.helmet" + string));
        GameRegistry.registerItem((Item)this.itemPlate, (String)("armor.plate" + string));
        GameRegistry.registerItem((Item)this.itemLegs, (String)("armor.legs" + string));
        GameRegistry.registerItem((Item)this.itemBoots, (String)("armor.boots" + string));
        GameRegistry.registerItem((Item)this.itemSword, (String)("tool.sword" + string));
        GameRegistry.registerItem((Item)this.itemShovel, (String)("tool.shovel" + string));
        GameRegistry.registerItem((Item)this.itemPickaxe, (String)("tool.pickaxe" + string));
        GameRegistry.registerItem((Item)this.itemAxe, (String)("tool.axe" + string));
        GameRegistry.registerItem((Item)this.itemHoe, (String)("tool.hoe" + string));
        GameRegistry.registerItem((Item)this.itemShears, (String)("tool.shears" + string));
        GameRegistry.registerItem((Item)this.itemFishingRod, (String)("tool.fishingRod" + string));
        GameRegistry.registerItem((Item)this.itemSickle, (String)("tool.sickle" + string));
        GameRegistry.registerItem((Item)this.itemBow, (String)("tool.bow" + string));
    }

    protected void initializev() {
        String string = this.name();
        this.armorHelmet = new ItemStack((Item)this.itemHelmet);
        this.armorPlate = new ItemStack((Item)this.itemPlate);
        this.armorLegs = new ItemStack((Item)this.itemLegs);
        this.armorBoots = new ItemStack((Item)this.itemBoots);
        GameRegistry.registerCustomItemStack((String)("armor" + string + "Helmet"), (ItemStack)this.armorHelmet);
        GameRegistry.registerCustomItemStack((String)("armor" + string + "Plate"), (ItemStack)this.armorPlate);
        GameRegistry.registerCustomItemStack((String)("armor" + string + "Legs"), (ItemStack)this.armorLegs);
        GameRegistry.registerCustomItemStack((String)("armor" + string + "Boots"), (ItemStack)this.armorBoots);
        this.toolSword = new ItemStack((Item)this.itemSword);
        this.toolShovel = new ItemStack((Item)this.itemShovel);
        this.toolPickaxe = new ItemStack((Item)this.itemPickaxe);
        this.toolAxe = new ItemStack((Item)this.itemAxe);
        this.toolHoe = new ItemStack((Item)this.itemHoe);
        this.toolShears = new ItemStack((Item)this.itemShears);
        this.toolFishingRod = new ItemStack((Item)this.itemFishingRod);
        this.toolSickle = new ItemStack((Item)this.itemSickle);
        this.toolBow = new ItemStack((Item)this.itemBow);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "Sword"), (ItemStack)this.toolSword);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "Shovel"), (ItemStack)this.toolShovel);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "Pickaxe"), (ItemStack)this.toolPickaxe);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "Axe"), (ItemStack)this.toolAxe);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "Hoe"), (ItemStack)this.toolHoe);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "Shears"), (ItemStack)this.toolShears);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "FishingRod"), (ItemStack)this.toolFishingRod);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "Sickle"), (ItemStack)this.toolSickle);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "Bow"), (ItemStack)this.toolBow);
    }

    protected void postInitv() {
        if (this.enableArmor) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.armorHelmet, (Object[])new Object[]{"III", "I I", Character.valueOf('I'), this.ingot}));
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.armorPlate, (Object[])new Object[]{"I I", "III", "III", Character.valueOf('I'), this.ingot}));
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.armorLegs, (Object[])new Object[]{"III", "I I", "I I", Character.valueOf('I'), this.ingot}));
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.armorBoots, (Object[])new Object[]{"I I", "I I", Character.valueOf('I'), this.ingot}));
        }
        if (this.enableTools[0]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolSword, (Object[])new Object[]{"I", "I", "S", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"}));
        }
        if (this.enableTools[1]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolShovel, (Object[])new Object[]{"I", "S", "S", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"}));
        }
        if (this.enableTools[2]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolPickaxe, (Object[])new Object[]{"III", " S ", " S ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"}));
        }
        if (this.enableTools[3]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolAxe, (Object[])new Object[]{"II", "IS", " S", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"}));
        }
        if (this.enableTools[4]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolHoe, (Object[])new Object[]{"II", " S", " S", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"}));
        }
        if (this.enableTools[5]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolShears, (Object[])new Object[]{" I", "I ", Character.valueOf('I'), this.ingot}));
        }
        if (this.enableTools[6]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolFishingRod, (Object[])new Object[]{"  I", " I#", "S #", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood", Character.valueOf('#'), Items.field_151007_F}));
        }
        if (this.enableTools[7]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolSickle, (Object[])new Object[]{" I ", "  I", "SI ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"}));
        }
        if (this.enableTools[8]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolBow, (Object[])new Object[]{" I#", "S #", " I#", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood", Character.valueOf('#'), Items.field_151007_F}));
        }
    }

    public static void preInit() {
        for (Equipment equipment : Equipment.values()) {
            equipment.preInitv();
        }
    }

    public static void initialize() {
        for (Equipment equipment : Equipment.values()) {
            equipment.initializev();
        }
    }

    public static void postInit() {
        for (Equipment equipment : Equipment.values()) {
            equipment.postInitv();
        }
    }
}

