/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus;

import java.util.Calendar;
import net.minecraft.util.EnumChatFormatting;
import net.quetzi.morpheus.Morpheus;

public class DateHandler {
    private static Event getEvent(Calendar calendar) {
        for (Event event : Event.values()) {
            if (!event.isEvent(calendar)) continue;
            return event;
        }
        return Event.NONE;
    }

    public static String getMorningText() {
        return DateHandler.getEvent(Calendar.getInstance()).text;
    }

    public static enum Event {
        XMAS(25, 12, EnumChatFormatting.RED + "Good morning everyone! HAPPY CHRISTMAS!"),
        NEW_YEAR(1, 1, EnumChatFormatting.GOLD + "Good morning everyone! HAPPY NEW YEAR!"),
        STPATRICKS(17, 3, EnumChatFormatting.DARK_GREEN + "Good morning everyone! HAPPY ST PATRICKS DAY!"),
        HALLOWEEN(31, 10, EnumChatFormatting.DARK_PURPLE + "Good morning everyone! HAPPY SAMHAIN!"),
        NONE(0, 0, EnumChatFormatting.GOLD + Morpheus.onMorningText);

        private final int month;
        private final int day;
        private final String text;

        private Event(int day, int month, String text) {
            this.month = month;
            this.day = day;
            this.text = text;
        }

        public boolean isEvent(Calendar calendar) {
            return calendar.get(2) + 1 == this.month && calendar.get(5) == this.day;
        }
    }
}

