/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.utility;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class DimensionCoordinates
extends ChunkCoordinates {
    public int dimension;

    public DimensionCoordinates() {
    }

    public DimensionCoordinates(ChunkCoordinates chunkCoordinates, int dim) {
        super(chunkCoordinates);
        this.dimension = dim;
    }

    public DimensionCoordinates(int x, int y, int z, int dim) {
        super(x, y, z);
        this.dimension = dim;
    }

    public DimensionCoordinates(NBTTagCompound tag) {
        this(tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"), tag.func_74762_e("D"));
    }

    public DimensionCoordinates(DimensionCoordinates coord) {
        super(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
        this.dimension = coord.dimension;
    }

    public Block getBlock() {
        WorldServer world = this.getWorld();
        if (!world.func_72863_F().func_73149_a(this.field_71574_a >> 4, this.field_71572_b >> 4)) {
            world.func_72863_F().func_73158_c(this.field_71574_a >> 4, this.field_71572_b >> 4);
        }
        return world.func_147439_a(this.field_71574_a, this.field_71572_b, this.field_71573_c);
    }

    public int getMetadata() {
        WorldServer world = this.getWorld();
        if (!world.func_72863_F().func_73149_a(this.field_71574_a >> 4, this.field_71572_b >> 4)) {
            world.func_72863_F().func_73158_c(this.field_71574_a >> 4, this.field_71572_b >> 4);
        }
        return world.func_72805_g(this.field_71574_a, this.field_71572_b, this.field_71573_c);
    }

    public TileEntity getTileEntity() {
        WorldServer world = this.getWorld();
        if (world == null) {
            DimensionManager.initDimension((int)this.dimension);
            world = DimensionManager.getWorld((int)this.dimension);
            if (world == null) {
                return null;
            }
        }
        if (!world.func_72863_F().func_73149_a(this.field_71574_a >> 4, this.field_71572_b >> 4)) {
            world.func_72863_F().func_73158_c(this.field_71574_a >> 4, this.field_71572_b >> 4);
        }
        return world.func_147438_o(this.field_71574_a, this.field_71572_b, this.field_71573_c);
    }

    public WorldServer getWorld() {
        WorldServer world = DimensionManager.getWorld((int)this.dimension);
        if (world == null) {
            DimensionManager.initDimension((int)this.dimension);
            world = DimensionManager.getWorld((int)this.dimension);
            if (world == null) {
                return null;
            }
        }
        return world;
    }

    public DimensionCoordinates offset(ForgeDirection orientation) {
        return new DimensionCoordinates(this.field_71574_a + orientation.offsetX, this.field_71572_b + orientation.offsetY, this.field_71573_c + orientation.offsetZ, this.dimension);
    }

    public String toString() {
        return String.format("WorldCoordinates (X %s, Y %s, Z %s, D %s)", this.field_71574_a, this.field_71572_b, this.field_71573_c, this.dimension);
    }

    public void writeToNBT(NBTTagCompound t) {
        t.func_74768_a("X", this.field_71574_a);
        t.func_74768_a("Y", this.field_71572_b);
        t.func_74768_a("Z", this.field_71573_c);
        t.func_74768_a("D", this.dimension);
    }
}

