/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.ByteBufUtils;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import enhancedportals.network.GuiHandler;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileFrameTransfer;
import enhancedportals.utility.GeneralUtils;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileTransferItem
extends TileFrameTransfer
implements IInventory,
IPeripheral,
SimpleComponent {
    ItemStack stack;
    int tickTimer = 20;
    int time = 0;

    @Override
    public boolean activate(EntityPlayer player, ItemStack stack) {
        if (player.func_70093_af()) {
            return false;
        }
        TileController controller = this.getPortalController();
        if (GeneralUtils.isWrench(stack) && controller != null && controller.isFinalized()) {
            GuiHandler.openGui(player, this, 23);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        if (method == 0) {
            return new Object[]{this.stack != null ? Item.func_150891_b((Item)this.stack.func_77973_b()) : 0};
        }
        if (method == 1) {
            return new Object[]{this.stack != null ? this.stack.field_77994_a : 0};
        }
        if (method == 2) {
            return new Object[]{this.stack != null};
        }
        if (method == 3) {
            return new Object[]{this.isSending};
        }
        return null;
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack stack = this.func_70301_a(i);
        if (stack != null) {
            if (stack.field_77994_a <= j) {
                this.func_70299_a(i, null);
            } else {
                stack = stack.func_77979_a(j);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return stack;
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other == this;
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ep_transfer_item";
    }

    public String func_145825_b() {
        return "tile.frame.item.name";
    }

    public int func_70297_j_() {
        return 64;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getItemStored", "getAmountStored", "hasStack", "isSending"};
    }

    public int func_70302_i_() {
        return 1;
    }

    @Callback(direct=true, doc="function():table -- Returns a description of the item stored in this module.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getStack(Context context, Arguments args) {
        return new Object[]{this.stack.func_77946_l()};
    }

    public ItemStack func_70301_a(int i) {
        return this.stack;
    }

    public ItemStack func_70304_b(int i) {
        return this.stack;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "ep_transfer_item";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Callback(direct=true, doc="function():boolean -- Return whether there is an item stored in this module.")
    @Optional.Method(modid="OpenComputers")
    public Object[] hasStack(Context context, Arguments args) {
        return new Object[]{this.stack != null};
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Callback(direct=true, doc="function():boolean -- Returns true if the module is set to send items.")
    @Optional.Method(modid="OpenComputers")
    public Object[] isSending(Context context, Arguments args) {
        return new Object[]{this.isSending};
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    @Override
    public void packetGuiFill(ByteBuf buffer) {
        if (this.stack != null) {
            buffer.writeBoolean(true);
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.stack);
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Override
    public void packetGuiUse(ByteBuf buffer) {
        this.stack = buffer.readBoolean() ? ByteBufUtils.readItemStack((ByteBuf)buffer) : null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.stack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("stack"));
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.stack = itemstack;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.isSending) {
            if (this.time >= this.tickTimer) {
                TileController exitController;
                this.time = 0;
                TileController controller = this.getPortalController();
                if (controller != null && controller.isPortalActive() && this.stack != null && (exitController = (TileController)controller.getDestinationLocation().getTileEntity()) != null) {
                    for (ChunkCoordinates c : exitController.getTransferItems()) {
                        TileEntity tile = exitController.func_145831_w().func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
                        if (tile != null && tile instanceof TileTransferItem) {
                            TileTransferItem item = (TileTransferItem)tile;
                            if (!item.isSending) {
                                if (item.func_70301_a(0) == null) {
                                    item.func_70299_a(0, this.stack);
                                    item.func_70296_d();
                                    this.stack = null;
                                    this.func_70296_d();
                                } else if (item.func_70301_a(0).func_77973_b() == this.stack.func_77973_b()) {
                                    int amount = 0;
                                    amount = item.func_70301_a((int)0).field_77994_a + this.stack.field_77994_a <= this.stack.func_77976_d() ? this.stack.field_77994_a : this.stack.field_77994_a - (item.func_70301_a((int)0).field_77994_a + this.stack.field_77994_a - 64);
                                    if (amount <= 0) continue;
                                    item.func_70301_a((int)0).field_77994_a += amount;
                                    item.func_70296_d();
                                    if (amount == this.stack.field_77994_a) {
                                        this.stack = null;
                                    } else {
                                        this.stack.field_77994_a -= amount;
                                    }
                                    this.func_70296_d();
                                }
                            }
                        }
                        if (this.stack != null) continue;
                        break;
                    }
                }
            }
            ++this.time;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound st = new NBTTagCompound();
        if (this.stack != null) {
            this.stack.func_77955_b(st);
        }
        tag.func_74782_a("stack", (NBTBase)st);
    }
}

