/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import enhancedportals.item.ItemNanobrush;
import enhancedportals.network.GuiHandler;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileFrameTransfer;
import enhancedportals.utility.GeneralUtils;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileTransferFluid
extends TileFrameTransfer
implements IFluidHandler,
IPeripheral,
SimpleComponent {
    public FluidTank tank = new FluidTank(16000);
    int tickTimer = 20;
    int time = 0;
    IFluidHandler[] handlers = new IFluidHandler[6];
    boolean cached = false;
    byte outputTracker = 0;

    @Override
    public boolean activate(EntityPlayer player, ItemStack stack) {
        if (player.func_70093_af()) {
            return false;
        }
        TileController controller = this.getPortalController();
        if (stack != null && controller != null && controller.isFinalized()) {
            if (GeneralUtils.isWrench(stack)) {
                GuiHandler.openGui(player, this, 21);
                return true;
            }
            if (stack.func_77973_b() == ItemNanobrush.instance) {
                GuiHandler.openGui(player, controller, 8);
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        if (method == 0) {
            return new Object[]{this.tank.getFluid() != null ? this.tank.getFluid().getFluid().getName() : ""};
        }
        if (method == 1) {
            return new Object[]{this.tank.getFluidAmount()};
        }
        if (method == 2) {
            return new Object[]{this.tank.getFluidAmount() == this.tank.getCapacity()};
        }
        if (method == 3) {
            return new Object[]{this.tank.getFluidAmount() == 0};
        }
        if (method == 4) {
            return new Object[]{this.isSending};
        }
        return null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other == this;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ep_transfer_fluid";
    }

    @Callback(direct=true, limit=1, doc="function():table -- Get a description of the fluid stored inside the module.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluid(Context context, Arguments args) {
        return new Object[]{this.tank.getInfo()};
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getFluidStored", "getAmountStored", "isFull", "isEmpty", "isSending"};
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "ep_transfer_fluid";
    }

    @Callback(direct=true, doc="function():boolean -- Returns true if the module is set to send fluids.")
    @Optional.Method(modid="OpenComputers")
    public Object[] isSending(Context context, Arguments args) {
        return new Object[]{this.isSending};
    }

    @Override
    public void onNeighborChanged() {
        this.updateFluidHandlers();
    }

    @Override
    public void packetGuiFill(ByteBuf buffer) {
        if (this.tank.getFluid() != null) {
            buffer.writeBoolean(false);
            buffer.writeInt(this.tank.getFluid().fluidID);
            buffer.writeInt(this.tank.getFluidAmount());
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Override
    public void packetGuiUse(ByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.tank.setFluid(new FluidStack(FluidRegistry.getFluid((int)buffer.readInt()), buffer.readInt()));
        } else {
            this.tank.setFluid(null);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.writeToNBT(tag);
    }

    void transferFluid(int side) {
        if (this.handlers[side] == null) {
            return;
        }
        this.tank.drain(this.handlers[side].fill(ForgeDirection.getOrientation((int)side).getOpposite(), this.tank.getFluid(), true), true);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isSending) {
                if (this.time >= this.tickTimer) {
                    TileController exitController;
                    this.time = 0;
                    TileController controller = this.getPortalController();
                    if (controller != null && controller.isPortalActive() && this.tank.getFluidAmount() > 0 && (exitController = (TileController)controller.getDestinationLocation().getTileEntity()) != null) {
                        for (ChunkCoordinates c : exitController.getTransferFluids()) {
                            TileEntity tile = exitController.func_145831_w().func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
                            if (tile != null && tile instanceof TileTransferFluid) {
                                TileTransferFluid fluid = (TileTransferFluid)tile;
                                if (!fluid.isSending && fluid.fill(null, this.tank.getFluid(), false) > 0) {
                                    this.tank.drain(fluid.fill(null, this.tank.getFluid(), true), true);
                                }
                            }
                            if (this.tank.getFluidAmount() != 0) continue;
                            break;
                        }
                    }
                }
                ++this.time;
            } else {
                if (!this.cached) {
                    this.updateFluidHandlers();
                }
                for (int i = this.outputTracker; i < 6 && this.tank.getFluidAmount() > 0; ++i) {
                    this.transferFluid(i);
                }
                this.outputTracker = (byte)(this.outputTracker + 1);
                this.outputTracker = (byte)(this.outputTracker % 6);
            }
        }
    }

    void updateFluidHandlers() {
        for (int i = 0; i < 6; ++i) {
            ChunkCoordinates c = GeneralUtils.offset(this.getChunkCoordinates(), ForgeDirection.getOrientation((int)i));
            TileEntity tile = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (tile != null && tile instanceof IFluidHandler) {
                IFluidHandler fluid = (IFluidHandler)tile;
                if (fluid.getTankInfo(ForgeDirection.getOrientation((int)i).getOpposite()) != null) {
                    this.handlers[i] = fluid;
                    continue;
                }
                this.handlers[i] = null;
                continue;
            }
            this.handlers[i] = null;
        }
        this.cached = true;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.tank.readFromNBT(tag);
    }
}

