/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import enhancedportals.item.ItemNanobrush;
import enhancedportals.network.GuiHandler;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileFrameTransfer;
import enhancedportals.utility.GeneralUtils;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileTransferEnergy
extends TileFrameTransfer
implements IEnergyHandler,
IPeripheral,
SimpleComponent {
    public final EnergyStorage storage = new EnergyStorage(16000);
    int tickTimer = 20;
    int time = 0;
    IEnergyHandler[] handlers = new IEnergyHandler[6];
    boolean cached = false;
    byte outputTracker = 0;

    @Override
    public boolean activate(EntityPlayer player, ItemStack stack) {
        if (player.func_70093_af()) {
            return false;
        }
        TileController controller = this.getPortalController();
        if (stack != null && controller != null && controller.isFinalized()) {
            if (GeneralUtils.isWrench(stack)) {
                GuiHandler.openGui(player, this, 22);
                return true;
            }
            if (stack.func_77973_b() == ItemNanobrush.instance) {
                GuiHandler.openGui(player, controller, 8);
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        if (method == 0) {
            return new Object[]{this.storage.getEnergyStored()};
        }
        if (method == 1) {
            return new Object[]{this.storage.getEnergyStored() == this.storage.getMaxEnergyStored()};
        }
        if (method == 2) {
            return new Object[]{this.storage.getEnergyStored() == 0};
        }
        if (method == 3) {
            return new Object[]{this.isSending};
        }
        return null;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other == this;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ep_transfer_energy";
    }

    @Callback(direct=true, doc="function():number -- Returns the amount of energy stored inside the module.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergy(Context context, Arguments args) {
        return new Object[]{this.storage.getEnergyStored()};
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Callback(direct=true, doc="function():number -- Get the maximum amount of energy stored inside the module.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getMaxEnergy(Context context, Arguments args) {
        return new Object[]{this.storage.getMaxEnergyStored()};
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getEnergyStored", "isFull", "isEmpty", "isSending"};
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "ep_transfer_energy";
    }

    @Callback(direct=true, doc="function():boolean -- Returns true if the module is set to send energy.")
    @Optional.Method(modid="OpenComputers")
    public Object[] isSending(Context context, Arguments args) {
        return new Object[]{this.isSending};
    }

    @Override
    public void onNeighborChanged() {
        this.updateEnergyHandlers();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    void transferEnergy(int side) {
        if (this.handlers[side] == null) {
            return;
        }
        this.storage.extractEnergy(this.handlers[side].receiveEnergy(ForgeDirection.getOrientation((int)side).getOpposite(), this.storage.getEnergyStored(), false), false);
    }

    void updateEnergyHandlers() {
        for (int i = 0; i < 6; ++i) {
            ChunkCoordinates c = GeneralUtils.offset(this.getChunkCoordinates(), ForgeDirection.getOrientation((int)i));
            TileEntity tile = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (tile != null && tile instanceof IEnergyHandler) {
                IEnergyHandler energy = (IEnergyHandler)tile;
                if (energy.canConnectEnergy(ForgeDirection.getOrientation((int)i).getOpposite())) {
                    this.handlers[i] = energy;
                    continue;
                }
                this.handlers[i] = null;
                continue;
            }
            this.handlers[i] = null;
        }
        this.cached = true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isSending) {
                if (this.time >= this.tickTimer) {
                    TileController exitController;
                    this.time = 0;
                    TileController controller = this.getPortalController();
                    if (controller != null && controller.isPortalActive() && this.storage.getEnergyStored() > 0 && (exitController = (TileController)controller.getDestinationLocation().getTileEntity()) != null) {
                        for (ChunkCoordinates c : exitController.getTransferEnergy()) {
                            TileEntity tile = exitController.func_145831_w().func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
                            if (tile != null && tile instanceof TileTransferEnergy) {
                                TileTransferEnergy energy = (TileTransferEnergy)tile;
                                if (!energy.isSending && energy.receiveEnergy(null, this.storage.getEnergyStored(), true) > 0) {
                                    this.storage.extractEnergy(energy.receiveEnergy(null, this.storage.getEnergyStored(), false), false);
                                }
                            }
                            if (this.storage.getEnergyStored() != 0) continue;
                            break;
                        }
                    }
                }
                ++this.time;
            } else {
                if (!this.cached) {
                    this.updateEnergyHandlers();
                }
                for (int i = this.outputTracker; i < 6 && this.storage.getEnergyStored() > 0; ++i) {
                    this.transferEnergy(i);
                }
                this.outputTracker = (byte)(this.outputTracker + 1);
                this.outputTracker = (byte)(this.outputTracker % 6);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
    }
}

