/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enhancedportals.EnhancedPortals;
import enhancedportals.block.BlockStabilizer;
import enhancedportals.item.ItemLocationCard;
import enhancedportals.network.CommonProxy;
import enhancedportals.network.GuiHandler;
import enhancedportals.portal.GlyphIdentifier;
import enhancedportals.portal.PortalException;
import enhancedportals.portal.PortalTextureManager;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileEP;
import enhancedportals.tile.TileStabilizer;
import enhancedportals.utility.GeneralUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class TileStabilizerMain
extends TileEP
implements IInventory,
IEnergyHandler {
    static final int ENERGY_STORAGE_PER_ROW = CommonProxy.CONFIG_REDSTONE_FLUX_COST + CommonProxy.CONFIG_REDSTONE_FLUX_COST / 2;
    ArrayList<ChunkCoordinates> blockList = new ArrayList();
    HashMap<String, String> activeConnections;
    HashMap<String, String> activeConnectionsReverse;
    ItemStack inventory;
    int rows;
    int tickTimer;
    EnergyStorage energyStorage;
    public int powerState;
    public int instability = 0;
    public boolean is3x3 = false;
    public ArrayList<TileController> connectedPortals = new ArrayList();
    @SideOnly(value=Side.CLIENT)
    public int intActiveConnections;

    public TileStabilizerMain() {
        this.activeConnections = new HashMap();
        this.activeConnectionsReverse = new HashMap();
        this.energyStorage = new EnergyStorage(0);
    }

    public void addPortal(TileController portal) {
        this.connectedPortals.add(portal);
    }

    public boolean activate(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)stack.func_77973_b()) == BlockStabilizer.instance) {
            return false;
        }
        GuiHandler.openGui(player, this, 24);
        return true;
    }

    public void breakBlock(Block b, int oldMetadata) {
        for (int i = this.activeConnections.size() - 1; i > -1; --i) {
            try {
                this.terminateExistingConnection(new GlyphIdentifier(this.activeConnections.values().toArray(new String[this.activeConnections.size()])[i]));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (ChunkCoordinates c : this.blockList) {
            TileEntity tile = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (!(tile instanceof TileStabilizer)) continue;
            TileStabilizer t = (TileStabilizer)tile;
            t.mainBlock = null;
            this.field_145850_b.func_147471_g(t.field_145851_c, t.field_145848_d, t.field_145849_e);
        }
    }

    public boolean canAcceptNewConnection() {
        return this.activeConnections.size() * 2 + 2 <= CommonProxy.CONFIG_PORTAL_CONNECTIONS_PER_ROW * this.rows;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_70305_f() {
    }

    public void deconstruct() {
        this.breakBlock(null, 0);
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)BlockStabilizer.instance, 0, 3);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack stack = this.func_70301_a(i);
        if (stack != null) {
            if (stack.field_77994_a <= j) {
                this.func_70299_a(i, null);
            } else {
                stack = stack.func_77979_a(j);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return stack;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    public int getActiveConnections() {
        return this.activeConnections != null ? this.activeConnections.size() : -1;
    }

    public GlyphIdentifier getConnectedPortal(GlyphIdentifier uniqueIdentifier) {
        if (this.activeConnections.containsKey(uniqueIdentifier.getGlyphString())) {
            return new GlyphIdentifier(this.activeConnections.get(uniqueIdentifier.getGlyphString()));
        }
        if (this.activeConnectionsReverse.containsKey(uniqueIdentifier.getGlyphString())) {
            return new GlyphIdentifier(this.activeConnectionsReverse.get(uniqueIdentifier.getGlyphString()));
        }
        return null;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getEnergyStoragePerRow() {
        return (int)((double)(this.is3x3 ? ENERGY_STORAGE_PER_ROW + ENERGY_STORAGE_PER_ROW / 2 : ENERGY_STORAGE_PER_ROW) * CommonProxy.CONFIG_POWER_STORAGE_MULTIPLIER);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    public String func_145825_b() {
        return "tile.stabilizer.name";
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory;
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean hasEnoughPowerToStart() {
        if (!GeneralUtils.hasEnergyCost()) {
            return true;
        }
        int powerRequirement = (int)(GeneralUtils.getPowerMultiplier() * (double)CommonProxy.CONFIG_REDSTONE_FLUX_COST);
        return this.extractEnergy(null, (int)((double)powerRequirement * 0.3), true) == (int)((double)powerRequirement * 0.3);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return GeneralUtils.isEnergyContainerItem(itemstack);
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    @Override
    public void packetGuiFill(ByteBuf buffer) {
        buffer.writeInt(this.activeConnections.size());
        buffer.writeInt(this.powerState);
        buffer.writeInt(this.instability);
        buffer.writeInt(this.energyStorage.getMaxEnergyStored());
        buffer.writeInt(this.energyStorage.getEnergyStored());
    }

    @Override
    public void packetGuiUse(ByteBuf buffer) {
        if (buffer.readableBytes() <= 1) {
            return;
        }
        this.intActiveConnections = buffer.readInt();
        this.powerState = buffer.readInt();
        this.instability = buffer.readInt();
        this.energyStorage.setCapacity(buffer.readInt());
        this.energyStorage.setEnergyStored(buffer.readInt());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.powerState = tag.func_74762_e("powerState");
        this.is3x3 = tag.func_74767_n("is3x3");
        this.rows = tag.func_74762_e("rows");
        this.energyStorage = new EnergyStorage(this.rows * this.getEnergyStoragePerRow());
        this.blockList = GeneralUtils.loadChunkCoordList(tag, "blockList");
        this.energyStorage.readFromNBT(tag);
        if (tag.func_74764_b("activeConnections")) {
            NBTTagList c = tag.func_150295_c("activeConnections", 10);
            for (int i = 0; i < c.func_74745_c(); ++i) {
                NBTTagCompound t = c.func_150305_b(i);
                String A = t.func_74779_i("Key");
                String B = t.func_74779_i("Value");
                this.activeConnections.put(A, B);
                this.activeConnectionsReverse.put(B, A);
            }
        }
        if (tag.func_74764_b("inventory")) {
            this.inventory = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("inventory"));
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public void removeExistingConnection(GlyphIdentifier portalA, GlyphIdentifier portalB) {
        this.activeConnections.remove(portalA.getGlyphString());
        this.activeConnections.remove(portalB.getGlyphString());
        this.activeConnectionsReverse.remove(portalA.getGlyphString());
        this.activeConnectionsReverse.remove(portalB.getGlyphString());
        if (this.activeConnections.size() == 0 && this.powerState == 0 && this.instability > 0) {
            this.setInstability(0);
        }
    }

    public void setData(ArrayList<ChunkCoordinates> blocks, int rows2, boolean is3) {
        this.is3x3 = is3;
        this.rows = rows2;
        this.blockList = blocks;
        this.energyStorage = new EnergyStorage(this.rows * this.getEnergyStoragePerRow());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    void setInstability(int newInstability) {
        if (newInstability == this.instability) {
            return;
        }
        this.instability = newInstability;
        for (Map.Entry<String, String> pair : this.activeConnections.entrySet()) {
            TileController controllerA = EnhancedPortals.proxy.networkManager.getPortalController(new GlyphIdentifier(pair.getKey()));
            TileController controllerB = EnhancedPortals.proxy.networkManager.getPortalController(new GlyphIdentifier(pair.getValue()));
            if (controllerA != null) {
                controllerA.setInstability(newInstability);
            }
            if (controllerB == null) continue;
            controllerB.setInstability(newInstability);
        }
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory = itemstack;
    }

    public boolean setupNewConnection(GlyphIdentifier portalA, GlyphIdentifier portalB, PortalTextureManager textureManager) throws PortalException {
        if (this.activeConnections.containsKey(portalA.getGlyphString())) {
            throw new PortalException("diallingPortalAlreadyActive");
        }
        if (this.activeConnections.containsValue(portalB.getGlyphString())) {
            throw new PortalException("receivingPortalAlreadyActive");
        }
        if (!this.hasEnoughPowerToStart()) {
            throw new PortalException("notEnoughPowerToStart");
        }
        if (!this.canAcceptNewConnection()) {
            throw new PortalException("maxedConnectionLimit");
        }
        if (portalA.equals(portalB)) {
            throw new PortalException("cannotDialDiallingPortal");
        }
        if (!EnhancedPortals.proxy.networkManager.portalIdentifierExists(portalA)) {
            throw new PortalException("noPortalWithThatIdentifierSending");
        }
        if (!EnhancedPortals.proxy.networkManager.portalIdentifierExists(portalB)) {
            throw new PortalException("noPortalWithThatIdentifierReceiving");
        }
        TileController cA = EnhancedPortals.proxy.networkManager.getPortalController(portalA);
        TileController cB = EnhancedPortals.proxy.networkManager.getPortalController(portalB);
        if (cA == null) {
            throw new PortalException("diallingPortalNotFound");
        }
        if (cB == null) {
            throw new PortalException("receivingPortalNotFound");
        }
        if (cA.isPortalActive()) {
            throw new PortalException("diallingPortalAlreadyActive");
        }
        if (cB.isPortalActive()) {
            throw new PortalException("receivingPortalAlreadyActive");
        }
        if (!cA.isFinalized()) {
            throw new PortalException("sendingPortalNotInitialized");
        }
        if (!cB.isFinalized()) {
            throw new PortalException("receivingPortalNotInitialized");
        }
        if (cA.getDiallingDevices().size() > 0 && cB.getNetworkInterfaces().size() > 0) {
            throw new PortalException("receivingPortalNoDialler");
        }
        if (cA.getNetworkInterfaces().size() > 0 && cB.getDiallingDevices().size() > 0) {
            throw new PortalException("sendingPortalNoDialler");
        }
        TileStabilizerMain sA = cA.getDimensionalBridgeStabilizer();
        TileStabilizerMain sB = cB.getDimensionalBridgeStabilizer();
        if (!sA.getDimensionCoordinates().equals((Object)sB.getDimensionCoordinates())) {
            if (cB.isPublic) {
                cB.setupTemporaryDBS(sA);
            } else {
                throw new PortalException("notOnSameStabilizer");
            }
        }
        if (textureManager != null && !textureManager.isDefault()) {
            cA.swapTextureData(textureManager);
            cB.swapTextureData(textureManager);
        }
        try {
            cA.setInstability(this.instability);
            cA.portalCreate();
            cA.cacheDestination(portalB, cB.getDimensionCoordinates());
        }
        catch (PortalException e) {
            cA.revertTextureData();
            cB.revertTextureData();
            throw new PortalException("sendingPortalFailedToCreatePortal");
        }
        try {
            cB.setInstability(this.instability);
            cB.portalCreate();
            cB.cacheDestination(portalA, cA.getDimensionCoordinates());
        }
        catch (PortalException e) {
            cA.portalRemove();
            cA.cacheDestination(null, null);
            cA.revertTextureData();
            cB.revertTextureData();
            throw new PortalException("receivingPortalFailedToCreatePortal");
        }
        this.activeConnections.put(portalA.getGlyphString(), portalB.getGlyphString());
        this.activeConnectionsReverse.put(portalB.getGlyphString(), portalA.getGlyphString());
        return true;
    }

    public void terminateExistingConnection(GlyphIdentifier identifier) throws PortalException {
        if (identifier == null || identifier.isEmpty()) {
            throw new PortalException("No identifier found for first portal");
        }
        GlyphIdentifier portalA = new GlyphIdentifier(identifier);
        GlyphIdentifier portalB = null;
        if (this.activeConnections.containsKey(identifier.getGlyphString())) {
            portalB = new GlyphIdentifier(this.activeConnections.get(identifier.getGlyphString()));
        } else if (this.activeConnectionsReverse.containsKey(identifier.getGlyphString())) {
            portalB = new GlyphIdentifier(this.activeConnectionsReverse.get(identifier.getGlyphString()));
        }
        this.terminateExistingConnection(portalA, portalB);
    }

    public void terminateExistingConnection(GlyphIdentifier portalA, GlyphIdentifier portalB) throws PortalException {
        if (portalA == null) {
            throw new PortalException("No identifier found for first portal");
        }
        if (portalB == null) {
            throw new PortalException("No identifier found for second portal");
        }
        TileController cA = EnhancedPortals.proxy.networkManager.getPortalController(portalA);
        TileController cB = EnhancedPortals.proxy.networkManager.getPortalController(portalB);
        if (cA == null || cB == null) {
            if (cA == null) {
                throw new PortalException("No identifier found for first portal");
            }
            if (cB == null) {
                throw new PortalException("No identifier found for second portal");
            }
            if (cA != null) {
                cA.portalRemove();
                cA.revertTextureData();
                cA.cacheDestination(null, null);
            }
            if (cB != null) {
                cB.portalRemove();
                cB.revertTextureData();
                cB.cacheDestination(null, null);
            }
            this.removeExistingConnection(portalA, portalB);
        } else if (this.activeConnections.containsKey(portalA.getGlyphString()) && this.activeConnections.get(portalA.getGlyphString()).equals(portalB.getGlyphString()) || this.activeConnectionsReverse.containsKey(portalA.getGlyphString()) && this.activeConnectionsReverse.get(portalA.getGlyphString()).equals(portalB.getGlyphString())) {
            cA.portalRemove();
            cB.portalRemove();
            cA.cacheDestination(null, null);
            cB.cacheDestination(null, null);
            cA.revertTextureData();
            cB.revertTextureData();
            this.removeExistingConnection(portalA, portalB);
        } else {
            throw new PortalException("Could not find both portals in the active connection list.");
        }
    }

    public void func_145845_h() {
        if (this.activeConnections.size() > 0 && GeneralUtils.hasEnergyCost() && this.tickTimer >= CommonProxy.CONFIG_REDSTONE_FLUX_TIMER) {
            int powerRequirement = (int)(GeneralUtils.getPowerMultiplier() * (double)this.activeConnections.size() * (double)CommonProxy.CONFIG_REDSTONE_FLUX_COST);
            if (this.powerState == 0 && this.extractEnergy(null, powerRequirement, true) == powerRequirement) {
                this.extractEnergy(null, powerRequirement, false);
                this.setInstability(0);
            } else if ((this.powerState == 1 || this.powerState == 0) && this.extractEnergy(null, (int)((double)powerRequirement * 0.8), true) == (int)((double)powerRequirement * 0.8)) {
                this.extractEnergy(null, (int)((double)powerRequirement * 0.8), false);
                this.setInstability(20);
            } else if ((this.powerState == 2 || this.powerState == 0) && this.extractEnergy(null, (int)((double)powerRequirement * 0.5), true) == (int)((double)powerRequirement * 0.5)) {
                this.extractEnergy(null, (int)((double)powerRequirement * 0.5), false);
                this.setInstability(50);
            } else if ((this.powerState == 3 || this.powerState == 0) && this.extractEnergy(null, (int)((double)powerRequirement * 0.3), true) == (int)((double)powerRequirement * 0.3)) {
                this.extractEnergy(null, (int)((double)powerRequirement * 0.3), false);
                this.setInstability(70);
            } else {
                for (int i = this.activeConnections.size() - 1; i > -1; --i) {
                    try {
                        this.terminateExistingConnection(new GlyphIdentifier(this.activeConnections.values().toArray(new String[this.activeConnections.size()])[i]));
                        continue;
                    }
                    catch (PortalException e) {
                        CommonProxy.logger.warn(e.getMessage());
                    }
                }
                this.setInstability(0);
            }
            this.tickTimer = -1;
        }
        if (this.inventory != null) {
            if (this.inventory.func_77973_b() instanceof IEnergyContainerItem) {
                int requiredEnergy = this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored();
                if (requiredEnergy > 0 && ((IEnergyContainerItem)this.inventory.func_77973_b()).getEnergyStored(this.inventory) > 0) {
                    this.energyStorage.receiveEnergy(((IEnergyContainerItem)this.inventory.func_77973_b()).extractEnergy(this.inventory, Math.min(requiredEnergy, 10000), false), false);
                }
            } else if (this.inventory.func_77973_b() == ItemLocationCard.instance && !ItemLocationCard.hasDBSLocation(this.inventory) && !this.field_145850_b.field_72995_K) {
                ItemLocationCard.setDBSLocation(this.inventory, this.getDimensionCoordinates());
            }
        }
        ++this.tickTimer;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.energyStorage.writeToNBT(tag);
        tag.func_74757_a("is3x3", this.is3x3);
        tag.func_74768_a("powerState", this.powerState);
        tag.func_74768_a("rows", this.rows);
        GeneralUtils.saveChunkCoordList(tag, this.blockList, "blockList");
        if (!this.activeConnections.isEmpty()) {
            NBTTagList c = new NBTTagList();
            for (Map.Entry<String, String> entry : this.activeConnections.entrySet()) {
                NBTTagCompound t = new NBTTagCompound();
                t.func_74778_a("Key", entry.getKey());
                t.func_74778_a("Value", entry.getValue());
                c.func_74742_a((NBTBase)t);
            }
            tag.func_74782_a("activeConnections", (NBTBase)c);
        }
        if (this.inventory != null) {
            NBTTagCompound t = new NBTTagCompound();
            this.inventory.func_77955_b(t);
            tag.func_74782_a("inventory", (NBTBase)t);
        }
    }
}

