/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import enhancedportals.item.ItemNanobrush;
import enhancedportals.network.GuiHandler;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileFrame;
import enhancedportals.utility.GeneralUtils;
import enhancedportals.utility.Localization;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileNetworkInterface
extends TileFrame
implements IPeripheral,
SimpleComponent {
    @Override
    public boolean activate(EntityPlayer player, ItemStack stack) {
        if (player.func_70093_af()) {
            return false;
        }
        TileController controller = this.getPortalController();
        if (stack != null && controller != null && controller.isFinalized()) {
            if (GeneralUtils.isWrench(stack) && !player.func_70093_af()) {
                if (controller.getIdentifierUnique() == null) {
                    if (!this.field_145850_b.field_72995_K) {
                        player.func_146105_b((IChatComponent)new ChatComponentText(Localization.getChatError("noUidSet")));
                    }
                } else {
                    GuiHandler.openGui(player, controller, 2);
                }
            } else if (stack.func_77973_b() == ItemNanobrush.instance) {
                GuiHandler.openGui(player, controller, 8);
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDataToPacket(NBTTagCompound tag) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        if (method == 0) {
            this.getPortalController().connectionDial();
        } else if (method == 1) {
            this.getPortalController().connectionTerminate();
        }
        return null;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Callback(doc="function():boolean -- Attempts to create a connection to the next portal in the network.")
    @Optional.Method(modid="OpenComputers")
    public Object[] dial(Context context, Arguments args) {
        this.getPortalController().connectionDial();
        return new Object[]{true};
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other == this;
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ep_interface_network";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"dial", "terminate"};
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "ep_interface_network";
    }

    @Override
    public void onDataPacket(NBTTagCompound tag) {
    }

    @Callback(doc="function():boolean -- Terminates any active connection.")
    @Optional.Method(modid="OpenComputers")
    public Object[] terminate(Context context, Arguments args) {
        this.getPortalController().connectionTerminate();
        return new Object[]{true};
    }
}

