/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.ByteBufUtils;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import enhancedportals.network.GuiHandler;
import enhancedportals.portal.GlyphElement;
import enhancedportals.portal.GlyphIdentifier;
import enhancedportals.portal.PortalTextureManager;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TileFrame;
import enhancedportals.utility.ComputerUtils;
import enhancedportals.utility.Localization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileDialingDevice
extends TileFrame
implements IPeripheral,
SimpleComponent {
    public ArrayList<GlyphElement> glyphList = new ArrayList();

    @Override
    public boolean activate(EntityPlayer player, ItemStack stack) {
        TileController controller = this.getPortalController();
        if (this.field_145850_b.field_72995_K) {
            return controller != null;
        }
        if (controller != null && controller.isFinalized()) {
            if (controller.getIdentifierUnique() == null) {
                player.func_146105_b((IChatComponent)new ChatComponentText(Localization.getChatError("noUidSet")));
            } else if (!player.func_70093_af()) {
                GuiHandler.openGui(player, this, 4);
            } else if (controller.isPortalActive()) {
                controller.connectionTerminate();
            } else {
                GuiHandler.openGui(player, this, 5);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addDataToPacket(NBTTagCompound tag) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        if (method == 0) {
            return this.comp_Dial(arguments);
        }
        if (method == 1) {
            this.getPortalController().connectionTerminate();
        } else {
            if (method == 2) {
                return this.comp_DialStored(arguments);
            }
            if (method == 3) {
                return this.comp_GetStoredName(arguments);
            }
            if (method == 4) {
                return this.comp_GetStoredGlyph(arguments);
            }
            if (method == 5) {
                return new Object[]{this.glyphList.size()};
            }
        }
        return null;
    }

    Object[] comp_Dial(Object[] arguments) throws Exception {
        String s;
        if (arguments.length == 1) {
            s = arguments[0].toString();
            String error = ComputerUtils.verifyGlyphArguments(s = s.replace(" ", "-"));
            if (error != null) {
                throw new Exception(error);
            }
        } else {
            throw new Exception("Invalid arguments");
        }
        this.getPortalController().connectionDial(new GlyphIdentifier(s), null, null);
        return new Object[]{true};
    }

    Object[] comp_DialStored(Object[] arguments) throws Exception {
        int num = this.getSelectedEntry(arguments);
        if (num >= 0 && num < this.glyphList.size()) {
            this.getPortalController().connectionDial(this.glyphList.get((int)num).identifier, null, null);
        }
        return new Object[]{true};
    }

    Object[] comp_GetStoredGlyph(Object[] arguments) throws Exception {
        int num = this.getSelectedEntry(arguments);
        GlyphElement entry = this.glyphList.get(num);
        if (entry != null) {
            return new Object[]{entry.identifier.getGlyphString()};
        }
        throw new Exception("Entry not found");
    }

    Object[] comp_GetStoredName(Object[] arguments) throws Exception {
        int num = this.getSelectedEntry(arguments);
        GlyphElement entry = this.glyphList.get(num);
        if (entry != null) {
            return new Object[]{entry.name};
        }
        throw new Exception("Entry not found");
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Callback(doc="function(uid:string):boolean -- Attempts to create a connection to the specified portal. UID must be given as a single string in the format of numbers separated by spaces.")
    @Optional.Method(modid="OpenComputers")
    public Object[] dial(Context context, Arguments args) throws Exception {
        if (args.count() < 1) {
            return null;
        }
        return this.comp_Dial(ComputerUtils.argsToArray(args));
    }

    @Callback(doc="function(entry:number):boolean -- Dials the specified entry in the Dialing Device's list.")
    @Optional.Method(modid="OpenComputers")
    public Object[] dialStored(Context context, Arguments args) throws Exception {
        return this.comp_DialStored(ComputerUtils.argsToArray(args));
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other == this;
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ep_dialling_device";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"dial", "terminate", "dialStored", "getStoredName", "getStoredGlyph", "getStoredCount"};
    }

    int getSelectedEntry(Object[] arguments) throws Exception {
        try {
            if (arguments.length == 1) {
                int i;
                if (arguments[0].toString().contains(".")) {
                    arguments[0] = arguments[0].toString().substring(0, arguments[0].toString().indexOf("."));
                }
                if ((i = Integer.parseInt(arguments[0].toString())) < 0 || i >= this.glyphList.size()) {
                    throw new Exception("There is no entry in location " + i);
                }
                return i;
            }
        }
        catch (NumberFormatException e) {
            throw new Exception(arguments[0].toString() + " is not an integer.");
        }
        throw new Exception("Invalid number of arguments.");
    }

    @Callback(direct=true, doc="function():number -- Returns the amount of entries in the Dialing Device's list.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getStoredCount(Context context, Arguments args) {
        return new Object[]{this.glyphList.size()};
    }

    @Callback(direct=true, doc="function(entry:number):string -- Returns the UID as a string of the specified entry in the Dialing Device's list.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getStoredGlyph(Context context, Arguments args) throws Exception {
        return this.comp_GetStoredGlyph(ComputerUtils.argsToArray(args));
    }

    @Callback(direct=true, doc="function(entry:number):string -- Returns the name of the specified entry in the Dialing Device's list.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getStoredName(Context context, Arguments args) throws Exception {
        return this.comp_GetStoredName(ComputerUtils.argsToArray(args));
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "ep_dialling_device";
    }

    @Override
    public void onDataPacket(NBTTagCompound tag) {
    }

    @Override
    public void packetGuiFill(ByteBuf buffer) {
        buffer.writeInt(this.glyphList.size());
        for (int i = 0; i < this.glyphList.size(); ++i) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.glyphList.get((int)i).name);
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.glyphList.get((int)i).identifier.getGlyphString());
        }
    }

    @Override
    public void packetGuiUse(ByteBuf buffer) {
        int max = buffer.readInt();
        this.glyphList.clear();
        for (int i = 0; i < max; ++i) {
            this.glyphList.add(new GlyphElement(ByteBufUtils.readUTF8String((ByteBuf)buffer), new GlyphIdentifier(ByteBufUtils.readUTF8String((ByteBuf)buffer))));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("glyphList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound t = list.func_150305_b(i);
            String name = t.func_74779_i("Name");
            String glyph = t.func_74779_i("Identifier");
            if (t.func_74764_b("texture")) {
                PortalTextureManager tex = new PortalTextureManager();
                tex.readFromNBT(t, "texture");
                this.glyphList.add(new GlyphElement(name, new GlyphIdentifier(glyph), tex));
                continue;
            }
            this.glyphList.add(new GlyphElement(name, new GlyphIdentifier(glyph)));
        }
    }

    @Callback(doc="function():boolean -- Terminates any active connection.")
    @Optional.Method(modid="OpenComputers")
    public Object[] terminate(Context context, Arguments args) {
        this.getPortalController().connectionTerminate();
        return new Object[]{true};
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.glyphList.size(); ++i) {
            NBTTagCompound t = new NBTTagCompound();
            GlyphElement e = this.glyphList.get(i);
            t.func_74778_a("Name", e.name);
            t.func_74778_a("Identifier", e.identifier.getGlyphString());
            if (e.hasSpecificTexture()) {
                e.texture.writeToNBT(t, "texture");
            }
            list.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("glyphList", (NBTBase)list);
    }
}

