/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import enhancedportals.EnhancedPortals;
import enhancedportals.block.BlockPortal;
import enhancedportals.item.ItemLocationCard;
import enhancedportals.item.ItemNanobrush;
import enhancedportals.network.CommonProxy;
import enhancedportals.network.GuiHandler;
import enhancedportals.network.packet.PacketEP;
import enhancedportals.network.packet.PacketRerender;
import enhancedportals.portal.EntityManager;
import enhancedportals.portal.GlyphIdentifier;
import enhancedportals.portal.PortalException;
import enhancedportals.portal.PortalTextureManager;
import enhancedportals.portal.PortalUtils;
import enhancedportals.tile.TileDialingDevice;
import enhancedportals.tile.TileFrame;
import enhancedportals.tile.TileFrameBasic;
import enhancedportals.tile.TileNetworkInterface;
import enhancedportals.tile.TilePortal;
import enhancedportals.tile.TilePortalManipulator;
import enhancedportals.tile.TilePortalPart;
import enhancedportals.tile.TileRedstoneInterface;
import enhancedportals.tile.TileStabilizer;
import enhancedportals.tile.TileStabilizerMain;
import enhancedportals.tile.TileTransferEnergy;
import enhancedportals.tile.TileTransferFluid;
import enhancedportals.tile.TileTransferItem;
import enhancedportals.utility.ComputerUtils;
import enhancedportals.utility.DimensionCoordinates;
import enhancedportals.utility.GeneralUtils;
import enhancedportals.utility.Localization;
import java.util.ArrayList;
import java.util.Random;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.WorldServer;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileController
extends TileFrame
implements IPeripheral,
SimpleComponent {
    ArrayList<ChunkCoordinates> portalFrames = new ArrayList();
    ArrayList<ChunkCoordinates> portalBlocks = new ArrayList();
    ArrayList<ChunkCoordinates> redstoneInterfaces = new ArrayList();
    ArrayList<ChunkCoordinates> networkInterfaces = new ArrayList();
    ArrayList<ChunkCoordinates> diallingDevices = new ArrayList();
    ArrayList<ChunkCoordinates> transferFluids = new ArrayList();
    ArrayList<ChunkCoordinates> transferItems = new ArrayList();
    ArrayList<ChunkCoordinates> transferEnergy = new ArrayList();
    ChunkCoordinates moduleManipulator;
    DimensionCoordinates dimensionalBridgeStabilizer;
    DimensionCoordinates temporaryDBS;
    public PortalTextureManager activeTextureData = new PortalTextureManager();
    public PortalTextureManager inactiveTextureData;
    ControlState portalState = ControlState.REQUIRES_LOCATION;
    public int connectedPortals = -1;
    public int instability = 0;
    public int portalType = 0;
    boolean processing;
    public boolean isPublic;
    GlyphIdentifier cachedDestinationUID;
    DimensionCoordinates cachedDestinationLoc;
    @SideOnly(value=Side.CLIENT)
    GlyphIdentifier uID;
    @SideOnly(value=Side.CLIENT)
    GlyphIdentifier nID;

    @Override
    public boolean activate(EntityPlayer player, ItemStack stack) {
        if (player.func_70093_af()) {
            return false;
        }
        try {
            if (stack != null) {
                if (this.portalState == ControlState.REQUIRES_LOCATION) {
                    if (stack.func_77973_b() == ItemLocationCard.instance && !this.field_145850_b.field_72995_K) {
                        boolean reconfiguring = this.dimensionalBridgeStabilizer != null;
                        this.setDBS(player, stack);
                        this.configurePortal();
                        player.func_146105_b((IChatComponent)new ChatComponentText(Localization.getChatSuccess(!reconfiguring ? "create" : "reconfigure")));
                    }
                    return true;
                }
                if (this.portalState == ControlState.REQUIRES_WRENCH) {
                    if (GeneralUtils.isWrench(stack) && !this.field_145850_b.field_72995_K) {
                        this.configurePortal();
                        player.func_146105_b((IChatComponent)new ChatComponentText(Localization.getChatSuccess("reconfigure")));
                    }
                    return true;
                }
                if (this.portalState == ControlState.FINALIZED) {
                    if (GeneralUtils.isWrench(stack)) {
                        GuiHandler.openGui(player, this, 0);
                        return true;
                    }
                    if (stack.func_77973_b() == ItemNanobrush.instance) {
                        GuiHandler.openGui(player, this, 8);
                        return true;
                    }
                }
            }
        }
        catch (PortalException e) {
            player.func_146105_b((IChatComponent)new ChatComponentText(e.getMessage()));
        }
        return false;
    }

    @Override
    public void addDataToPacket(NBTTagCompound tag) {
        tag.func_74774_a("PortalState", (byte)this.portalState.ordinal());
        tag.func_74757_a("PortalActive", this.isPortalActive());
        tag.func_74768_a("Instability", this.instability);
        if (this.isPortalActive()) {
            tag.func_74778_a("DestUID", this.cachedDestinationUID.getGlyphString());
            tag.func_74768_a("destX", this.cachedDestinationLoc.field_71574_a);
            tag.func_74768_a("destY", this.cachedDestinationLoc.field_71572_b);
            tag.func_74768_a("destZ", this.cachedDestinationLoc.field_71573_c);
            tag.func_74768_a("destD", this.cachedDestinationLoc.dimension);
        }
        this.activeTextureData.writeToNBT(tag, "Texture");
        if (this.moduleManipulator != null) {
            tag.func_74768_a("ModX", this.moduleManipulator.field_71574_a);
            tag.func_74768_a("ModY", this.moduleManipulator.field_71572_b);
            tag.func_74768_a("ModZ", this.moduleManipulator.field_71573_c);
        }
    }

    public void addDialDevice(ChunkCoordinates chunkCoordinates) {
        this.diallingDevices.add(chunkCoordinates);
    }

    public void addNetworkInterface(ChunkCoordinates chunkCoordinates) {
        this.networkInterfaces.add(chunkCoordinates);
    }

    public void addRedstoneInterface(ChunkCoordinates chunkCoordinates) {
        this.redstoneInterfaces.add(chunkCoordinates);
    }

    public void addTransferEnergy(ChunkCoordinates chunkCoordinates) {
        this.transferEnergy.add(chunkCoordinates);
    }

    public void addTransferFluid(ChunkCoordinates chunkCoordinates) {
        this.transferFluids.add(chunkCoordinates);
    }

    public void addTransferItem(ChunkCoordinates chunkCoordinates) {
        this.transferItems.add(chunkCoordinates);
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void breakBlock(Block b, int oldMetadata) {
        try {
            this.deconstruct();
            this.setIdentifierNetwork(new GlyphIdentifier());
            this.setIdentifierUnique(new GlyphIdentifier());
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
    }

    public void cacheDestination(GlyphIdentifier id, DimensionCoordinates wc) {
        this.cachedDestinationUID = id;
        this.cachedDestinationLoc = wc;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        if (method == 0) {
            return new Object[]{this.isPortalActive()};
        }
        if (method == 1) {
            return this.comp_GetUniqueIdentifier();
        }
        if (method == 2) {
            return this.comp_SetUniqueIdentifier(arguments);
        }
        if (method == 3) {
            return new Object[]{this.activeTextureData.getFrameColour()};
        }
        if (method == 4) {
            return this.comp_SetFrameColour(arguments);
        }
        if (method == 5) {
            return new Object[]{this.activeTextureData.getPortalColour()};
        }
        if (method == 6) {
            return this.comp_SetPortalColour(arguments);
        }
        if (method == 7) {
            return new Object[]{this.activeTextureData.getParticleColour()};
        }
        if (method == 8) {
            return this.comp_SetParticleColour(arguments);
        }
        return null;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    Object[] comp_GetUniqueIdentifier() {
        GlyphIdentifier identifier = this.getIdentifierUnique();
        if (identifier == null || identifier.isEmpty()) {
            return new Object[]{""};
        }
        return new Object[]{identifier.getGlyphString()};
    }

    Object[] comp_SetFrameColour(Object[] arguments) throws Exception {
        if (arguments.length > 1 || arguments.length == 1 && arguments[0].toString().length() == 0) {
            throw new Exception("Invalid arguments");
        }
        try {
            int hex = Integer.parseInt(arguments.length == 1 ? arguments[0].toString() : "FFFFFF", 16);
            this.setFrameColour(hex);
        }
        catch (NumberFormatException ex) {
            throw new Exception("Couldn't parse input as hexidecimal");
        }
        return new Object[]{true};
    }

    Object[] comp_SetParticleColour(Object[] arguments) throws Exception {
        if (arguments.length > 1 || arguments.length == 1 && arguments[0].toString().length() == 0) {
            throw new Exception("Invalid arguments");
        }
        try {
            this.setParticleColour(new PortalTextureManager().getParticleColour());
        }
        catch (NumberFormatException ex) {
            throw new Exception("Couldn't parse input as hexidecimal");
        }
        return new Object[]{true};
    }

    Object[] comp_SetPortalColour(Object[] arguments) throws Exception {
        if (arguments.length > 1 || arguments.length == 1 && arguments[0].toString().length() == 0) {
            throw new Exception("Invalid arguments");
        }
        try {
            int hex = Integer.parseInt(arguments.length == 1 ? arguments[0].toString() : "FFFFFF", 16);
            this.setPortalColour(hex);
        }
        catch (NumberFormatException ex) {
            throw new Exception("Couldn't parse input as hexidecimal");
        }
        return new Object[]{true};
    }

    Object[] comp_SetUniqueIdentifier(Object[] arguments) throws Exception {
        String s;
        if (arguments.length == 0) {
            this.setIdentifierUnique(new GlyphIdentifier());
            return this.comp_GetUniqueIdentifier();
        }
        if (arguments.length == 1) {
            s = arguments[0].toString();
            String error = ComputerUtils.verifyGlyphArguments(s = s.replace(" ", "-"));
            if (error != null) {
                throw new Exception(error);
            }
        } else {
            throw new Exception("Invalid arguments");
        }
        this.setIdentifierUnique(new GlyphIdentifier(s));
        return this.comp_GetUniqueIdentifier();
    }

    void configurePortal() throws PortalException {
        ArrayList<ChunkCoordinates> portalStructure = PortalUtils.getAllPortalComponents(this);
        for (ChunkCoordinates c : portalStructure) {
            TileEntity tile = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (!(tile instanceof TileController)) {
                if (tile instanceof TileFrameBasic) {
                    this.portalFrames.add(c);
                } else if (tile instanceof TileRedstoneInterface) {
                    this.redstoneInterfaces.add(c);
                } else if (tile instanceof TileNetworkInterface) {
                    this.networkInterfaces.add(c);
                } else if (tile instanceof TileDialingDevice) {
                    this.diallingDevices.add(c);
                } else if (tile instanceof TilePortalManipulator) {
                    this.moduleManipulator = c;
                } else if (tile instanceof TileTransferFluid) {
                    this.transferFluids.add(c);
                } else if (tile instanceof TileTransferItem) {
                    this.transferItems.add(c);
                } else if (tile instanceof TileTransferEnergy) {
                    this.transferEnergy.add(c);
                } else {
                    this.portalBlocks.add(c);
                    continue;
                }
            }
            ((TilePortalPart)tile).setPortalController(this.getChunkCoordinates());
        }
        this.portalState = ControlState.FINALIZED;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void connectionDial() {
        block4: {
            if (this.field_145850_b.field_72995_K || this.getIdentifierNetwork() == null) {
                return;
            }
            try {
                TileStabilizerMain dbs = this.getDimensionalBridgeStabilizer();
                if (dbs == null) {
                    this.portalState = ControlState.REQUIRES_LOCATION;
                    throw new PortalException("stabilizerNotFound");
                }
                dbs.setupNewConnection(this.getIdentifierUnique(), EnhancedPortals.proxy.networkManager.getDestination(this.getIdentifierUnique(), this.getIdentifierNetwork()), null);
            }
            catch (PortalException e) {
                EntityPlayer player = this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 128.0);
                if (player == null) break block4;
                player.func_146105_b((IChatComponent)new ChatComponentText(e.getMessage()));
            }
        }
        this.func_70296_d();
    }

    public void connectionDial(GlyphIdentifier id, PortalTextureManager m, EntityPlayer player) {
        block5: {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            try {
                TileStabilizerMain dbs = this.getDimensionalBridgeStabilizer();
                if (dbs == null) {
                    this.portalState = ControlState.REQUIRES_LOCATION;
                    throw new PortalException("stabilizerNotFound");
                }
                dbs.setupNewConnection(this.getIdentifierUnique(), id, m);
            }
            catch (PortalException e) {
                if (player == null) {
                    player = this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 128.0);
                }
                if (player == null) break block5;
                player.func_146105_b((IChatComponent)new ChatComponentText(e.getMessage()));
            }
        }
        this.func_70296_d();
    }

    public void connectionTerminate() {
        if (this.field_145850_b.field_72995_K || this.processing) {
            return;
        }
        try {
            TileStabilizerMain dbs = this.getDimensionalBridgeStabilizer();
            if (dbs == null) {
                this.portalState = ControlState.REQUIRES_LOCATION;
                throw new PortalException("stabilizerNotFound");
            }
            dbs.terminateExistingConnection(this.getIdentifierUnique());
        }
        catch (PortalException e) {
            CommonProxy.logger.catching((Throwable)e);
        }
        this.temporaryDBS = null;
        this.func_70296_d();
    }

    public void deconstruct() {
        TileEntity t;
        TileEntity t2;
        if (this.processing) {
            return;
        }
        if (this.isPortalActive()) {
            this.connectionTerminate();
        }
        for (ChunkCoordinates c : this.portalFrames) {
            t2 = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (t2 == null || !(t2 instanceof TilePortalPart)) continue;
            ((TilePortalPart)t2).setPortalController(null);
        }
        for (ChunkCoordinates c : this.redstoneInterfaces) {
            t2 = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (t2 == null || !(t2 instanceof TilePortalPart)) continue;
            ((TilePortalPart)t2).setPortalController(null);
        }
        for (ChunkCoordinates c : this.networkInterfaces) {
            t2 = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (t2 == null || !(t2 instanceof TilePortalPart)) continue;
            ((TilePortalPart)t2).setPortalController(null);
        }
        for (ChunkCoordinates c : this.diallingDevices) {
            t2 = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (t2 == null || !(t2 instanceof TilePortalPart)) continue;
            ((TilePortalPart)t2).setPortalController(null);
        }
        for (ChunkCoordinates c : this.transferFluids) {
            t2 = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (t2 == null || !(t2 instanceof TilePortalPart)) continue;
            ((TilePortalPart)t2).setPortalController(null);
        }
        for (ChunkCoordinates c : this.transferItems) {
            t2 = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (t2 == null || !(t2 instanceof TilePortalPart)) continue;
            ((TilePortalPart)t2).setPortalController(null);
        }
        for (ChunkCoordinates c : this.transferEnergy) {
            t2 = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (t2 == null || !(t2 instanceof TilePortalPart)) continue;
            ((TilePortalPart)t2).setPortalController(null);
        }
        if (this.moduleManipulator != null && (t = this.field_145850_b.func_147438_o(this.moduleManipulator.field_71574_a, this.moduleManipulator.field_71572_b, this.moduleManipulator.field_71573_c)) != null && t instanceof TilePortalPart) {
            ((TilePortalPart)t).setPortalController(null);
        }
        this.portalBlocks.clear();
        this.portalFrames.clear();
        this.redstoneInterfaces.clear();
        this.networkInterfaces.clear();
        this.diallingDevices.clear();
        this.transferFluids.clear();
        this.transferItems.clear();
        this.transferEnergy.clear();
        this.moduleManipulator = null;
        this.portalState = ControlState.REQUIRES_WRENCH;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other == this;
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ep_controller";
    }

    public GlyphIdentifier getDestination() {
        return this.cachedDestinationUID;
    }

    public DimensionCoordinates getDestinationLocation() {
        return this.cachedDestinationLoc;
    }

    public TileDialingDevice getDialDeviceRandom() {
        ChunkCoordinates dial = null;
        if (this.diallingDevices.isEmpty()) {
            return null;
        }
        dial = this.diallingDevices.size() == 1 ? this.diallingDevices.get(0) : this.diallingDevices.get(new Random().nextInt(this.diallingDevices.size()));
        TileEntity tile = this.field_145850_b.func_147438_o(dial.field_71574_a, dial.field_71572_b, dial.field_71573_c);
        if (tile != null && tile instanceof TileDialingDevice) {
            return (TileDialingDevice)tile;
        }
        return null;
    }

    public ArrayList<ChunkCoordinates> getDiallingDevices() {
        return this.diallingDevices;
    }

    public TileStabilizerMain getDimensionalBridgeStabilizer() {
        TileStabilizer t;
        TileStabilizerMain m;
        TileEntity tile;
        WorldServer w;
        if (this.temporaryDBS != null) {
            w = this.temporaryDBS.getWorld();
            tile = w.func_147438_o(this.temporaryDBS.field_71574_a, this.temporaryDBS.field_71572_b, this.temporaryDBS.field_71573_c);
            if (tile instanceof TileStabilizerMain) {
                return (TileStabilizerMain)tile;
            }
            if (tile instanceof TileStabilizer && (m = (t = (TileStabilizer)tile).getMainBlock()) != null) {
                this.temporaryDBS = m.getDimensionCoordinates();
                return m;
            }
            this.temporaryDBS = null;
        }
        if (this.dimensionalBridgeStabilizer != null) {
            w = this.dimensionalBridgeStabilizer.getWorld();
            tile = w.func_147438_o(this.dimensionalBridgeStabilizer.field_71574_a, this.dimensionalBridgeStabilizer.field_71572_b, this.dimensionalBridgeStabilizer.field_71573_c);
            if (tile instanceof TileStabilizerMain) {
                return (TileStabilizerMain)tile;
            }
            if (tile instanceof TileStabilizer && (m = (t = (TileStabilizer)tile).getMainBlock()) != null) {
                this.dimensionalBridgeStabilizer = m.getDimensionCoordinates();
                return m;
            }
            this.dimensionalBridgeStabilizer = null;
        }
        return null;
    }

    @Callback(direct=true, doc="function():number -- Returns the hexadecimal colour of the portal frame.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getFrameColour(Context context, Arguments args) throws Exception {
        return new Object[]{this.activeTextureData.getFrameColour()};
    }

    public ArrayList<ChunkCoordinates> getFrames() {
        return this.portalFrames;
    }

    public boolean getHasIdentifierNetwork() {
        return this.getIdentifierNetwork() != null;
    }

    public boolean getHasIdentifierUnique() {
        return this.getIdentifierUnique() != null;
    }

    public GlyphIdentifier getIdentifierNetwork() {
        if (this.field_145850_b.field_72995_K) {
            return this.nID;
        }
        return EnhancedPortals.proxy.networkManager.getPortalNetwork(this.getIdentifierUnique());
    }

    public GlyphIdentifier getIdentifierUnique() {
        if (this.field_145850_b.field_72995_K) {
            return this.uID;
        }
        return EnhancedPortals.proxy.networkManager.getPortalIdentifier(this.getDimensionCoordinates());
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"isPortalActive", "getUniqueIdentifier", "setUniqueIdentifier", "getFrameColour", "setFrameColour", "getPortalColour", "setPortalColour", "getParticleColour", "setParticleColour"};
    }

    public TilePortalManipulator getModuleManipulator() {
        TileEntity tile;
        if (this.moduleManipulator != null && (tile = this.field_145850_b.func_147438_o(this.moduleManipulator.field_71574_a, this.moduleManipulator.field_71572_b, this.moduleManipulator.field_71573_c)) instanceof TilePortalManipulator) {
            return (TilePortalManipulator)tile;
        }
        return null;
    }

    public ArrayList<ChunkCoordinates> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    @Callback(direct=true, doc="function():number -- Returns the hexadecimal colour of the particles.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getParticleColour(Context context, Arguments args) throws Exception {
        return new Object[]{this.activeTextureData.getParticleColour()};
    }

    @Callback(direct=true, doc="function():number -- Returns the hexadecimal colour of the portal.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getPortalColour(Context context, Arguments args) throws Exception {
        return new Object[]{this.activeTextureData.getPortalColour()};
    }

    @Override
    public TileController getPortalController() {
        return this.isFinalized() ? this : null;
    }

    public ArrayList<ChunkCoordinates> getPortals() {
        return this.portalBlocks;
    }

    public ArrayList<ChunkCoordinates> getRedstoneInterfaces() {
        return this.redstoneInterfaces;
    }

    public ArrayList<ChunkCoordinates> getTransferEnergy() {
        return this.transferEnergy;
    }

    public ArrayList<ChunkCoordinates> getTransferFluids() {
        return this.transferFluids;
    }

    public ArrayList<ChunkCoordinates> getTransferItems() {
        return this.transferItems;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "ep_controller";
    }

    @Callback(direct=true, doc="function():string -- Returns a string containing the numeric glyph IDs of each glyph in the unique identifier.")
    @Optional.Method(modid="OpenComputers")
    public Object[] getUniqueIdentifier(Context context, Arguments args) throws Exception {
        return this.comp_GetUniqueIdentifier();
    }

    public boolean isFinalized() {
        return this.portalState == ControlState.FINALIZED;
    }

    public boolean isPortalActive() {
        return this.cachedDestinationUID != null;
    }

    @Callback(direct=true, doc="function():boolean -- Returns true if the portal has an active connection.")
    @Optional.Method(modid="OpenComputers")
    public Object[] isPortalActive(Context context, Arguments args) {
        return new Object[]{this.isPortalActive()};
    }

    @Override
    public void onDataPacket(NBTTagCompound tag) {
        ArrayList<ChunkCoordinates> f;
        this.portalState = ControlState.values()[tag.func_74771_c("PortalState")];
        if (tag.func_74764_b("DestUID")) {
            this.cachedDestinationUID = new GlyphIdentifier(tag.func_74779_i("DestUID"));
            this.cachedDestinationLoc = new DimensionCoordinates(tag.func_74762_e("destX"), tag.func_74762_e("destY"), tag.func_74762_e("destZ"), tag.func_74762_e("destD"));
        } else {
            this.cachedDestinationUID = null;
            this.cachedDestinationLoc = null;
        }
        this.activeTextureData.readFromNBT(tag, "Texture");
        this.instability = tag.func_74762_e("Instability");
        if (tag.func_74764_b("ModX")) {
            this.moduleManipulator = new ChunkCoordinates(tag.func_74762_e("ModX"), tag.func_74762_e("ModY"), tag.func_74762_e("ModZ"));
        }
        if ((f = EnhancedPortals.proxy.getControllerList(this.getChunkCoordinates())) != null) {
            for (ChunkCoordinates frames : f) {
                this.field_145850_b.func_147471_g(frames.field_71574_a, frames.field_71572_b, frames.field_71573_c);
            }
            EnhancedPortals.proxy.clearControllerList(this.getChunkCoordinates());
        }
    }

    public void onEntityEnterPortal(Entity entity, TilePortal tilePortal) {
        block5: {
            if (this.cachedDestinationLoc == null) {
                return;
            }
            TileEntity tile = this.cachedDestinationLoc.getTileEntity();
            this.onEntityTouchPortal(entity);
            if (tile != null && tile instanceof TileController) {
                TileController control = (TileController)tile;
                TilePortalManipulator manip = this.getModuleManipulator();
                if (manip != null && manip.onEntityTeleport(entity)) {
                    EntityManager.setEntityPortalCooldown(entity);
                }
                try {
                    EntityManager.transferEntity(entity, this, control);
                    control.onEntityTeleported(entity);
                    control.onEntityTouchPortal(entity);
                }
                catch (PortalException e) {
                    if (!(entity instanceof EntityPlayer)) break block5;
                    ((EntityPlayer)entity).func_146105_b((IChatComponent)new ChatComponentText(e.getMessage()));
                }
            }
        }
    }

    public void onEntityTeleported(Entity entity) {
        TilePortalManipulator module = this.getModuleManipulator();
        if (module != null) {
            module.onEntityTeleported(entity);
        }
    }

    public void onEntityTouchPortal(Entity entity) {
        for (ChunkCoordinates c : this.getRedstoneInterfaces()) {
            ((TileRedstoneInterface)this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c)).onEntityTeleport(entity);
        }
    }

    public void onPartFrameBroken() {
        this.deconstruct();
    }

    public void portalCreate() throws PortalException {
        for (ChunkCoordinates c : this.portalBlocks) {
            if (this.field_145850_b.func_147437_c(c.field_71574_a, c.field_71572_b, c.field_71573_c)) continue;
            if (CommonProxy.CONFIG_PORTAL_DESTROYS_BLOCKS) {
                this.field_145850_b.func_147468_f(c.field_71574_a, c.field_71572_b, c.field_71573_c);
                continue;
            }
            throw new PortalException("failedToCreatePortal");
        }
        for (ChunkCoordinates c : this.portalBlocks) {
            this.field_145850_b.func_147465_d(c.field_71574_a, c.field_71572_b, c.field_71573_c, (Block)BlockPortal.instance, this.portalType, 2);
            TilePortal portal = (TilePortal)this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            portal.portalController = this.getChunkCoordinates();
        }
        for (ChunkCoordinates c : this.getRedstoneInterfaces()) {
            TileRedstoneInterface ri = (TileRedstoneInterface)this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            ri.onPortalCreated();
        }
    }

    public void portalRemove() {
        if (this.processing) {
            return;
        }
        this.processing = true;
        for (ChunkCoordinates c : this.portalBlocks) {
            this.field_145850_b.func_147468_f(c.field_71574_a, c.field_71572_b, c.field_71573_c);
        }
        for (ChunkCoordinates c : this.getRedstoneInterfaces()) {
            TileRedstoneInterface ri = (TileRedstoneInterface)this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            ri.onPortalRemoved();
        }
        this.processing = false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.portalState = ControlState.values()[tagCompound.func_74762_e("PortalState")];
        this.instability = tagCompound.func_74762_e("Instability");
        this.portalType = tagCompound.func_74762_e("PortalType");
        this.isPublic = tagCompound.func_74767_n("isPublic");
        this.portalFrames = GeneralUtils.loadChunkCoordList(tagCompound, "Frames");
        this.portalBlocks = GeneralUtils.loadChunkCoordList(tagCompound, "Portals");
        this.redstoneInterfaces = GeneralUtils.loadChunkCoordList(tagCompound, "RedstoneInterfaces");
        this.networkInterfaces = GeneralUtils.loadChunkCoordList(tagCompound, "NetworkInterface");
        this.diallingDevices = GeneralUtils.loadChunkCoordList(tagCompound, "DialDevice");
        this.transferEnergy = GeneralUtils.loadChunkCoordList(tagCompound, "TransferEnergy");
        this.transferFluids = GeneralUtils.loadChunkCoordList(tagCompound, "TransferFluid");
        this.transferItems = GeneralUtils.loadChunkCoordList(tagCompound, "TransferItems");
        this.moduleManipulator = GeneralUtils.loadChunkCoord(tagCompound, "ModuleManipulator");
        this.dimensionalBridgeStabilizer = GeneralUtils.loadWorldCoord(tagCompound, "DimensionalBridgeStabilizer");
        this.temporaryDBS = GeneralUtils.loadWorldCoord(tagCompound, "TemporaryDBS");
        this.activeTextureData.readFromNBT(tagCompound, "ActiveTextureData");
        if (tagCompound.func_74764_b("InactiveTextureData")) {
            this.inactiveTextureData = new PortalTextureManager();
            this.inactiveTextureData.readFromNBT(tagCompound, "InactiveTextureData");
        }
        if (tagCompound.func_74764_b("CachedDestinationUID")) {
            this.cachedDestinationLoc = GeneralUtils.loadWorldCoord(tagCompound, "CachedDestinationLoc");
            this.cachedDestinationUID = new GlyphIdentifier(tagCompound.func_74779_i("CachedDestinationUID"));
        }
    }

    public void removeFrame(ChunkCoordinates chunkCoordinates) {
        this.portalFrames.remove(chunkCoordinates);
    }

    public void revertTextureData() {
        if (this.inactiveTextureData == null) {
            return;
        }
        this.activeTextureData = new PortalTextureManager(this.inactiveTextureData);
        this.inactiveTextureData = null;
    }

    void sendUpdatePacket(boolean updateChunks) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (updateChunks) {
            ArrayList<ChunkCoordIntPair> chunks = new ArrayList<ChunkCoordIntPair>();
            chunks.add(new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4));
            for (ChunkCoordinates c : this.getFrames()) {
                if (chunks.contains(new ChunkCoordIntPair(c.field_71574_a >> 4, c.field_71573_c >> 4))) continue;
                EnhancedPortals.packetPipeline.sendToAllAround((PacketEP)new PacketRerender(c.field_71574_a, c.field_71572_b, c.field_71573_c), this);
                chunks.add(new ChunkCoordIntPair(c.field_71574_a >> 4, c.field_71573_c >> 4));
            }
        }
    }

    public void setCustomFrameTexture(int tex) {
        this.activeTextureData.setCustomFrameTexture(tex);
        this.sendUpdatePacket(true);
    }

    public void setCustomPortalTexture(int tex) {
        this.activeTextureData.setCustomPortalTexture(tex);
        this.sendUpdatePacket(true);
    }

    void setDBS(EntityPlayer player, ItemStack stack) throws PortalException {
        DimensionCoordinates stabilizer = ItemLocationCard.getDBSLocation(stack);
        if (stabilizer == null || !(stabilizer.getTileEntity() instanceof TileStabilizerMain)) {
            ItemLocationCard.clearDBSLocation(stack);
            throw new PortalException("voidLinkCard");
        }
        if (!stabilizer.equals(this.getDimensionalBridgeStabilizer())) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
                if (stack.field_77994_a <= 0) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                }
            }
            this.dimensionalBridgeStabilizer = stabilizer;
            this.getDimensionalBridgeStabilizer().addPortal(this);
        }
        this.func_70296_d();
    }

    @Callback(doc="function(color:number):boolean -- Sets the portal frame colour to the specified hexadecimal string.")
    @Optional.Method(modid="OpenComputers")
    public Object[] setFrameColour(Context context, Arguments args) throws Exception {
        return this.comp_SetFrameColour(ComputerUtils.argsToArray(args));
    }

    public void setFrameColour(int colour) {
        this.activeTextureData.setFrameColour(colour);
        this.func_70296_d();
        this.sendUpdatePacket(true);
    }

    public void setFrameItem(ItemStack s) {
        this.activeTextureData.setFrameItem(s);
        this.func_70296_d();
        this.sendUpdatePacket(true);
    }

    public void setIdentifierNetwork(GlyphIdentifier id) {
        if (!this.getHasIdentifierUnique()) {
            return;
        }
        if (this.isPortalActive()) {
            this.connectionTerminate();
        }
        GlyphIdentifier uID = this.getIdentifierUnique();
        if (this.getHasIdentifierNetwork()) {
            EnhancedPortals.proxy.networkManager.removePortalFromNetwork(uID, this.getIdentifierNetwork());
        }
        if (id.size() > 0) {
            EnhancedPortals.proxy.networkManager.addPortalToNetwork(uID, id);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setIdentifierUnique(GlyphIdentifier id) throws PortalException {
        if (EnhancedPortals.proxy.networkManager.getPortalLocation(id) != null) {
            if (this.getHasIdentifierUnique() && this.getIdentifierUnique().equals(id)) {
                return;
            }
            throw new PortalException("");
        }
        if (this.isPortalActive()) {
            this.connectionTerminate();
        }
        if (this.getHasIdentifierUnique()) {
            GlyphIdentifier networkIdentifier = null;
            if (this.getHasIdentifierNetwork()) {
                networkIdentifier = this.getIdentifierNetwork();
                EnhancedPortals.proxy.networkManager.removePortalFromNetwork(this.getIdentifierUnique(), networkIdentifier);
            }
            EnhancedPortals.proxy.networkManager.removePortal(this.getDimensionCoordinates());
            if (id.size() > 0) {
                EnhancedPortals.proxy.networkManager.addPortal(id, this.getDimensionCoordinates());
                if (networkIdentifier != null) {
                    EnhancedPortals.proxy.networkManager.addPortalToNetwork(id, networkIdentifier);
                }
            }
        } else if (id.size() > 0) {
            EnhancedPortals.proxy.networkManager.addPortal(id, this.getDimensionCoordinates());
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setInstability(int instabil) {
        this.instability = instabil;
        this.func_70296_d();
        this.sendUpdatePacket(true);
    }

    public void setModuleManipulator(ChunkCoordinates chunkCoordinates) {
        this.moduleManipulator = chunkCoordinates;
        this.func_70296_d();
    }

    public void setNID(GlyphIdentifier i) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (i != null && i.size() == 0) {
                i = null;
            }
            this.nID = i;
        }
    }

    @Callback(doc="function(color:number):boolean -- Sets the particle colour to the specified hexadecimal string.")
    @Optional.Method(modid="OpenComputers")
    public Object[] setParticleColour(Context context, Arguments args) throws Exception {
        return this.comp_SetParticleColour(ComputerUtils.argsToArray(args));
    }

    public void setParticleColour(int colour) {
        this.activeTextureData.setParticleColour(colour);
        this.func_70296_d();
        this.sendUpdatePacket(false);
    }

    public void setParticleType(int type) {
        this.activeTextureData.setParticleType(type);
        this.func_70296_d();
        this.sendUpdatePacket(false);
    }

    @Callback(doc="function(color:number):boolean -- Sets the portal colour to the specified hexadecimal string.")
    @Optional.Method(modid="OpenComputers")
    public Object[] setPortalColour(Context context, Arguments args) throws Exception {
        return this.comp_SetPortalColour(ComputerUtils.argsToArray(args));
    }

    public void setPortalColour(int colour) {
        this.activeTextureData.setPortalColour(colour);
        this.func_70296_d();
        this.sendUpdatePacket(true);
    }

    public void setPortalItem(ItemStack s) {
        this.activeTextureData.setPortalItem(s);
        this.func_70296_d();
        this.sendUpdatePacket(true);
    }

    public void setUID(GlyphIdentifier i) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (i != null && i.size() == 0) {
                i = null;
            }
            this.uID = i;
        }
    }

    @Callback(doc="function(uuid:string):string -- Sets the UID to the specified string. If no string is given it will reset the UID. Must be given as numbers separated by spaces.")
    @Optional.Method(modid="OpenComputers")
    public Object[] setUniqueIdentifier(Context context, Arguments args) throws Exception {
        return this.comp_SetUniqueIdentifier(ComputerUtils.argsToArray(args));
    }

    public void setupTemporaryDBS(TileStabilizerMain sA) {
        this.temporaryDBS = sA.getDimensionCoordinates();
        this.func_70296_d();
    }

    public void swapTextureData(PortalTextureManager textureManager) {
        this.inactiveTextureData = new PortalTextureManager(this.activeTextureData);
        this.activeTextureData = textureManager;
        this.func_70296_d();
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("PortalState", this.portalState.ordinal());
        tagCompound.func_74768_a("Instability", this.instability);
        tagCompound.func_74768_a("PortalType", this.portalType);
        tagCompound.func_74757_a("isPublic", this.isPublic);
        GeneralUtils.saveChunkCoordList(tagCompound, this.getFrames(), "Frames");
        GeneralUtils.saveChunkCoordList(tagCompound, this.getPortals(), "Portals");
        GeneralUtils.saveChunkCoordList(tagCompound, this.getRedstoneInterfaces(), "RedstoneInterfaces");
        GeneralUtils.saveChunkCoordList(tagCompound, this.getNetworkInterfaces(), "NetworkInterface");
        GeneralUtils.saveChunkCoordList(tagCompound, this.getDiallingDevices(), "DialDevice");
        GeneralUtils.saveChunkCoordList(tagCompound, this.getTransferEnergy(), "TransferEnergy");
        GeneralUtils.saveChunkCoordList(tagCompound, this.getTransferFluids(), "TransferFluid");
        GeneralUtils.saveChunkCoordList(tagCompound, this.getTransferItems(), "TransferItems");
        GeneralUtils.saveChunkCoord(tagCompound, this.moduleManipulator, "ModuleManipulator");
        GeneralUtils.saveWorldCoord(tagCompound, this.dimensionalBridgeStabilizer, "DimensionalBridgeStabilizer");
        GeneralUtils.saveWorldCoord(tagCompound, this.temporaryDBS, "TemporaryDBS");
        this.activeTextureData.writeToNBT(tagCompound, "ActiveTextureData");
        if (this.inactiveTextureData != null) {
            this.inactiveTextureData.writeToNBT(tagCompound, "InactiveTextureData");
        }
        if (this.cachedDestinationLoc != null) {
            GeneralUtils.saveWorldCoord(tagCompound, this.cachedDestinationLoc, "CachedDestinationLoc");
            tagCompound.func_74778_a("CachedDestinationUID", this.cachedDestinationUID.getGlyphString());
        }
    }

    static enum ControlState {
        REQUIRES_LOCATION,
        REQUIRES_WRENCH,
        FINALIZED;

    }
}

