/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.portal;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;

public class GlyphIdentifier {
    public static final String GLYPH_SEPERATOR = "-";
    ArrayList<Integer> glyphs;

    public static String getGlyphString(ArrayList<Integer> glyph) {
        String s = "";
        for (int i : glyph) {
            s = s + GLYPH_SEPERATOR + i;
        }
        return s.length() > 0 ? s.substring(GLYPH_SEPERATOR.length()) : "";
    }

    public static ArrayList<Integer> parseGlyphString(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        ArrayList<Integer> Glyphs = new ArrayList<Integer>();
        try {
            if (str.contains(GLYPH_SEPERATOR)) {
                String[] sGlyphs;
                for (String sGlyph : sGlyphs = str.split(GLYPH_SEPERATOR)) {
                    Glyphs.add(Integer.parseInt(sGlyph));
                }
            } else {
                Glyphs.add(Integer.parseInt(str));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
        return Glyphs;
    }

    public GlyphIdentifier() {
        this.glyphs = new ArrayList();
    }

    public GlyphIdentifier(ArrayList<Integer> list) {
        this.glyphs = list;
    }

    public GlyphIdentifier(DataInputStream s) throws IOException {
        this(s.readUTF());
    }

    public GlyphIdentifier(GlyphIdentifier i) {
        this.glyphs = new ArrayList(i.glyphs.size());
        for (int I : i.glyphs) {
            this.glyphs.add(I);
        }
    }

    public GlyphIdentifier(int[] Glyphs) {
        this();
        for (int glyph : Glyphs) {
            this.glyphs.add(glyph);
        }
    }

    public GlyphIdentifier(NBTTagCompound tag) {
        this(tag.func_74779_i("GlyphIdentifier"));
    }

    public GlyphIdentifier(String s) {
        this.glyphs = GlyphIdentifier.parseGlyphString(s);
        if (this.glyphs == null) {
            this.glyphs = new ArrayList();
        }
    }

    public void addGlyph(int glyph) {
        if (this.glyphs.size() < 9) {
            this.glyphs.add(glyph);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof GlyphIdentifier) {
            GlyphIdentifier id = (GlyphIdentifier)obj;
            if (this.size() == id.size()) {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i) == id.get(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int get(int id) {
        return this.glyphs.get(id);
    }

    public int getGlyph(int id) {
        return this.glyphs.get(id);
    }

    public ArrayList<Integer> getGlyphs() {
        return this.glyphs;
    }

    public String getGlyphString() {
        return GlyphIdentifier.getGlyphString(this.glyphs);
    }

    public boolean hasGlyph(int glyph) {
        for (int i : this.glyphs) {
            if (i != glyph) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.glyphs.isEmpty();
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.setGlyphs(tag.func_74779_i("GlyphIdentifier"));
    }

    public void readFromStream(DataInputStream stream) throws IOException {
        this.setGlyphs(stream.readUTF());
    }

    public void remove(int index) {
        this.glyphs.remove(index);
    }

    public void removeLast(int glyph) {
        if (this.hasGlyph(glyph)) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.get(i) != glyph) continue;
                this.remove(i);
                break;
            }
        }
    }

    public void setGlyphs(ArrayList<Integer> glyph) {
        this.glyphs = glyph;
    }

    public void setGlyphs(String str) {
        this.glyphs = GlyphIdentifier.parseGlyphString(str);
    }

    public int size() {
        return this.glyphs.size();
    }

    public String toString() {
        return String.format("GlyphIdentifier (%s)", this.getGlyphString());
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("GlyphIdentifier", this.getGlyphString());
    }

    public void writeToStream(DataOutputStream stream) throws IOException {
        stream.writeUTF(this.getGlyphString());
    }
}

