/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import enhancedportals.block.BlockDecorBorderedQuartz;
import enhancedportals.block.BlockDecorEnderInfusedMetal;
import enhancedportals.block.BlockFrame;
import enhancedportals.block.BlockPortal;
import enhancedportals.block.BlockStabilizer;
import enhancedportals.block.BlockStabilizerEmpty;
import enhancedportals.client.PortalRenderer;
import enhancedportals.item.ItemBlankPortalModule;
import enhancedportals.item.ItemBlankUpgrade;
import enhancedportals.item.ItemGlasses;
import enhancedportals.item.ItemLocationCard;
import enhancedportals.item.ItemNanobrush;
import enhancedportals.item.ItemPortalModule;
import enhancedportals.item.ItemUpgrade;
import enhancedportals.item.ItemWrench;
import enhancedportals.network.CommonProxy;
import enhancedportals.portal.GlyphIdentifier;
import enhancedportals.portal.PortalTextureManager;
import enhancedportals.utility.Localization;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.DimensionManager;

public class ClientProxy
extends CommonProxy {
    public static int renderPass = 0;
    public static GlyphIdentifier saveGlyph;
    public static PortalTextureManager saveTexture;
    public static String saveName;
    public static int editingID;
    public static String manualEntry;
    public static int manualPage;
    public static int chapterNum;
    public static int chapterPage;
    public static int chapterPageTotal;
    public static int editingDialEntry;
    public static PortalTextureManager dialEntryTexture;
    public static ArrayList<IIcon> customFrameTextures;
    public static ArrayList<IIcon> customPortalTextures;
    public static ArrayList<ParticleSet> particleSets;
    public static Random random;
    static HashMap<String, ItemStack[]> craftingRecipes;
    public static HashMap<ChunkCoordinates, ArrayList<ChunkCoordinates>> waitingForController;

    @Override
    public void waitForController(ChunkCoordinates controller, ChunkCoordinates frame) {
        if (waitingForController.containsKey(controller)) {
            waitingForController.get(controller).add(frame);
        } else {
            waitingForController.put(controller, new ArrayList());
            waitingForController.get(controller).add(frame);
        }
    }

    @Override
    public ArrayList<ChunkCoordinates> getControllerList(ChunkCoordinates controller) {
        return waitingForController.get(controller);
    }

    @Override
    public void clearControllerList(ChunkCoordinates controller) {
        waitingForController.remove(controller);
    }

    public static ItemStack[] getCraftingRecipeForManualEntry() {
        return craftingRecipes.get(manualEntry);
    }

    public static boolean manualChapterExists(int chapter_num) {
        return ClientProxy.locExists("manual.chapter." + chapter_num + ".title");
    }

    public static boolean manualChapterPageExists(int chapter_num, int chapter_page) {
        return ClientProxy.locExists("manual.chapter." + chapter_num + ".page." + chapter_page);
    }

    public static boolean locExists(String loc_string) {
        return !Localization.get(loc_string).equals("enhancedportals." + loc_string);
    }

    public static int manualChapterLastPage(int chapter_num) {
        int max_pages;
        for (int i = max_pages = 10; i > 0; --i) {
            if (!ClientProxy.locExists("manual.chapter." + chapter_num + ".page." + i)) continue;
            return i;
        }
        return -1;
    }

    public static void manualChangeEntry(String entry) {
        manualEntry = entry;
        manualPage = 0;
    }

    public static boolean manualEntryHasPage(int page) {
        return !Localization.get("manual." + manualEntry + ".page." + page).contains(".page.");
    }

    public static boolean resourceExists(String file) {
        IReloadableResourceManager resourceManager = (IReloadableResourceManager)FMLClientHandler.instance().getClient().func_110442_L();
        try {
            resourceManager.func_110536_a(new ResourceLocation("enhancedportals", file));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean setManualPageFromBlock(Block b, int meta) {
        if (b == BlockFrame.instance) {
            ClientProxy.manualChangeEntry("frame" + meta);
            return true;
        }
        if (b == BlockPortal.instance) {
            ClientProxy.manualChangeEntry("portal");
            return true;
        }
        if (b == BlockDecorEnderInfusedMetal.instance) {
            ClientProxy.manualChangeEntry("decorStabilizer");
            return true;
        }
        if (b == BlockStabilizer.instance) {
            ClientProxy.manualChangeEntry("dbs");
            return true;
        }
        if (b == BlockStabilizerEmpty.instance) {
            ClientProxy.manualChangeEntry("dbsEmpty");
            return true;
        }
        if (b == BlockDecorBorderedQuartz.instance) {
            ClientProxy.manualChangeEntry("decorBorderedQuartz");
            return true;
        }
        return false;
    }

    public static boolean setManualPageFromItem(ItemStack s) {
        Item i = s.func_77973_b();
        if (i instanceof ItemBlock) {
            return ClientProxy.setManualPageFromBlock(Block.func_149634_a((Item)i), s.func_77960_j());
        }
        if (i == ItemBlankPortalModule.instance) {
            ClientProxy.manualChangeEntry("blank_module");
            return true;
        }
        if (i == ItemBlankUpgrade.instance) {
            ClientProxy.manualChangeEntry("blank_upgrade");
            return true;
        }
        if (i == ItemGlasses.instance) {
            ClientProxy.manualChangeEntry("glasses");
            return true;
        }
        if (i == ItemLocationCard.instance) {
            ClientProxy.manualChangeEntry("location_card");
            return true;
        }
        if (i == ItemNanobrush.instance) {
            ClientProxy.manualChangeEntry("nanobrush");
            return true;
        }
        if (i == ItemWrench.instance) {
            ClientProxy.manualChangeEntry("wrench");
            return true;
        }
        if (i == ItemPortalModule.instance) {
            ClientProxy.manualChangeEntry("module" + s.func_77960_j());
            return true;
        }
        if (i == ItemUpgrade.instance) {
            ClientProxy.manualChangeEntry("upgrade" + s.func_77960_j());
            return true;
        }
        return false;
    }

    @Override
    public File getWorldDir() {
        return new File(this.getBaseDir(), "saves/" + DimensionManager.getWorld((int)0).func_72860_G().func_75760_g());
    }

    @Override
    public void miscSetup() {
        super.miscSetup();
        particleSets.add(new ParticleSet(0, new int[]{0, 1, 2, 3, 4, 5, 6, 7}));
        particleSets.add(new ParticleSet(0, new int[]{16, 17}));
        particleSets.add(new ParticleSet(0, new int[]{19, 20, 21, 22}));
        particleSets.add(new ParticleSet(0, new int[]{48, 49}));
        particleSets.add(new ParticleSet(0, new int[]{96, 97}));
        particleSets.add(new ParticleSet(0, new int[]{112, 113, 114}));
        particleSets.add(new ParticleSet(0, new int[]{128, 129, 130, 131, 132, 133, 134, 135}));
        particleSets.add(new ParticleSet(0, new int[]{144, 145, 146, 147, 148, 149, 150, 151}));
        particleSets.add(new ParticleSet(0, new int[]{160, 161, 162, 163, 164, 165, 166, 167}));
        particleSets.add(new ParticleSet(0, new int[]{225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250}));
        particleSets.add(new ParticleSet(1, new int[]{7, 6, 5, 4, 3, 2, 1}));
        particleSets.add(new ParticleSet(1, new int[]{135, 134, 133, 132, 131, 130, 129, 128}));
        particleSets.add(new ParticleSet(1, new int[]{225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250}));
        particleSets.add(new ParticleSet(2, new int[]{32}));
        particleSets.add(new ParticleSet(2, new int[]{33}));
        particleSets.add(new ParticleSet(2, new int[]{64}));
        particleSets.add(new ParticleSet(2, new int[]{65}));
        particleSets.add(new ParticleSet(2, new int[]{66}));
        particleSets.add(new ParticleSet(2, new int[]{80}));
        particleSets.add(new ParticleSet(2, new int[]{81}));
        particleSets.add(new ParticleSet(2, new int[]{82}));
        particleSets.add(new ParticleSet(2, new int[]{83}));
        PortalRenderer.ID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)PortalRenderer.ID, (ISimpleBlockRenderingHandler)new PortalRenderer());
    }

    @Override
    public void registerItems() {
        this.gogglesRenderIndex = RenderingRegistry.addNewArmourRendererPrefix((String)"epGoggles");
        super.registerItems();
    }

    @Override
    public void setupCrafting() {
        super.setupCrafting();
        craftingRecipes.put("frame0", new ItemStack[]{new ItemStack(Blocks.field_150348_b), new ItemStack(Items.field_151042_j), new ItemStack(Blocks.field_150348_b), new ItemStack(Items.field_151042_j), new ItemStack(Blocks.field_150371_ca), new ItemStack(Items.field_151042_j), new ItemStack(Blocks.field_150348_b), new ItemStack(Items.field_151042_j), new ItemStack(Blocks.field_150348_b), new ItemStack((Block)BlockFrame.instance, 4, 0)});
        craftingRecipes.put("frame" + BlockFrame.PORTAL_CONTROLLER, new ItemStack[]{new ItemStack((Block)BlockFrame.instance), new ItemStack(Items.field_151045_i), null, null, null, null, null, null, null, new ItemStack((Block)BlockFrame.instance, 1, BlockFrame.PORTAL_CONTROLLER)});
        craftingRecipes.put("frame" + BlockFrame.REDSTONE_INTERFACE, new ItemStack[]{null, new ItemStack(Items.field_151137_ax), null, new ItemStack(Items.field_151137_ax), new ItemStack((Block)BlockFrame.instance, 1, 0), new ItemStack(Items.field_151137_ax), null, new ItemStack(Items.field_151137_ax), null, new ItemStack((Block)BlockFrame.instance, 1, BlockFrame.REDSTONE_INTERFACE)});
        craftingRecipes.put("frame" + BlockFrame.NETWORK_INTERFACE, new ItemStack[]{new ItemStack((Block)BlockFrame.instance, 1, 0), new ItemStack(Items.field_151079_bi), null, null, null, null, null, null, null, new ItemStack((Block)BlockFrame.instance, 1, BlockFrame.NETWORK_INTERFACE)});
        craftingRecipes.put("frame" + BlockFrame.DIALLING_DEVICE, new ItemStack[]{new ItemStack((Block)BlockFrame.instance, 1, BlockFrame.NETWORK_INTERFACE), new ItemStack(Items.field_151045_i), null, null, null, null, null, null, null, new ItemStack((Block)BlockFrame.instance, 1, BlockFrame.DIALLING_DEVICE)});
        craftingRecipes.put("frame" + BlockFrame.MODULE_MANIPULATOR, new ItemStack[]{new ItemStack((Block)BlockFrame.instance, 1, 0), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151166_bC), new ItemStack((Item)ItemBlankPortalModule.instance), null, null, null, null, null, new ItemStack((Block)BlockFrame.instance, 1, BlockFrame.MODULE_MANIPULATOR)});
        craftingRecipes.put("frame" + BlockFrame.TRANSFER_ENERGY, new ItemStack[]{new ItemStack((Block)BlockFrame.instance, 1, 0), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151045_i), new ItemStack(Blocks.field_150451_bX), null, null, null, null, null, new ItemStack((Block)BlockFrame.instance, 1, BlockFrame.TRANSFER_ENERGY)});
        craftingRecipes.put("frame" + BlockFrame.TRANSFER_FLUID, new ItemStack[]{new ItemStack((Block)BlockFrame.instance, 1, 0), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151133_ar), null, null, null, null, null, new ItemStack((Block)BlockFrame.instance, 1, BlockFrame.TRANSFER_FLUID)});
        craftingRecipes.put("frame" + BlockFrame.TRANSFER_ITEM, new ItemStack[]{new ItemStack((Block)BlockFrame.instance, 1, 0), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151045_i), new ItemStack((Block)Blocks.field_150486_ae), null, null, null, null, null, new ItemStack((Block)BlockFrame.instance, 1, BlockFrame.TRANSFER_ITEM)});
        craftingRecipes.put("decorStabilizer", new ItemStack[]{new ItemStack(Blocks.field_150339_S), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151079_bi), null, null, null, null, new ItemStack((Block)BlockDecorEnderInfusedMetal.instance, 9)});
        craftingRecipes.put("dbs", new ItemStack[]{new ItemStack(Blocks.field_150339_S), new ItemStack(Items.field_151079_bi), new ItemStack(Blocks.field_150339_S), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151079_bi), new ItemStack(Blocks.field_150339_S), new ItemStack(Items.field_151079_bi), new ItemStack(Blocks.field_150339_S), new ItemStack((Block)BlockStabilizer.instance, 6)});
        craftingRecipes.put("dbsEmpty", new ItemStack[0]);
        craftingRecipes.put("decorBorderedQuartz", new ItemStack[]{new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150371_ca), new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150371_ca), new ItemStack(Blocks.field_150371_ca), new ItemStack(Blocks.field_150371_ca), new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150371_ca), new ItemStack(Blocks.field_150348_b), new ItemStack((Block)BlockDecorBorderedQuartz.instance, 9)});
        craftingRecipes.put("blank_module", new ItemStack[]{new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151074_bl), new ItemStack((Item)ItemBlankPortalModule.instance)});
        craftingRecipes.put("blank_upgrade", new ItemStack[]{new ItemStack(Items.field_151045_i), null, null, new ItemStack(Items.field_151121_aF), null, null, new ItemStack(Items.field_151100_aR, 1, 1), null, null, new ItemStack((Item)ItemBlankUpgrade.instance)});
        craftingRecipes.put("glasses", new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 1), null, new ItemStack(Items.field_151100_aR, 1, 6), new ItemStack(Blocks.field_150410_aZ), new ItemStack(Items.field_151116_aA), new ItemStack(Blocks.field_150410_aZ), new ItemStack(Items.field_151116_aA), null, new ItemStack(Items.field_151116_aA), new ItemStack((Item)ItemGlasses.instance)});
        craftingRecipes.put("location_card", new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151100_aR, 1, 4), new ItemStack(Items.field_151042_j), new ItemStack((Item)ItemLocationCard.instance, 16)});
        craftingRecipes.put("wrench", new ItemStack[]{new ItemStack(Items.field_151042_j), null, new ItemStack(Items.field_151042_j), null, new ItemStack(Items.field_151128_bU), null, null, new ItemStack(Items.field_151042_j), null, new ItemStack((Item)ItemWrench.instance)});
        craftingRecipes.put("nanobrush", new ItemStack[]{new ItemStack(Blocks.field_150325_L), new ItemStack(Items.field_151007_F), null, new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151055_y), null, null, null, new ItemStack(Items.field_151055_y), new ItemStack((Item)ItemNanobrush.instance)});
        craftingRecipes.put("module0", new ItemStack[]{new ItemStack(Items.field_151137_ax), new ItemStack((Item)ItemBlankPortalModule.instance), new ItemStack(Items.field_151016_H), null, null, null, null, null, null, new ItemStack((Item)ItemPortalModule.instance, 1, 0)});
        craftingRecipes.put("module1", new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 1), new ItemStack(Items.field_151100_aR, 1, 2), new ItemStack(Items.field_151100_aR, 1, 4), null, new ItemStack((Item)ItemBlankPortalModule.instance), null, null, null, null, new ItemStack((Item)ItemPortalModule.instance, 1, 1)});
        craftingRecipes.put("module2", new ItemStack[]{new ItemStack(Items.field_151137_ax), new ItemStack((Item)ItemBlankPortalModule.instance), new ItemStack(Blocks.field_150323_B), null, null, null, null, null, null, new ItemStack((Item)ItemPortalModule.instance, 1, 2)});
        craftingRecipes.put("module3", new ItemStack[]{new ItemStack(Blocks.field_150467_bQ), new ItemStack((Item)ItemBlankPortalModule.instance), new ItemStack(Items.field_151008_G), null, null, null, null, null, null, new ItemStack((Item)ItemPortalModule.instance, 1, 3)});
        craftingRecipes.put("module5", new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack((Item)ItemBlankPortalModule.instance), new ItemStack(Items.field_151100_aR, 1, 0), null, null, null, null, null, null, new ItemStack((Item)ItemPortalModule.instance, 1, 5)});
        craftingRecipes.put("module6", new ItemStack[]{new ItemStack(Items.field_151111_aL), new ItemStack((Item)ItemBlankPortalModule.instance), null, null, null, null, null, null, null, new ItemStack((Item)ItemPortalModule.instance, 1, 6)});
        craftingRecipes.put("module7", new ItemStack[]{new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151008_G), new ItemStack((Item)ItemBlankPortalModule.instance), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151008_G), new ItemStack((Item)ItemPortalModule.instance, 1, 7)});
        craftingRecipes.put("upgrade0", new ItemStack[]{null, new ItemStack(Items.field_151137_ax), null, new ItemStack(Items.field_151137_ax), new ItemStack((Item)ItemBlankUpgrade.instance), new ItemStack(Items.field_151137_ax), null, new ItemStack(Items.field_151137_ax), null, new ItemStack((Item)ItemUpgrade.instance, 1, 0)});
        craftingRecipes.put("upgrade1", new ItemStack[]{new ItemStack((Item)ItemBlankUpgrade.instance), new ItemStack(Items.field_151079_bi), null, null, null, null, null, null, null, new ItemStack((Item)ItemUpgrade.instance, 1, 1)});
        craftingRecipes.put("upgrade2", new ItemStack[]{new ItemStack((Item)ItemUpgrade.instance, 1, 1), new ItemStack(Items.field_151045_i), null, null, null, null, null, null, null, new ItemStack((Item)ItemUpgrade.instance, 1, 2)});
        craftingRecipes.put("upgrade3", new ItemStack[0]);
        craftingRecipes.put("upgrade4", new ItemStack[]{new ItemStack((Item)ItemBlankUpgrade.instance), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151166_bC), new ItemStack((Item)ItemBlankPortalModule.instance), null, null, null, null, null, new ItemStack((Item)ItemUpgrade.instance, 1, 4)});
        craftingRecipes.put("upgrade5", new ItemStack[]{new ItemStack((Item)ItemBlankUpgrade.instance), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151133_ar), null, null, null, null, null, new ItemStack((Item)ItemUpgrade.instance, 1, 5)});
        craftingRecipes.put("upgrade6", new ItemStack[]{new ItemStack((Item)ItemBlankUpgrade.instance), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151045_i), new ItemStack((Block)Blocks.field_150486_ae), null, null, null, null, null, new ItemStack((Item)ItemUpgrade.instance, 1, 6)});
        craftingRecipes.put("upgrade7", new ItemStack[]{new ItemStack((Item)ItemBlankUpgrade.instance), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151045_i), new ItemStack(Blocks.field_150451_bX), null, null, null, null, null, new ItemStack((Item)ItemUpgrade.instance, 1, 7)});
    }

    static {
        editingID = -1;
        manualEntry = "subject";
        manualPage = 0;
        chapterNum = 0;
        chapterPage = 0;
        chapterPageTotal = 0;
        editingDialEntry = -1;
        dialEntryTexture = new PortalTextureManager();
        customFrameTextures = new ArrayList();
        customPortalTextures = new ArrayList();
        particleSets = new ArrayList();
        random = new Random();
        craftingRecipes = new HashMap();
        waitingForController = new HashMap();
    }

    public class ParticleSet {
        public int[] frames;
        public int type;

        public ParticleSet(int t, int[] s) {
            this.frames = s;
            this.type = t;
        }
    }
}

