/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui.elements;

import enhancedportals.client.gui.GuiManual;
import enhancedportals.client.gui.elements.BaseElement;
import enhancedportals.network.ClientProxy;
import enhancedportals.utility.Localization;
import java.util.List;

public class ElementManualTextButton
extends BaseElement {
    String entry;
    String displayStr;
    boolean tooLong = false;
    int length = 21;

    public ElementManualTextButton(GuiManual gui, int x, int y, String mEntry) {
        super(gui, x, y, 115, 8);
        this.entry = mEntry;
        if (this.entry != null) {
            this.displayStr = Localization.get("manual." + this.entry + ".title");
            if (this.displayStr.length() > this.length) {
                this.displayStr = this.displayStr.substring(0, this.length);
                if (this.displayStr.endsWith(" ")) {
                    this.displayStr = this.displayStr.substring(0, this.displayStr.length() - 1);
                }
                this.displayStr = this.displayStr + "...";
                this.tooLong = true;
            }
        }
    }

    public void updateEntry(String s) {
        this.entry = s;
        this.tooLong = false;
        if (this.entry != null) {
            this.displayStr = Localization.get("manual." + this.entry + ".title");
            if (this.displayStr.length() > this.length) {
                this.displayStr = this.displayStr.substring(0, this.length);
                if (this.displayStr.endsWith(" ")) {
                    this.displayStr = this.displayStr.substring(0, this.displayStr.length() - 1);
                }
                this.displayStr = this.displayStr + "...";
                this.tooLong = true;
            }
        }
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.tooLong) {
            list.add(Localization.get("manual." + this.entry + ".title"));
        }
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (this.entry == null) {
            return false;
        }
        ClientProxy.manualChangeEntry(this.entry);
        ((GuiManual)this.parent).pageChanged();
        return true;
    }

    @Override
    protected void drawContent() {
        if (this.entry != null) {
            boolean isHovering = this.intersectsWith(this.parent.getMouseX(), this.parent.getMouseY());
            this.parent.getFontRenderer().func_78276_b(this.displayStr, this.posX, this.posY, isHovering ? 0xFF0000 : 0x991100);
        }
    }

    @Override
    public void update() {
    }
}

