/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui.elements;

import enhancedportals.client.gui.BaseGui;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class BaseElement {
    protected BaseGui parent;
    protected boolean visible = true;
    protected boolean disabled = false;
    protected ArrayList<String> hoverText;
    protected int posX;
    protected int posY;
    protected int sizeX;
    protected int sizeY;
    protected String id;
    protected ResourceLocation texture;

    public BaseElement(BaseGui gui, int x, int y, int w, int h) {
        this.parent = gui;
        this.posX = gui.getGuiLeft() + x;
        this.posY = gui.getGuiTop() + y;
        this.sizeX = w;
        this.sizeY = h;
    }

    public void draw() {
        this.drawBackground();
        this.drawContent();
    }

    public abstract void addTooltip(List<String> var1);

    public boolean keyPressed(int keyCode, char key) {
        return false;
    }

    public void draw(int x, int y) {
        this.posX = x;
        this.posY = y;
        this.draw();
    }

    protected abstract void drawContent();

    protected void drawBackground() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.texture != null) {
            this.parent.getMinecraft().field_71446_o.func_110577_a(this.texture);
            this.parent.func_73729_b(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
        }
    }

    public String getID() {
        return this.id;
    }

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        return false;
    }

    public boolean intersectsWith(int mouseX, int mouseY) {
        return (mouseX += this.parent.getGuiLeft()) >= this.posX && mouseX < this.posX + this.sizeX && (mouseY += this.parent.getGuiTop()) >= this.posY && mouseY < this.posY + this.sizeY;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public BaseElement setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public BaseElement setId(String id) {
        this.id = id;
        return this;
    }

    public BaseElement setPosition(int posX, int posY) {
        this.posX = this.parent.getGuiLeft() + posX;
        this.posY = this.parent.getGuiTop() + posY;
        return this;
    }

    public BaseElement setSize(int sizeX, int sizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        return this;
    }

    public BaseElement setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public abstract void update();

    void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par6), 0.0, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), 0.0, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0), 0.0, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), 0.0, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78381_a();
    }
}

