/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.client.gui;

import enhancedportals.client.gui.elements.BaseElement;
import enhancedportals.client.gui.tabs.BaseTab;
import enhancedportals.client.gui.tabs.TabTracker;
import enhancedportals.inventory.BaseContainer;
import enhancedportals.utility.Localization;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class BaseGui
extends GuiContainer {
    RenderItem itemRenderer = new RenderItem();
    protected static final ResourceLocation playerInventoryTexture = new ResourceLocation("enhancedportals", "textures/gui/player_inventory.png");
    protected static final ResourceLocation resizableInterfaceTexture = new ResourceLocation("enhancedportals", "textures/gui/resizable_interace.png");
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected ResourceLocation texture;
    protected String name;
    protected ArrayList<BaseTab> tabs = new ArrayList();
    protected ArrayList<BaseElement> elements = new ArrayList();
    public static final int defaultContainerSize = 144;
    public static final int playerInventorySize = 90;
    public static final int bufferSpace = 2;
    public static final int defaultGuiSize = 236;
    protected int containerSize = 144;
    protected int guiSize = 236;
    protected int leftNudge = 0;
    protected boolean hasSeperateInventories = true;
    protected boolean isHidingPlayerInventory = false;
    protected boolean hasSingleTexture = false;

    public BaseGui(BaseContainer container) {
        this(container, 144);
    }

    public int getSizeX() {
        return this.field_146999_f;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public int getSizeY() {
        return this.field_147000_g;
    }

    protected void func_73869_a(char par1, int par2) {
        for (BaseElement e : this.elements) {
            if (!e.keyPressed(par2, par1)) continue;
            return;
        }
        super.func_73869_a(par1, par2);
    }

    public BaseGui(BaseContainer container, int cSize) {
        super((Container)container);
        this.containerSize = cSize;
        this.field_147000_g = this.guiSize = this.containerSize + 90 + 2;
    }

    public void setHidePlayerInventory() {
        this.isHidingPlayerInventory = true;
        this.field_147000_g = this.guiSize = this.containerSize;
    }

    public void setCombinedInventory() {
        this.hasSeperateInventories = false;
        this.field_147000_g = this.guiSize = this.containerSize + 90;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        BaseTab tab;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        BaseElement element = this.getElementAtPosition(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        if (element != null && element.isVisible()) {
            element.handleMouseClicked(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
        }
        if ((tab = this.getTabAtPosition(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) != null && tab.isVisible() && !tab.handleMouseClicked(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton)) {
            for (BaseTab other : this.tabs) {
                if (other == tab || !other.open || other.side != tab.side) continue;
                other.toggleOpen();
            }
            tab.toggleOpen();
        }
    }

    public BaseTab getTabAtPosition(int mouseX, int mouseY) {
        int xShift = 0;
        int yShift = 4;
        for (BaseTab tab : this.tabs) {
            if (!tab.isVisible() || tab.side == 1) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mouseX, mouseY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        xShift = this.field_146999_f;
        yShift = 4;
        for (BaseTab tab : this.tabs) {
            if (!tab.isVisible() || tab.side == 0) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mouseX, mouseY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        return null;
    }

    public BaseElement getElementAtPosition(int mouseX, int mouseY) {
        for (BaseElement element : this.elements) {
            if (!element.isVisible() || !element.intersectsWith(mouseX, mouseY)) continue;
            return element;
        }
        return null;
    }

    public BaseElement addElement(BaseElement element) {
        this.elements.add(element);
        return element;
    }

    public BaseTab addTab(BaseTab tab) {
        this.tabs.add(tab);
        if (TabTracker.getOpenedLeftTab() != null && tab.getClass().equals(TabTracker.getOpenedLeftTab())) {
            tab.setFullyOpen();
        } else if (TabTracker.getOpenedRightTab() != null && tab.getClass().equals(TabTracker.getOpenedRightTab())) {
            tab.setFullyOpen();
        }
        return tab;
    }

    protected void drawBackgroundTexture() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.isHidingPlayerInventory && !this.hasSingleTexture) {
            this.field_146297_k.field_71446_o.func_110577_a(playerInventoryTexture);
            this.func_73729_b(this.field_147003_i + this.leftNudge, this.field_147009_r + this.containerSize + 2, 0, 0, this.field_146999_f, 90);
        }
        if (this.texture != null) {
            this.field_146297_k.field_71446_o.func_110577_a(this.texture);
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.hasSingleTexture ? this.field_147000_g : this.containerSize + (this.hasSeperateInventories ? 0 : 6));
        } else {
            this.field_146297_k.field_71446_o.func_110577_a(resizableInterfaceTexture);
            if (this.hasSeperateInventories) {
                this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f - 4, this.containerSize - 4);
                this.func_73729_b(this.field_147003_i + this.field_146999_f - 4, this.field_147009_r, 252, 0, 4, this.containerSize - 4);
                this.func_73729_b(this.field_147003_i, this.field_147009_r + this.containerSize - 4, 0, 252, this.field_146999_f - 4, 4);
                this.func_73729_b(this.field_147003_i + this.field_146999_f - 4, this.field_147009_r + this.containerSize - 4, 252, 252, 4, 4);
            } else {
                this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f - 4, this.containerSize + 4 + 2);
                this.func_73729_b(this.field_147003_i + this.field_146999_f - 4, this.field_147009_r, 252, 0, 4, this.containerSize + 4 + 2);
            }
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        this.drawBackgroundTexture();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mouseX = i - this.field_147003_i;
        this.mouseY = j - this.field_147009_r;
        for (BaseElement element : this.elements) {
            if (!element.isVisible()) continue;
            element.draw();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int yPosRight = 4;
        int yPosLeft = 4;
        for (BaseTab tab : this.tabs) {
            if (tab.isVisible()) {
                if (tab.side == 0) {
                    tab.draw(this.field_147003_i, this.field_147009_r + yPosLeft);
                    yPosLeft += tab.currentHeight;
                } else {
                    tab.draw(this.field_147003_i + this.field_146999_f, this.field_147009_r + yPosRight);
                    yPosRight += tab.currentHeight;
                }
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (BaseElement element : this.elements) {
            element.update();
        }
        for (BaseTab tab : this.tabs) {
            tab.update();
        }
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    protected void func_146979_b(int par1, int par2) {
        BaseTab tab;
        BaseElement element;
        if (this.name != null) {
            this.getFontRenderer().func_78276_b(Localization.get(this.name), (this.field_146999_f - this.field_146297_k.field_71466_p.func_78256_a(Localization.get(this.name))) / 2, 6, 0x404040);
        }
        if ((element = this.getElementAtPosition(this.mouseX, this.mouseY)) != null && !element.isDisabled()) {
            ArrayList<String> list = new ArrayList<String>();
            element.addTooltip(list);
            if (!list.isEmpty()) {
                boolean needsOffset = ((String)list.get(0)).equals("offset");
                if (needsOffset) {
                    list.remove(0);
                }
                this.drawHoveringText(list, this.mouseX + (needsOffset ? this.getGuiLeft() : 0), this.mouseY + (needsOffset ? this.getGuiTop() : 0), this.getFontRenderer());
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                return;
            }
        }
        if ((tab = this.getTabAtPosition(this.mouseX, this.mouseY)) != null) {
            ArrayList<String> list = new ArrayList<String>();
            tab.addTooltip(list);
            if (!list.isEmpty()) {
                this.drawHoveringText(list, this.mouseX, this.mouseY, this.getFontRenderer());
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                return;
            }
        }
    }

    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs.clear();
        this.elements.clear();
        this.field_146292_n.clear();
    }

    public void onElementClicked(BaseElement element) {
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public TextureManager getTextureManager() {
        return this.getMinecraft().field_71446_o;
    }

    public RenderItem getItemRenderer() {
        return this.itemRenderer;
    }

    public void drawIconNoReset(IIcon icon, int x, int y, int spriteSheet) {
        if (spriteSheet == 0) {
            this.getTextureManager().func_110577_a(TextureMap.field_110575_b);
        } else {
            this.getTextureManager().func_110577_a(TextureMap.field_110576_c);
        }
        this.func_94065_a(x, y, icon, 16, 16);
    }

    public void drawIcon(IIcon icon, int x, int y, int spriteSheet) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawIconNoReset(icon, x, y, spriteSheet);
    }

    public void drawItemStack(ItemStack stack, int x, int y) {
        if (stack != null) {
            RenderHelper.func_74520_c();
            GL11.glEnable((int)32826);
            this.getItemRenderer().func_82406_b(this.getFontRenderer(), this.getTextureManager(), stack, x, y);
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
        }
    }

    public void drawItemStackOverlay(ItemStack stack, int x, int y) {
        if (stack != null) {
            this.getItemRenderer().func_77021_b(this.getFontRenderer(), this.getTextureManager(), stack, x, y);
        }
    }

    int drawSplitString(int x, int y, int w, String s, int colour) {
        this.getFontRenderer().func_78279_b(s, x, y, w, colour);
        return this.getFontRenderer().field_78288_b * this.getFontRenderer().func_78271_c(s, w).size();
    }
}

