/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.block;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enhancedportals.block.BlockFrame;
import enhancedportals.client.PortalParticleFX;
import enhancedportals.client.PortalRenderer;
import enhancedportals.item.ItemPortalModule;
import enhancedportals.network.ClientProxy;
import enhancedportals.network.CommonProxy;
import enhancedportals.portal.EntityManager;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TilePortal;
import enhancedportals.tile.TilePortalManipulator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPortal
extends BlockContainer {
    public static BlockPortal instance;
    IIcon texture;

    public BlockPortal(String n) {
        super(Material.field_151567_E);
        instance = this;
        this.func_149722_s();
        this.func_149752_b(2000.0f);
        this.func_149663_c(n);
        this.func_149713_g(0);
        this.func_149672_a(field_149778_k);
    }

    public void func_149749_a(World world, int x, int y, int z, Block b, int newID) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TilePortal) {
            ((TilePortal)tile).breakBlock(b, newID);
        }
        super.func_149749_a(world, x, y, z, b, newID);
    }

    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        if (tile instanceof TilePortal) {
            return ((TilePortal)tile).getColour();
        }
        return 0xFFFFFF;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TilePortal();
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        if (tile instanceof TilePortal) {
            return ((TilePortal)tile).getBlockTexture(side);
        }
        return null;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.texture;
    }

    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return null;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 14;
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149645_b() {
        return PortalRenderer.ID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TilePortal) {
            return ((TilePortal)tile).activate(player, player.field_71071_by.func_70448_g());
        }
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K) {
            if (EntityManager.isEntityFitForTravel(entity)) {
                TileEntity t;
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_71053_j();
                }
                if ((t = world.func_147438_o(x, y, z)) instanceof TilePortal) {
                    ((TilePortal)t).onEntityCollidedWithBlock(entity);
                }
            }
            EntityManager.setEntityPortalCooldown(entity);
        }
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        boolean doParticles;
        if (CommonProxy.CONFIG_DISABLE_SOUNDS && CommonProxy.CONFIG_DISABLE_PARTICLES) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TilePortal)) {
            return;
        }
        int metadata = world.func_72805_g(x, y, z);
        TileController controller = ((TilePortal)tile).getPortalController();
        TilePortalManipulator module = controller == null ? null : controller.getModuleManipulator();
        boolean doSounds = !CommonProxy.CONFIG_DISABLE_SOUNDS && random.nextInt(100) == 0;
        boolean bl = doParticles = !CommonProxy.CONFIG_DISABLE_PARTICLES;
        if (module != null) {
            if (doSounds) {
                doSounds = !module.hasModule(ItemPortalModule.PortalModules.REMOVE_SOUNDS.getUniqueID());
            }
            boolean bl2 = doParticles = !module.hasModule(ItemPortalModule.PortalModules.REMOVE_PARTICLES.getUniqueID());
        }
        if (doSounds) {
            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "portal.portal", 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        if (doParticles) {
            for (int l = 0; l < 4; ++l) {
                double d0 = (float)x + random.nextFloat();
                double d1 = (float)y + random.nextFloat();
                double d2 = (float)z + random.nextFloat();
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                int i1 = random.nextInt(2) * 2 - 1;
                d3 = ((double)random.nextFloat() - 0.5) * 0.5;
                d4 = ((double)random.nextFloat() - 0.5) * 0.5;
                d5 = ((double)random.nextFloat() - 0.5) * 0.5;
                if (metadata == 1) {
                    d2 = (double)z + 0.5 + 0.25 * (double)i1;
                    d5 = random.nextFloat() * 2.0f * (float)i1;
                } else if (metadata == 2) {
                    d0 = (double)x + 0.5 + 0.25 * (double)i1;
                    d3 = random.nextFloat() * 2.0f * (float)i1;
                } else if (metadata == 3) {
                    d1 = (double)y + 0.5 + 0.25 * (double)i1;
                    d4 = random.nextFloat() * 2.0f * (float)i1;
                } else if (metadata == 4) {
                    d3 = d5 = (double)(random.nextFloat() * 2.0f * (float)i1);
                } else if (metadata == 5) {
                    d3 = d5 = (double)(random.nextFloat() * 2.0f * (float)i1);
                    d3 = -d3;
                }
                PortalParticleFX fx = new PortalParticleFX(world, controller, d0, d1, d2, d3, d4, d5);
                if (module != null) {
                    module.particleCreated(fx);
                }
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.texture = iconRegister.func_94245_a("enhancedportals:portal");
        int counter = 0;
        ClientProxy.customPortalTextures.clear();
        while (ClientProxy.resourceExists("textures/blocks/customPortal/" + String.format("%02d", counter) + ".png")) {
            CommonProxy.logger.debug("Registered custom portal Icon: " + String.format("%02d", counter) + ".png");
            ClientProxy.customPortalTextures.add(iconRegister.func_94245_a("enhancedportals:customPortal/" + String.format("%02d", counter)));
            ++counter;
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        if (tile instanceof TilePortal) {
            TilePortalManipulator manip;
            TilePortal portal = (TilePortal)tile;
            TileController controller = portal.getPortalController();
            TilePortalManipulator tilePortalManipulator = manip = controller == null ? null : controller.getModuleManipulator();
            if (controller != null && manip != null && manip.isPortalInvisible()) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                return;
            }
            int meta = blockAccess.func_72805_g(x, y, z);
            if (meta == 1) {
                this.func_149676_a(0.0f, 0.0f, 0.375f, 1.0f, 1.0f, 0.625f);
            } else if (meta == 2) {
                this.func_149676_a(0.375f, 0.0f, 0.0f, 0.625f, 1.0f, 1.0f);
            } else if (meta == 3) {
                this.func_149676_a(0.0f, 0.375f, 0.0f, 1.0f, 0.625f, 1.0f);
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (blockAccess.func_147439_a(x, y, z) == this || blockAccess.func_147439_a(x, y, z) == BlockFrame.instance) {
            return false;
        }
        return super.func_149646_a(blockAccess, x, y, z, side);
    }
}

