/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.nei.NEIGalacticraftMarsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MethaneSynthesizerRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation synthesizerGuiTexture = new ResourceLocation("galacticraftmars", "textures/gui/methaneSynthesizer.png");
    private static final ResourceLocation synthesizerGasesTexture = new ResourceLocation("galacticraftasteroids", "textures/gui/gasesMethaneOxygenNitrogen.png");
    int ticksPassed;
    int extra = 0;
    boolean fillAtmos = false;
    protected FontRenderer fontRendererObj;

    public MethaneSynthesizerRecipeHandler() {
        this.fontRendererObj = Minecraft.func_71410_x().field_71466_p;
    }

    public String getRecipeId() {
        return "galacticraft.synthesizer";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public Set<Map.Entry<PositionedStack, PositionedStack>> getRecipes() {
        return NEIGalacticraftMarsConfig.getSynthesizerRecipes();
    }

    public void drawBackground(int i) {
        int yoffset;
        int level;
        int progress = this.ticksPassed % 144;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)synthesizerGuiTexture);
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)4, (int)168, (int)66);
        if (progress <= 40) {
            level = progress * 38 / 40;
            GuiDraw.changeTexture((ResourceLocation)synthesizerGasesTexture);
            GuiDraw.drawTexturedModalRect((int)2, (int)(62 - level), (int)35, (int)(38 - level), (int)16, (int)level);
            if (this.fillAtmos) {
                yoffset = progress / 2;
                GuiDraw.drawTexturedModalRect((int)23, (int)(44 - yoffset), (int)35, (int)(26 - yoffset), (int)16, (int)yoffset);
            }
        } else if (progress < 104) {
            level = (progress - 41) / 3;
            yoffset = 20 - level;
            GuiDraw.changeTexture((ResourceLocation)synthesizerGasesTexture);
            GuiDraw.drawTexturedModalRect((int)2, (int)(62 - yoffset), (int)35, (int)(26 - yoffset), (int)16, (int)yoffset);
            if (this.fillAtmos) {
                GuiDraw.drawTexturedModalRect((int)23, (int)(44 - yoffset), (int)35, (int)(26 - yoffset), (int)16, (int)yoffset);
            }
            GuiDraw.drawTexturedModalRect((int)148, (int)(62 - level), (int)1, (int)(26 - level), (int)16, (int)level);
            int powerlevel = 53 - (progress - 41) / 6;
            GuiDraw.changeTexture((ResourceLocation)synthesizerGuiTexture);
            GuiDraw.drawTexturedModalRect((int)61, (int)13, (int)176, (int)38, (int)powerlevel, (int)7);
            GuiDraw.drawTexturedModalRect((int)47, (int)12, (int)208, (int)0, (int)11, (int)10);
        }
        if (this.fillAtmos) {
            String gasname = GCCoreUtil.translate((String)"gas.carbondioxide.name");
            String text1 = " * " + GCCoreUtil.translate((String)"gui.message.withAtmosphere0.name");
            String text2 = " " + GCCoreUtil.lowerCaseNoun((String)gasname);
            String text3 = GCCoreUtil.translate((String)"gui.message.withAtmosphere1.name");
            this.fontRendererObj.func_78276_b(text1, 4, 85, 0x404040);
            this.fontRendererObj.func_78276_b(text2, 18, 95, 0x404040);
            this.fontRendererObj.func_78276_b(text3, 18, 105, 0x404040);
        }
    }

    public void onUpdate() {
        this.ticksPassed += 1 + this.extra;
        super.onUpdate();
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<PositionedStack, PositionedStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedSynthesizerRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<PositionedStack, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().item, (ItemStack)result)) continue;
            this.arecipes.add(new CachedSynthesizerRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<PositionedStack, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)irecipe.getKey().item)) continue;
            this.arecipes.add(new CachedSynthesizerRecipe(irecipe));
            break;
        }
    }

    public ArrayList<PositionedStack> getIngredientStacks(int recipe) {
        PositionedStack input = (PositionedStack)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients().get(0);
        Item inputItem = input.item.func_77973_b();
        this.fillAtmos = inputItem == AsteroidsItems.atmosphericValve;
        if (this.ticksPassed % 144 > 40) {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (inputItem != MarsItems.carbonFragments) {
                stacks.add(new PositionedStack((Object)new ItemStack(inputItem, 1, inputItem.func_77612_l()), input.relx, input.rely));
            } else if (this.ticksPassed % 144 < 104) {
                int number = 24 - (this.ticksPassed % 144 - 40) * 3 / 8;
                stacks.add(new PositionedStack((Object)new ItemStack(inputItem, number, 0), input.relx, input.rely));
            }
            return stacks;
        }
        return (ArrayList)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    public PositionedStack getResultStack(int recipe) {
        if (this.ticksPassed % 144 < 104) {
            PositionedStack output = ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
            Item outputItem = output.item.func_77973_b();
            return new PositionedStack((Object)new ItemStack(outputItem, 1, outputItem.func_77612_l()), output.relx, output.rely);
        }
        return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
    }

    public String getRecipeName() {
        return "Methane Synthesizer";
    }

    public String getGuiTexture() {
        return "galacticraftmars/textures/gui/methaneSynthesizer.png";
    }

    public void drawForeground(int recipe) {
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point mousePos = GuiDraw.getMousePosition();
        try {
            Class<GuiContainer> clazz = GuiContainer.class;
            mousePos.x -= ((Integer)clazz.getField("field_147003_i").get(gui)).intValue();
            mousePos.y -= ((Integer)clazz.getField("field_147009_r").get(gui)).intValue();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (mousePos.x < 23 && mousePos.x > 6 && mousePos.y < 78 && mousePos.y > 39) {
            currenttip.add(GCCoreUtil.translate((String)"fluid.hydrogen"));
        } else if (mousePos.x < 44 && mousePos.x > 27 && mousePos.y < 60 && mousePos.y > 39) {
            currenttip.add(GCCoreUtil.translate((String)"gas.carbondioxide.name"));
        }
        return currenttip;
    }

    public class CachedSynthesizerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack input;
        public PositionedStack output;

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedSynthesizerRecipe(PositionedStack pstack1, PositionedStack pstack2) {
            super((TemplateRecipeHandler)MethaneSynthesizerRecipeHandler.this);
            this.input = pstack1;
            this.output = pstack2;
        }

        public CachedSynthesizerRecipe(Map.Entry<PositionedStack, PositionedStack> recipe) {
            this(recipe.getKey(), recipe.getValue());
        }
    }
}

