/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class ConfigManagerMars {
    public static boolean loaded;
    static Configuration config;
    public static int dimensionIDMars;
    public static int idSchematicRocketT2;
    public static int idSchematicCargoRocket;
    public static boolean launchControllerChunkLoad;
    public static boolean launchControllerAllDims;
    public static boolean disableDeshGen;
    public static boolean disableTinGen;
    public static boolean disableCopperGen;
    public static boolean disableIronGen;

    public ConfigManagerMars(File file) {
        if (!loaded) {
            config = new Configuration(file);
            ConfigManagerMars.syncConfig(true);
        }
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            if (!ConfigManagerMars.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("dimensions", "dimensionIDMars", -29);
            prop.comment = "Dimension ID for Mars";
            prop.setLanguageKey("gc.configgui.dimensionIDMars").setRequiresMcRestart(true);
            dimensionIDMars = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("schematic", "idSchematicRocketT2", 2);
            prop.comment = "Schematic ID for Tier 2 Rocket, must be unique.";
            prop.setLanguageKey("gc.configgui.idSchematicRocketT2");
            idSchematicRocketT2 = prop.getInt(2);
            propOrder.add(prop.getName());
            prop = config.get("schematic", "idSchematicCargoRocket", 3);
            prop.comment = "Schematic ID for Cargo Rocket, must be unique.";
            prop.setLanguageKey("gc.configgui.idSchematicCargoRocket");
            idSchematicCargoRocket = prop.getInt(3);
            propOrder.add(prop.getName());
            prop = config.get("general", "launchControllerChunkLoad", true);
            prop.comment = "Whether or not the launch controller acts as a chunk loader. Will cause issues if disabled!";
            prop.setLanguageKey("gc.configgui.launchControllerChunkLoad");
            launchControllerChunkLoad = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "launchControllerAllDims", false);
            prop.comment = "May rarely cause issues if enabled, depends on how the other mod's dimensions are.";
            prop.setLanguageKey("gc.configgui.launchControllerAllDims");
            launchControllerAllDims = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get("general", "Disable Desh Ore Gen on Mars", false);
            prop.comment = "Disable Desh Ore Gen on Mars.";
            prop.setLanguageKey("gc.configgui.disableDeshGenMars");
            disableDeshGen = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get("general", "Disable Tin Ore Gen on Mars", false);
            prop.comment = "Disable Tin Ore Gen on Mars.";
            prop.setLanguageKey("gc.configgui.disableTinGenMars");
            disableTinGen = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get("general", "Disable Copper Ore Gen on Mars", false);
            prop.comment = "Disable Copper Ore Gen on Mars.";
            prop.setLanguageKey("gc.configgui.disableCopperGenMars");
            disableCopperGen = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get("general", "Disable Iron Ore Gen on Mars", false);
            prop.comment = "Disable Iron Ore Gen on Mars.";
            prop.setLanguageKey("gc.configgui.disableIronGenMars");
            disableIronGen = prop.getBoolean(false);
            propOrder.add(prop.getName());
            config.setCategoryPropertyOrder("general", propOrder);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Galacticraft Mars (Planets) has a problem loading it's config", (Object[])new Object[0]);
        }
    }
}

