/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class ConfigManagerAsteroids {
    public static boolean loaded;
    static Configuration config;
    public static int dimensionIDAsteroids;
    public static int idSchematicRocketT3;
    public static boolean disableGalacticraftHelium;
    public static int astroMinerMax;
    public static boolean disableIlmeniteGen;
    public static boolean disableIronGen;
    public static boolean disableAluminumGen;

    public ConfigManagerAsteroids(File file) {
        if (!loaded) {
            config = new Configuration(file);
            ConfigManagerAsteroids.syncConfig(true);
        }
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            if (!ConfigManagerAsteroids.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("dimensions", "dimensionIDAsteroids", -30);
            prop.comment = "Dimension ID for Asteroids";
            prop.setLanguageKey("gc.configgui.dimensionIDAsteroids").setRequiresMcRestart(true);
            dimensionIDAsteroids = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("schematic", "idSchematicRocketT3", 4);
            prop.comment = "Schematic ID for Tier 3 Rocket, must be unique.";
            prop.setLanguageKey("gc.configgui.idSchematicRocketT3");
            idSchematicRocketT3 = prop.getInt(4);
            propOrder.add(prop.getName());
            prop = config.get("general", "disableGalacticraftHelium", false);
            prop.comment = "Option to disable Helium gas in Galacticraft (because it will be registered by another mod eg GregTech).";
            prop.setLanguageKey("gc.configgui.disableGalacticraftHelium");
            disableGalacticraftHelium = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get("general", "maximumAstroMiners", 6);
            prop.comment = "Maximum number of Astro Miners each player is allowed to have active (default 4).";
            prop.setLanguageKey("gc.configgui.astroMinersMax");
            astroMinerMax = prop.getInt(6);
            propOrder.add(prop.getName());
            prop = config.get("general", "Disable Ilmenite Ore Gen on Asteroids", false);
            prop.comment = "Disable Ilmenite Ore Gen on Asteroids.";
            prop.setLanguageKey("gc.configgui.disableIlmeniteGenAsteroids");
            disableIlmeniteGen = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get("general", "Disable Iron Ore Gen on Asteroids", false);
            prop.comment = "Disable Iron Ore Gen on Asteroids.";
            prop.setLanguageKey("gc.configgui.disableIronGenAsteroids");
            disableIronGen = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get("general", "Disable Aluminum Ore Gen on Asteroids", false);
            prop.comment = "Disable Aluminum Ore Gen on Asteroids.";
            prop.setLanguageKey("gc.configgui.disableAluminumGenAsteroids");
            disableAluminumGen = prop.getBoolean(false);
            propOrder.add(prop.getName());
            config.setCategoryPropertyOrder("general", propOrder);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Galacticraft Asteroids (Planets) has a problem loading it's config", (Object[])new Object[0]);
        }
    }
}

