/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets;

import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.planets.IPlanetsModule;
import micdoodle8.mods.galacticraft.planets.IPlanetsModuleClient;
import micdoodle8.mods.galacticraft.planets.PlanetsProxy;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.ConfigElement;

@Mod(name="Galacticraft Planets", version="3.0.12", useMetadata=true, modid="GalacticraftMars", dependencies="required-after:GalacticraftCore;", guiFactory="micdoodle8.mods.galacticraft.planets.ConfigGuiFactoryPlanets")
public class GalacticraftPlanets {
    public static final String NAME = "Galacticraft Planets";
    @Mod.Instance(value="GalacticraftMars")
    public static GalacticraftPlanets instance;
    public static Map<String, IPlanetsModule> commonModules;
    public static Map<String, IPlanetsModuleClient> clientModules;
    public static final String MODULE_KEY_MARS = "MarsModule";
    public static final String MODULE_KEY_ASTEROIDS = "AsteroidsModule";
    @SidedProxy(clientSide="micdoodle8.mods.galacticraft.planets.PlanetsProxyClient", serverSide="micdoodle8.mods.galacticraft.planets.PlanetsProxy")
    public static PlanetsProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        commonModules.put(MODULE_KEY_MARS, new MarsModule());
        commonModules.put(MODULE_KEY_ASTEROIDS, new AsteroidsModule());
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        proxy.serverStarting(event);
    }

    public static int getBlockRenderID(Block block) {
        for (IPlanetsModuleClient module : clientModules.values()) {
            int id = module.getBlockRenderID(block);
            if (id <= 1) continue;
            return id;
        }
        return 1;
    }

    public static void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object ... extraData) {
        for (IPlanetsModuleClient module : clientModules.values()) {
            module.spawnParticle(particleID, position, motion, extraData);
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        for (IPlanetsModule module : commonModules.values()) {
            list.addAll(new ConfigElement(module.getConfiguration().getCategory("dimensions")).getChildElements());
        }
        for (IPlanetsModule module : commonModules.values()) {
            list.addAll(new ConfigElement(module.getConfiguration().getCategory("entities")).getChildElements());
        }
        for (IPlanetsModule module : commonModules.values()) {
            list.addAll(new ConfigElement(module.getConfiguration().getCategory("achievements")).getChildElements());
        }
        for (IPlanetsModule module : commonModules.values()) {
            list.addAll(new ConfigElement(module.getConfiguration().getCategory("entities")).getChildElements());
        }
        for (IPlanetsModule module : commonModules.values()) {
            list.addAll(new ConfigElement(module.getConfiguration().getCategory("general")).getChildElements());
        }
        return list;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.modID.equals("GalacticraftMars")) {
            for (IPlanetsModule module : commonModules.values()) {
                module.syncConfig();
            }
        }
    }

    static {
        commonModules = new HashMap<String, IPlanetsModule>();
        clientModules = new HashMap<String, IPlanetsModuleClient>();
    }
}

