/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IKineticSource;
import ic2.api.item.ILatheItem;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumableClass;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.machine.container.ContainerLathe;
import ic2.core.block.machine.gui.GuiLathe;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLathe
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener {
    public InvSlotConsumableClass toolSlot = new InvSlotConsumableClass((TileEntityInventory)this, "slotTool", 0, 1, ILatheItem.ILatheTool.class);
    public InvSlotConsumableClass latheSlot = new InvSlotConsumableClass((TileEntityInventory)this, "lathe", 1, 1, ILatheItem.class);
    public InvSlotOutput outputSlot = new InvSlotOutput(this, "dusts", 2, 1);
    public int kUBuffer = 0;
    public static final int maxKUBuffer = 10000;

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        this.setActive(this.kUBuffer > 500);
        this.kUBuffer = (int)((float)this.kUBuffer - ((float)(this.kUBuffer / 100) + 0.5f));
        this.getKU();
    }

    private void getKU() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int kineticbandwith;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (!(te instanceof IKineticSource) || (kineticbandwith = ((IKineticSource)te).maxrequestkineticenergyTick(dir.getOpposite())) == 0) continue;
            int diff = Math.min(kineticbandwith, 10000 - this.kUBuffer);
            this.kUBuffer += ((IKineticSource)te).requestkineticenergy(dir.getOpposite(), diff);
            break;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("kUBuffer", this.kUBuffer);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.kUBuffer = nbttagcompound.func_74762_e("kUBuffer");
    }

    public ContainerBase<TileEntityLathe> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerLathe(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiLathe((ContainerLathe)this.getGuiContainer(entityPlayer));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public String func_145825_b() {
        return "Lathe";
    }

    public boolean process(int position) {
        if (this.toolSlot.get() == null || !(this.toolSlot.get().func_77973_b() instanceof ILatheItem.ILatheTool)) {
            return false;
        }
        if (this.latheSlot.get() == null || !(this.latheSlot.get().func_77973_b() instanceof ILatheItem)) {
            return false;
        }
        if (this.kUBuffer < 1000) {
            return false;
        }
        ILatheItem l = (ILatheItem)this.latheSlot.get().func_77973_b();
        ILatheItem.ILatheTool t = (ILatheItem.ILatheTool)this.toolSlot.get().func_77973_b();
        if (t.getHardness(this.toolSlot.get()) <= l.getHardness(this.latheSlot.get())) {
            return false;
        }
        if (!this.outputSlot.canAdd(l.getOutputItem(this.latheSlot.get(), position))) {
            return false;
        }
        int[] currentState = l.getCurrentState(this.latheSlot.get());
        if (currentState[position] <= 1) {
            return false;
        }
        l.setState(this.latheSlot.get(), position, currentState[position] - 1);
        if (this.field_145850_b.field_73012_v.nextFloat() < l.getOutputChance(this.latheSlot.get(), position)) {
            this.outputSlot.add(l.getOutputItem(this.latheSlot.get(), position));
        }
        t.setCustomDamage(this.toolSlot.get(), t.getCustomDamage(this.toolSlot.get()) + 1);
        if (t.getCustomDamage(this.toolSlot.get()) >= t.getMaxCustomDamage(this.toolSlot.get())) {
            this.toolSlot.put(null);
        }
        this.kUBuffer -= 1000;
        return true;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        this.process(event);
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side != this.getFacing();
    }
}

