/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.FileHandler;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.model.MapState;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageSet;
import journeymap.common.Journeymap;
import journeymap.common.thread.JMThreadFactory;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class RegionImageCache {
    public static final long flushInterval = TimeUnit.SECONDS.toMillis(30L);
    public static final long regionCacheAge = flushInterval / 2L;
    static final Logger logger = Journeymap.getLogger();
    final LoadingCache<RegionImageSet.Key, RegionImageSet> regionImageSetsCache;
    private volatile long lastFlush;
    private Minecraft minecraft = ForgeHelper.INSTANCE.getClient();

    private RegionImageCache() {
        this.regionImageSetsCache = DataCache.instance().getRegionImageSets();
        this.lastFlush = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        Runtime.getRuntime().addShutdownHook(new JMThreadFactory("rcache").newThread(new Runnable(){

            @Override
            public void run() {
                RegionImageCache.this.flushToDisk(false);
                if (logger.isEnabled(Level.DEBUG)) {
                    logger.debug("RegionImageCache flushing to disk on shutdown");
                }
            }
        }));
    }

    public static RegionImageCache instance() {
        return Holder.INSTANCE;
    }

    public static LoadingCache<RegionImageSet.Key, RegionImageSet> initRegionImageSetsCache(CacheBuilder<Object, Object> builder) {
        return builder.expireAfterAccess(regionCacheAge, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<RegionImageSet.Key, RegionImageSet>(){

            @ParametersAreNonnullByDefault
            public void onRemoval(RemovalNotification<RegionImageSet.Key, RegionImageSet> notification) {
                RegionImageSet regionImageSet = (RegionImageSet)notification.getValue();
                if (regionImageSet != null) {
                    int count = regionImageSet.writeToDisk(false, false);
                    if (count > 0 && Journeymap.getLogger().isDebugEnabled()) {
                        Journeymap.getLogger().debug("Wrote to disk before removal from cache: " + regionImageSet);
                    }
                    regionImageSet.clear();
                }
            }
        }).build((CacheLoader)new CacheLoader<RegionImageSet.Key, RegionImageSet>(){

            @ParametersAreNonnullByDefault
            public RegionImageSet load(RegionImageSet.Key key) throws Exception {
                return new RegionImageSet(key);
            }
        });
    }

    public RegionImageSet getRegionImageSet(RegionCoord rCoord) {
        return (RegionImageSet)this.regionImageSetsCache.getUnchecked((Object)RegionImageSet.Key.from(rCoord));
    }

    public RegionImageSet getRegionImageSet(RegionImageSet.Key rCoordKey) {
        return (RegionImageSet)this.regionImageSetsCache.getUnchecked((Object)rCoordKey);
    }

    private Collection<RegionImageSet> getRegionImageSets() {
        return this.regionImageSetsCache.asMap().values();
    }

    public void updateTextures(boolean forceFlush, boolean async) {
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            if (!regionImageSet.hasChunkUpdates()) continue;
            regionImageSet.finishChunkUpdates();
        }
        if (forceFlush) {
            this.flushToDisk(async);
        } else {
            this.autoFlush(async);
        }
    }

    private void autoFlush(boolean async) {
        if (this.lastFlush + flushInterval < System.currentTimeMillis()) {
            if (logger.isEnabled(Level.DEBUG)) {
                logger.debug("RegionImageCache auto-flushing");
            }
            this.flushToDisk(async);
        }
    }

    public void flushToDisk(boolean async) {
        int count = 0;
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            count += regionImageSet.writeToDisk(false, async);
        }
        this.lastFlush = System.currentTimeMillis();
    }

    public long getLastFlush() {
        return this.lastFlush;
    }

    public List<RegionCoord> getChangedSince(MapType mapType, long time) {
        ArrayList<RegionCoord> list = new ArrayList<RegionCoord>();
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            if (!regionImageSet.updatedSince(mapType, time)) continue;
            list.add(regionImageSet.getRegionCoord());
        }
        if (logger.isEnabled(Level.DEBUG)) {
            logger.debug("Dirty regions: " + list.size() + " of " + this.regionImageSetsCache.size());
        }
        return list;
    }

    public boolean isDirtySince(RegionCoord rc, MapType mapType, long time) {
        RegionImageSet ris = this.getRegionImageSet(rc);
        if (ris == null) {
            return false;
        }
        return ris.updatedSince(mapType, time);
    }

    public void clear() {
        for (RegionImageSet regionImageSet : this.getRegionImageSets()) {
            regionImageSet.clear();
        }
        this.regionImageSetsCache.invalidateAll();
        this.regionImageSetsCache.cleanUp();
    }

    public boolean deleteMap(MapState state, boolean allDims) {
        RegionCoord fakeRc = new RegionCoord(state.getWorldDir(), 0, 0, state.getDimension());
        File imageDir = RegionImageHandler.getImageDir(fakeRc, MapType.day(state.getDimension())).getParentFile();
        if (!imageDir.getName().startsWith("DIM")) {
            logger.error("Expected DIM directory, got " + imageDir);
            return false;
        }
        File[] dirs = allDims ? imageDir.getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.isDirectory() && name.startsWith("DIM");
            }
        }) : new File[]{imageDir};
        if (dirs != null && dirs.length > 0) {
            this.clear();
            boolean result = true;
            for (File dir : dirs) {
                if (!dir.exists()) continue;
                FileHandler.delete(dir);
                logger.info(String.format("Deleted image directory %s: %s", dir, !dir.exists()));
                if (!dir.exists()) continue;
                result = false;
            }
            logger.info("Done deleting directories");
            return result;
        }
        logger.info("Found no DIM directories in " + imageDir);
        return true;
    }

    private static class Holder {
        private static final RegionImageCache INSTANCE = new RegionImageCache();

        private Holder() {
        }
    }
}

