/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLine;
import ar.com.hjg.pngj.ImageLines;
import ar.com.hjg.pngj.PngDeinterlacer;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngIDatChunkInputStream;
import ar.com.hjg.pngj.PngjExceptionInternal;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkLoadBehaviour;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.ChunksList;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkIDAT;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import ar.com.hjg.pngj.chunks.PngChunkSkipped;
import ar.com.hjg.pngj.chunks.PngMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.CRC32;
import java.util.zip.InflaterInputStream;

public class PngReader {
    public final ImageInfo imgInfo;
    protected final String filename;
    protected final PngMetadata metadata;
    protected final ChunksList chunksList;
    protected final InputStream inputStream;
    private final boolean interlaced;
    private final PngDeinterlacer deinterlacer;
    protected ImageLine imgLine;
    protected byte[] rowb = null;
    protected byte[] rowbprev = null;
    protected byte[] rowbfilter = null;
    protected int currentChunkGroup = -1;
    protected int rowNum = -1;
    protected InflaterInputStream idatIstream;
    protected PngIDatChunkInputStream iIdatCstream;
    protected CRC32 crctest;
    private ChunkLoadBehaviour chunkLoadBehaviour = ChunkLoadBehaviour.LOAD_CHUNK_ALWAYS;
    private boolean shouldCloseStream = true;
    private long maxTotalBytesRead = 0xC800000L;
    private int maxBytesMetadata = 0x500000;
    private int skipChunkMaxSize = 0x200000;
    private String[] skipChunkIds = new String[]{"fdAT"};
    private HashSet<String> skipChunkIdsSet;
    private boolean crcEnabled = true;
    private boolean unpackedMode = false;
    private long offset = 0L;
    private int bytesChunksLoaded;

    public PngReader(InputStream inputStream, String filenameOrDescription) {
        this.filename = filenameOrDescription == null ? "" : filenameOrDescription;
        this.inputStream = inputStream;
        this.chunksList = new ChunksList(null);
        this.metadata = new PngMetadata(this.chunksList);
        byte[] pngid = new byte[8];
        PngHelperInternal.readBytes(inputStream, pngid, 0, pngid.length);
        this.offset += (long)pngid.length;
        if (!Arrays.equals(pngid, PngHelperInternal.getPngIdSignature())) {
            throw new PngjInputException("Bad PNG signature");
        }
        this.currentChunkGroup = 0;
        int clen = PngHelperInternal.readInt4(inputStream);
        this.offset += 4L;
        if (clen != 13) {
            throw new PngjInputException("IDHR chunk len != 13 ?? " + clen);
        }
        byte[] chunkid = new byte[4];
        PngHelperInternal.readBytes(inputStream, chunkid, 0, 4);
        if (!Arrays.equals(chunkid, ChunkHelper.b_IHDR)) {
            throw new PngjInputException("IHDR not found as first chunk??? [" + ChunkHelper.toString(chunkid) + "]");
        }
        this.offset += 4L;
        PngChunkIHDR ihdr = (PngChunkIHDR)this.readChunk(chunkid, clen, false);
        boolean alpha = (ihdr.getColormodel() & 4) != 0;
        boolean palette = (ihdr.getColormodel() & 1) != 0;
        boolean grayscale = ihdr.getColormodel() == 0 || ihdr.getColormodel() == 4;
        this.imgInfo = new ImageInfo(ihdr.getCols(), ihdr.getRows(), ihdr.getBitspc(), alpha, grayscale, palette);
        this.rowbfilter = new byte[this.imgInfo.bytesPerRow + 1];
        this.rowb = new byte[this.imgInfo.bytesPerRow + 1];
        this.rowbprev = new byte[this.rowb.length];
        this.interlaced = ihdr.getInterlaced() == 1;
        PngDeinterlacer pngDeinterlacer = this.deinterlacer = this.interlaced ? new PngDeinterlacer(this.imgInfo) : null;
        if (ihdr.getFilmeth() != 0 || ihdr.getCompmeth() != 0 || (ihdr.getInterlaced() & 0xFFFE) != 0) {
            throw new PngjInputException("compression method o filter method or interlaced unrecognized ");
        }
        if (ihdr.getColormodel() < 0 || ihdr.getColormodel() > 6 || ihdr.getColormodel() == 1 || ihdr.getColormodel() == 5) {
            throw new PngjInputException("Invalid colormodel " + ihdr.getColormodel());
        }
        if (ihdr.getBitspc() != 1 && ihdr.getBitspc() != 2 && ihdr.getBitspc() != 4 && ihdr.getBitspc() != 8 && ihdr.getBitspc() != 16) {
            throw new PngjInputException("Invalid bit depth " + ihdr.getBitspc());
        }
    }

    private boolean firstChunksNotYetRead() {
        return this.currentChunkGroup < 1;
    }

    private void readLastAndClose() {
        if (this.currentChunkGroup < 5) {
            try {
                this.idatIstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.readLastChunks();
        }
        this.close();
    }

    private void close() {
        if (this.currentChunkGroup < 6) {
            try {
                this.idatIstream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.currentChunkGroup = 6;
        }
        if (this.shouldCloseStream) {
            try {
                this.inputStream.close();
            }
            catch (Exception e) {
                throw new PngjInputException("error closing input stream!", e);
            }
        }
    }

    private void unfilterRow(int nbytes) {
        byte ftn = this.rowbfilter[0];
        FilterType ft = FilterType.getByVal(ftn);
        if (ft == null) {
            throw new PngjInputException("Filter type " + ftn + " invalid");
        }
        switch (ft) {
            case FILTER_NONE: {
                this.unfilterRowNone(nbytes);
                break;
            }
            case FILTER_SUB: {
                this.unfilterRowSub(nbytes);
                break;
            }
            case FILTER_UP: {
                this.unfilterRowUp(nbytes);
                break;
            }
            case FILTER_AVERAGE: {
                this.unfilterRowAverage(nbytes);
                break;
            }
            case FILTER_PAETH: {
                this.unfilterRowPaeth(nbytes);
                break;
            }
            default: {
                throw new PngjInputException("Filter type " + ftn + " not implemented");
            }
        }
        if (this.crctest != null) {
            this.crctest.update(this.rowb, 1, this.rowb.length - 1);
        }
    }

    private void unfilterRowAverage(int nbytes) {
        int j = 1 - this.imgInfo.bytesPixel;
        int i = 1;
        while (i <= nbytes) {
            int x = j > 0 ? this.rowb[j] & 0xFF : 0;
            this.rowb[i] = (byte)(this.rowbfilter[i] + (x + (this.rowbprev[i] & 0xFF)) / 2);
            ++i;
            ++j;
        }
    }

    private void unfilterRowNone(int nbytes) {
        for (int i = 1; i <= nbytes; ++i) {
            this.rowb[i] = this.rowbfilter[i];
        }
    }

    private void unfilterRowPaeth(int nbytes) {
        int j = 1 - this.imgInfo.bytesPixel;
        int i = 1;
        while (i <= nbytes) {
            int x = j > 0 ? this.rowb[j] & 0xFF : 0;
            int y = j > 0 ? this.rowbprev[j] & 0xFF : 0;
            this.rowb[i] = (byte)(this.rowbfilter[i] + PngHelperInternal.filterPaethPredictor(x, this.rowbprev[i] & 0xFF, y));
            ++i;
            ++j;
        }
    }

    private void unfilterRowSub(int nbytes) {
        int i;
        for (i = 1; i <= this.imgInfo.bytesPixel; ++i) {
            this.rowb[i] = this.rowbfilter[i];
        }
        int j = 1;
        i = this.imgInfo.bytesPixel + 1;
        while (i <= nbytes) {
            this.rowb[i] = (byte)(this.rowbfilter[i] + this.rowb[j]);
            ++i;
            ++j;
        }
    }

    private void unfilterRowUp(int nbytes) {
        for (int i = 1; i <= nbytes; ++i) {
            this.rowb[i] = (byte)(this.rowbfilter[i] + this.rowbprev[i]);
        }
    }

    private final void readFirstChunks() {
        int idatLen;
        if (!this.firstChunksNotYetRead()) {
            return;
        }
        int clen = 0;
        boolean found = false;
        byte[] chunkid = new byte[4];
        this.currentChunkGroup = 1;
        while (!found) {
            clen = PngHelperInternal.readInt4(this.inputStream);
            this.offset += 4L;
            if (clen < 0) break;
            PngHelperInternal.readBytes(this.inputStream, chunkid, 0, 4);
            this.offset += 4L;
            if (Arrays.equals(chunkid, ChunkHelper.b_IDAT)) {
                found = true;
                this.currentChunkGroup = 4;
                this.chunksList.appendReadChunk(new PngChunkIDAT(this.imgInfo, clen, this.offset - 8L), this.currentChunkGroup);
                break;
            }
            if (Arrays.equals(chunkid, ChunkHelper.b_IEND)) {
                throw new PngjInputException("END chunk found before image data (IDAT) at offset=" + this.offset);
            }
            if (Arrays.equals(chunkid, ChunkHelper.b_PLTE)) {
                this.currentChunkGroup = 2;
            }
            this.readChunk(chunkid, clen, false);
            if (!Arrays.equals(chunkid, ChunkHelper.b_PLTE)) continue;
            this.currentChunkGroup = 3;
        }
        int n = idatLen = found ? clen : -1;
        if (idatLen < 0) {
            throw new PngjInputException("first idat chunk not found!");
        }
        this.iIdatCstream = new PngIDatChunkInputStream(this.inputStream, idatLen, this.offset);
        this.idatIstream = new InflaterInputStream(this.iIdatCstream);
        if (!this.crcEnabled) {
            this.iIdatCstream.disableCrcCheck();
        }
    }

    void readLastChunks() {
        this.currentChunkGroup = 5;
        if (!this.iIdatCstream.isEnded()) {
            this.iIdatCstream.forceChunkEnd();
        }
        int clen = this.iIdatCstream.getLenLastChunk();
        byte[] chunkid = this.iIdatCstream.getIdLastChunk();
        boolean endfound = false;
        boolean first = true;
        boolean skip = false;
        while (!endfound) {
            skip = false;
            if (!first) {
                clen = PngHelperInternal.readInt4(this.inputStream);
                this.offset += 4L;
                if (clen < 0) {
                    throw new PngjInputException("bad chuck len " + clen);
                }
                PngHelperInternal.readBytes(this.inputStream, chunkid, 0, 4);
                this.offset += 4L;
            }
            first = false;
            if (Arrays.equals(chunkid, ChunkHelper.b_IDAT)) {
                skip = true;
            } else if (Arrays.equals(chunkid, ChunkHelper.b_IEND)) {
                this.currentChunkGroup = 6;
                endfound = true;
            }
            this.readChunk(chunkid, clen, skip);
        }
        if (!endfound) {
            throw new PngjInputException("end chunk not found - offset=" + this.offset);
        }
    }

    private PngChunk readChunk(byte[] chunkid, int clen, boolean skipforced) {
        if (clen < 0) {
            throw new PngjInputException("invalid chunk lenght: " + clen);
        }
        if (this.skipChunkIdsSet == null && this.currentChunkGroup > 0) {
            this.skipChunkIdsSet = new HashSet<String>(Arrays.asList(this.skipChunkIds));
        }
        String chunkidstr = ChunkHelper.toString(chunkid);
        boolean critical = ChunkHelper.isCritical(chunkidstr);
        PngChunk pngChunk = null;
        boolean skip = skipforced;
        if (this.maxTotalBytesRead > 0L && (long)clen + this.offset > this.maxTotalBytesRead) {
            throw new PngjInputException("Maximum total bytes to read exceeeded: " + this.maxTotalBytesRead + " offset:" + this.offset + " clen=" + clen);
        }
        if (this.currentChunkGroup > 0 && !critical) {
            boolean bl = skip = skip || this.skipChunkMaxSize > 0 && clen >= this.skipChunkMaxSize || this.skipChunkIdsSet.contains(chunkidstr) || this.maxBytesMetadata > 0 && clen > this.maxBytesMetadata - this.bytesChunksLoaded || !ChunkHelper.shouldLoad(chunkidstr, this.chunkLoadBehaviour);
        }
        if (skip) {
            PngHelperInternal.skipBytes(this.inputStream, clen);
            PngHelperInternal.readInt4(this.inputStream);
            pngChunk = new PngChunkSkipped(chunkidstr, this.imgInfo, clen);
        } else {
            ChunkRaw chunk = new ChunkRaw(clen, chunkid, true);
            chunk.readChunkData(this.inputStream, this.crcEnabled || critical);
            pngChunk = PngChunk.factory(chunk, this.imgInfo);
            if (!pngChunk.crit) {
                this.bytesChunksLoaded += chunk.len;
            }
        }
        pngChunk.setOffset(this.offset - 8L);
        this.chunksList.appendReadChunk(pngChunk, this.currentChunkGroup);
        this.offset += (long)clen + 4L;
        return pngChunk;
    }

    protected void logWarn(String warn) {
        System.err.println(warn);
    }

    public ChunkLoadBehaviour getChunkLoadBehaviour() {
        return this.chunkLoadBehaviour;
    }

    public void setChunkLoadBehaviour(ChunkLoadBehaviour chunkLoadBehaviour) {
        this.chunkLoadBehaviour = chunkLoadBehaviour;
    }

    public ChunksList getChunksList() {
        if (this.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        return this.chunksList;
    }

    int getCurrentChunkGroup() {
        return this.currentChunkGroup;
    }

    public PngMetadata getMetadata() {
        if (this.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        return this.metadata;
    }

    public ImageLine readRow(int nrow) {
        if (this.imgLine == null) {
            this.imgLine = new ImageLine(this.imgInfo, ImageLine.SampleType.INT, this.unpackedMode);
        }
        return this.imgLine.sampleType != ImageLine.SampleType.BYTE ? this.readRowInt(nrow) : this.readRowByte(nrow);
    }

    public ImageLine readRowInt(int nrow) {
        if (this.imgLine == null) {
            this.imgLine = new ImageLine(this.imgInfo, ImageLine.SampleType.INT, this.unpackedMode);
        }
        if (this.imgLine.getRown() == nrow) {
            return this.imgLine;
        }
        this.readRowInt(this.imgLine.scanline, nrow);
        this.imgLine.setFilterUsed(FilterType.getByVal(this.rowbfilter[0]));
        this.imgLine.setRown(nrow);
        return this.imgLine;
    }

    public ImageLine readRowByte(int nrow) {
        if (this.imgLine == null) {
            this.imgLine = new ImageLine(this.imgInfo, ImageLine.SampleType.BYTE, this.unpackedMode);
        }
        if (this.imgLine.getRown() == nrow) {
            return this.imgLine;
        }
        this.readRowByte(this.imgLine.scanlineb, nrow);
        this.imgLine.setFilterUsed(FilterType.getByVal(this.rowbfilter[0]));
        this.imgLine.setRown(nrow);
        return this.imgLine;
    }

    public final int[] readRow(int[] buffer, int nrow) {
        return this.readRowInt(buffer, nrow);
    }

    public final int[] readRowInt(int[] buffer, int nrow) {
        if (buffer == null) {
            buffer = new int[this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
        }
        if (!this.interlaced) {
            if (nrow <= this.rowNum) {
                throw new PngjInputException("rows must be read in increasing order: " + nrow);
            }
            int bytesread = 0;
            while (this.rowNum < nrow) {
                bytesread = this.readRowRaw(this.rowNum + 1);
            }
            this.decodeLastReadRowToInt(buffer, bytesread);
        } else {
            if (this.deinterlacer.getImageInt() == null) {
                this.deinterlacer.setImageInt(this.readRowsInt().scanlines);
            }
            System.arraycopy(this.deinterlacer.getImageInt()[nrow], 0, buffer, 0, this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked);
        }
        return buffer;
    }

    public final byte[] readRowByte(byte[] buffer, int nrow) {
        if (buffer == null) {
            buffer = new byte[this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
        }
        if (!this.interlaced) {
            if (nrow <= this.rowNum) {
                throw new PngjInputException("rows must be read in increasing order: " + nrow);
            }
            int bytesread = 0;
            while (this.rowNum < nrow) {
                bytesread = this.readRowRaw(this.rowNum + 1);
            }
            this.decodeLastReadRowToByte(buffer, bytesread);
        } else {
            if (this.deinterlacer.getImageByte() == null) {
                this.deinterlacer.setImageByte(this.readRowsByte().scanlinesb);
            }
            System.arraycopy(this.deinterlacer.getImageByte()[nrow], 0, buffer, 0, this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked);
        }
        return buffer;
    }

    public ImageLine getRow(int nrow) {
        return this.readRow(nrow);
    }

    private void decodeLastReadRowToInt(int[] buffer, int bytesRead) {
        if (this.imgInfo.bitDepth <= 8) {
            int j = 1;
            for (int i = 0; i < bytesRead; ++i) {
                buffer[i] = this.rowb[j++] & 0xFF;
            }
        } else {
            int i = 0;
            int j = 1;
            while (j <= bytesRead) {
                buffer[i] = ((this.rowb[j++] & 0xFF) << 8) + (this.rowb[j++] & 0xFF);
                ++i;
            }
        }
        if (this.imgInfo.packed && this.unpackedMode) {
            ImageLine.unpackInplaceInt(this.imgInfo, buffer, buffer, false);
        }
    }

    private void decodeLastReadRowToByte(byte[] buffer, int bytesRead) {
        if (this.imgInfo.bitDepth <= 8) {
            System.arraycopy(this.rowb, 1, buffer, 0, bytesRead);
        } else {
            int i = 0;
            for (int j = 1; j < bytesRead; j += 2) {
                buffer[i] = this.rowb[j];
                ++i;
            }
        }
        if (this.imgInfo.packed && this.unpackedMode) {
            ImageLine.unpackInplaceByte(this.imgInfo, buffer, buffer, false);
        }
    }

    public ImageLines readRowsInt(int rowOffset, int nRows, int rowStep) {
        if (nRows < 0) {
            nRows = (this.imgInfo.rows - rowOffset) / rowStep;
        }
        if (rowStep < 1 || rowOffset < 0 || nRows * rowStep + rowOffset > this.imgInfo.rows) {
            throw new PngjInputException("bad args");
        }
        ImageLines imlines = new ImageLines(this.imgInfo, ImageLine.SampleType.INT, this.unpackedMode, rowOffset, nRows, rowStep);
        if (!this.interlaced) {
            for (int j = 0; j < this.imgInfo.rows; ++j) {
                int bytesread = this.readRowRaw(j);
                int mrow = imlines.imageRowToMatrixRowStrict(j);
                if (mrow < 0) continue;
                this.decodeLastReadRowToInt(imlines.scanlines[mrow], bytesread);
            }
        } else {
            int[] buf = new int[this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
            for (int p = 1; p <= 7; ++p) {
                this.deinterlacer.setPass(p);
                for (int i = 0; i < this.deinterlacer.getRows(); ++i) {
                    int bytesread = this.readRowRaw(i);
                    int j = this.deinterlacer.getCurrRowReal();
                    int mrow = imlines.imageRowToMatrixRowStrict(j);
                    if (mrow < 0) continue;
                    this.decodeLastReadRowToInt(buf, bytesread);
                    this.deinterlacer.deinterlaceInt(buf, imlines.scanlines[mrow], !this.unpackedMode);
                }
            }
        }
        this.end();
        return imlines;
    }

    public ImageLines readRowsInt() {
        return this.readRowsInt(0, this.imgInfo.rows, 1);
    }

    public ImageLines readRowsByte(int rowOffset, int nRows, int rowStep) {
        if (nRows < 0) {
            nRows = (this.imgInfo.rows - rowOffset) / rowStep;
        }
        if (rowStep < 1 || rowOffset < 0 || nRows * rowStep + rowOffset > this.imgInfo.rows) {
            throw new PngjInputException("bad args");
        }
        ImageLines imlines = new ImageLines(this.imgInfo, ImageLine.SampleType.BYTE, this.unpackedMode, rowOffset, nRows, rowStep);
        if (!this.interlaced) {
            for (int j = 0; j < this.imgInfo.rows; ++j) {
                int bytesread = this.readRowRaw(j);
                int mrow = imlines.imageRowToMatrixRowStrict(j);
                if (mrow < 0) continue;
                this.decodeLastReadRowToByte(imlines.scanlinesb[mrow], bytesread);
            }
        } else {
            byte[] buf = new byte[this.unpackedMode ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
            for (int p = 1; p <= 7; ++p) {
                this.deinterlacer.setPass(p);
                for (int i = 0; i < this.deinterlacer.getRows(); ++i) {
                    int bytesread = this.readRowRaw(i);
                    int j = this.deinterlacer.getCurrRowReal();
                    int mrow = imlines.imageRowToMatrixRowStrict(j);
                    if (mrow < 0) continue;
                    this.decodeLastReadRowToByte(buf, bytesread);
                    this.deinterlacer.deinterlaceByte(buf, imlines.scanlinesb[mrow], !this.unpackedMode);
                }
            }
        }
        this.end();
        return imlines;
    }

    public ImageLines readRowsByte() {
        return this.readRowsByte(0, this.imgInfo.rows, 1);
    }

    private int readRowRaw(int nrow) {
        if (nrow == 0 && this.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        if (nrow == 0 && this.interlaced) {
            Arrays.fill(this.rowb, (byte)0);
        }
        int bytesRead = this.imgInfo.bytesPerRow;
        if (this.interlaced) {
            if (nrow < 0 || nrow > this.deinterlacer.getRows() || nrow != 0 && nrow != this.deinterlacer.getCurrRowSubimg() + 1) {
                throw new PngjInputException("invalid row in interlaced mode: " + nrow);
            }
            this.deinterlacer.setRow(nrow);
            bytesRead = (this.imgInfo.bitspPixel * this.deinterlacer.getPixelsToRead() + 7) / 8;
            if (bytesRead < 1) {
                throw new PngjExceptionInternal("wtf??");
            }
        } else if (nrow < 0 || nrow >= this.imgInfo.rows || nrow != this.rowNum + 1) {
            throw new PngjInputException("invalid row: " + nrow);
        }
        this.rowNum = nrow;
        byte[] tmp = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = tmp;
        PngHelperInternal.readBytes(this.idatIstream, this.rowbfilter, 0, bytesRead + 1);
        this.offset = this.iIdatCstream.getOffset();
        if (this.offset < 0L) {
            throw new PngjExceptionInternal("bad offset ??" + this.offset);
        }
        if (this.maxTotalBytesRead > 0L && this.offset >= this.maxTotalBytesRead) {
            throw new PngjInputException("Reading IDAT: Maximum total bytes to read exceeeded: " + this.maxTotalBytesRead + " offset:" + this.offset);
        }
        this.rowb[0] = 0;
        this.unfilterRow(bytesRead);
        this.rowb[0] = this.rowbfilter[0];
        if (this.rowNum == this.imgInfo.rows - 1 && !this.interlaced || this.interlaced && this.deinterlacer.isAtLastRow()) {
            this.readLastAndClose();
        }
        return bytesRead;
    }

    public void readSkippingAllRows() {
        if (this.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        this.iIdatCstream.disableCrcCheck();
        try {
            int r;
            while ((r = this.iIdatCstream.read(this.rowbfilter, 0, this.rowbfilter.length)) >= 0) {
            }
        }
        catch (IOException e) {
            throw new PngjInputException("error in raw read of IDAT", e);
        }
        this.offset = this.iIdatCstream.getOffset();
        if (this.offset < 0L) {
            throw new PngjExceptionInternal("bad offset ??" + this.offset);
        }
        if (this.maxTotalBytesRead > 0L && this.offset >= this.maxTotalBytesRead) {
            throw new PngjInputException("Reading IDAT: Maximum total bytes to read exceeeded: " + this.maxTotalBytesRead + " offset:" + this.offset);
        }
        this.readLastAndClose();
    }

    public long getMaxTotalBytesRead() {
        return this.maxTotalBytesRead;
    }

    public void setMaxTotalBytesRead(long maxTotalBytesToRead) {
        this.maxTotalBytesRead = maxTotalBytesToRead;
    }

    public int getMaxBytesMetadata() {
        return this.maxBytesMetadata;
    }

    public void setMaxBytesMetadata(int maxBytesChunksToLoad) {
        this.maxBytesMetadata = maxBytesChunksToLoad;
    }

    public int getSkipChunkMaxSize() {
        return this.skipChunkMaxSize;
    }

    public void setSkipChunkMaxSize(int skipChunksBySize) {
        this.skipChunkMaxSize = skipChunksBySize;
    }

    public String[] getSkipChunkIds() {
        return this.skipChunkIds;
    }

    public void setSkipChunkIds(String[] skipChunksById) {
        this.skipChunkIds = skipChunksById == null ? new String[]{} : skipChunksById;
    }

    public void setShouldCloseStream(boolean shouldCloseStream) {
        this.shouldCloseStream = shouldCloseStream;
    }

    public void end() {
        if (this.currentChunkGroup < 6) {
            this.close();
        }
    }

    public boolean isInterlaced() {
        return this.interlaced;
    }

    public boolean isUnpackedMode() {
        return this.unpackedMode;
    }

    public void setUnpackedMode(boolean unPackedMode) {
        this.unpackedMode = unPackedMode;
    }

    public void setCrcCheckDisabled() {
        this.crcEnabled = false;
    }

    long getCrctestVal() {
        return this.crctest.getValue();
    }

    void initCrctest() {
        this.crctest = new CRC32();
    }

    public String toString() {
        return "filename=" + this.filename + " " + this.imgInfo.toString();
    }
}

