/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.light;

import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.light.LightGrid;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileLightDuct
extends TileTDBase {
    public LightGrid gridGlow = null;
    boolean lit = false;

    @Override
    public MultiBlockGrid getNewGrid() {
        return new LightGrid(((TileEntity)this).field_145850_b);
    }

    @Override
    public void setGrid(MultiBlockGrid multiBlockGrid) {
        super.setGrid(multiBlockGrid);
        this.gridGlow = (LightGrid)multiBlockGrid;
    }

    @Override
    public boolean cachesExist() {
        return true;
    }

    @Override
    public void createCaches() {
    }

    @Override
    public void cacheImportant(TileEntity tileEntity, int n) {
    }

    @Override
    public void clearCache(int n) {
    }

    public int getLightValue() {
        return this.isLit() ? 15 : 0;
    }

    public boolean isLit() {
        return ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b) || this.gridGlow == null ? this.lit : this.gridGlow.lit;
    }

    @Override
    public void blockPlaced() {
        super.blockPlaced();
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            this.lit = ((TileEntity)this).field_145850_b.func_72864_z(this.x(), this.y(), this.z());
        } else {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = ((TileEntity)this).field_145850_b.func_147438_o(((TileEntity)this).field_145851_c + forgeDirection.offsetX, ((TileEntity)this).field_145848_d + forgeDirection.offsetY, ((TileEntity)this).field_145849_e + forgeDirection.offsetZ);
                if (!(tileEntity instanceof TileLightDuct) || !((TileLightDuct)tileEntity).lit) continue;
                this.lit = true;
                break;
            }
        }
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        this.lit = false;
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        for (int i = 0; !this.lit && i < forgeDirectionArray.length; ++i) {
            if (this.attachments[i] != null && this.attachments[i].shouldRSConnect()) continue;
            ForgeDirection forgeDirection = forgeDirectionArray[i];
            this.lit = ((TileEntity)this).field_145850_b.func_94574_k(this.x() + forgeDirection.offsetX, this.y() + forgeDirection.offsetY, this.z() + forgeDirection.offsetZ, i);
        }
        if (this.gridGlow != null && this.gridGlow.lit != this.lit) {
            this.gridGlow.upToDate = false;
        }
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addBool(this.lit || this.gridGlow != null && this.gridGlow.lit);
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        boolean bl2 = packetCoFHBase.getBool();
        if (bl2 != this.lit) {
            this.lit = bl2;
            this.checkLight();
        }
    }

    @Override
    public IIcon getBaseIcon() {
        return super.getBaseIcon();
    }

    public void checkLight() {
        ((TileEntity)this).field_145850_b.func_147463_c(EnumSkyBlock.Block, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    @Override
    public boolean isConnectable(TileEntity tileEntity, int n) {
        return tileEntity instanceof TileLightDuct;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("isLit", this.lit);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.lit = nBTTagCompound.func_74767_n("isLit");
    }
}

