/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.light;

import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.position.BlockPosition;
import cofh.lib.util.position.ChunkCoord;
import cofh.thermaldynamics.duct.light.LightGrid;
import cofh.thermaldynamics.duct.light.TileLightDuct;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import com.google.common.collect.Iterables;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketLight
extends PacketCoFHBase {
    public ByteArrayInputStream stream;
    public byte[] data;

    public static HashMap<ChunkCoord, List<BlockPosition>> buildList(Collection<IMultiBlock> collection) {
        HashMap<ChunkCoord, List<BlockPosition>> hashMap = new HashMap<ChunkCoord, List<BlockPosition>>();
        for (IMultiBlock iMultiBlock : collection) {
            BlockPosition blockPosition = new BlockPosition(iMultiBlock.x(), iMultiBlock.y(), iMultiBlock.z());
            ChunkCoord chunkCoord = new ChunkCoord(blockPosition);
            List<BlockPosition> list = hashMap.get(chunkCoord);
            if (list == null) {
                list = new LinkedList<BlockPosition>();
                hashMap.put(chunkCoord, list);
            }
            list.add(blockPosition);
        }
        return hashMap;
    }

    public PacketLight() {
    }

    public PacketLight(boolean bl, LightGrid lightGrid) {
        this.addBool(bl);
        this.addInt(lightGrid.idleSet.size() + lightGrid.nodeSet.size());
        for (IMultiBlock iMultiBlock : Iterables.concat(lightGrid.nodeSet, lightGrid.idleSet)) {
            this.addInt(iMultiBlock.x());
            this.addByte(iMultiBlock.y());
            this.addInt(iMultiBlock.z());
        }
    }

    public void handlePacket(EntityPlayer entityPlayer, boolean bl) {
        boolean bl2 = this.getBool();
        int n = this.getInt();
        ArrayList<TileLightDuct> arrayList = new ArrayList<TileLightDuct>(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            byte by;
            int n3 = this.getInt();
            TileEntity tileEntity = entityPlayer.field_70170_p.func_147438_o(n3, (int)(by = this.getByte()), n2 = this.getInt());
            if (!(tileEntity instanceof TileLightDuct)) continue;
            TileLightDuct tileLightDuct = (TileLightDuct)tileEntity;
            arrayList.add(tileLightDuct);
            tileLightDuct.lit = bl2;
        }
        for (TileLightDuct tileLightDuct : arrayList) {
            tileLightDuct.checkLight();
        }
    }

    public void decodeInto(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        this.stream = new ByteArrayInputStream(byteBuf.array());
        this.datain = new DataInputStream(this.stream);
        try {
            this.datain.skipBytes(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

