/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.thermaldynamics.block.SubTileMultiBlock;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.energy.subgrid.SubTileEnergy;
import cofh.thermaldynamics.duct.fluid.FluidGrid;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileFluidDuctPowered
extends TileFluidDuct
implements IEnergyHandler {
    SubTileEnergy energy;

    public void setSubEnergy(SubTileEnergy subTileEnergy) {
        this.energy = subTileEnergy;
        this.subTiles = new SubTileMultiBlock[]{subTileEnergy};
    }

    @Override
    public BlockDuct.ConnectionTypes getConnectionType(int n) {
        if (this.attachments[n] != null) {
            return this.attachments[n].getRenderConnectionType();
        }
        if (this.neighborTypes[n] == TileTDBase.NeighborTypes.STRUCTURE) {
            return this.connectionTypes[n] != TileTDBase.ConnectionTypes.BLOCKED ? BlockDuct.ConnectionTypes.STRUCTURE : BlockDuct.ConnectionTypes.NONE;
        }
        return super.getConnectionType(n);
    }

    @Override
    public void setGrid(MultiBlockGrid multiBlockGrid) {
        super.setGrid(multiBlockGrid);
        if (multiBlockGrid != null) {
            ((FluidGrid)multiBlockGrid).doesPassiveTicking = true;
        }
    }

    @Override
    public boolean isStructureTile(TileEntity tileEntity, int n) {
        return tileEntity instanceof IEnergyConnection && ((IEnergyConnection)tileEntity).canConnectEnergy(ForgeDirection.getOrientation((int)(n ^ 1)));
    }

    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.energy.energyGrid != null && this.canConnectEnergy(forgeDirection) ? this.energy.energyGrid.myStorage.receiveEnergy(n, bl) : 0;
    }

    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this.energy.energyGrid != null ? this.energy.energyGrid.myStorage.getEnergyStored() : 0;
    }

    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this.energy.energyGrid != null ? this.energy.energyGrid.myStorage.getMaxEnergyStored() : 0;
    }

    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return this.connectionTypes[forgeDirection.ordinal()] != TileTDBase.ConnectionTypes.BLOCKED;
    }
}

