/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.lib.util.TimeTracker;
import cofh.lib.util.helpers.FluidHelper;
import cofh.thermaldynamics.duct.fluid.FluidTankGrid;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FluidGrid
extends MultiBlockGrid {
    public final FluidTankGrid myTank = new FluidTankGrid(1000, this);
    public int toDistribute = 0;
    TimeTracker myTracker = new TimeTracker();
    boolean recentRenderUpdate = false;
    int renderFluidLevel = 0;
    FluidStack myRenderFluid = null;
    public boolean doesPassiveTicking = false;

    public FluidGrid(World world) {
        super(world);
    }

    @Override
    public void addBlock(IMultiBlock iMultiBlock) {
        super.addBlock(iMultiBlock);
        TileFluidDuct tileFluidDuct = (TileFluidDuct)iMultiBlock;
        if (tileFluidDuct.fluidForGrid != null) {
            if (this.myTank.getFluid() == null) {
                this.myTank.setFluid(tileFluidDuct.fluidForGrid);
            } else {
                this.myTank.fill(tileFluidDuct.fluidForGrid, true);
            }
            tileFluidDuct.fluidForGrid = null;
            this.recentRenderUpdate = true;
        }
    }

    @Override
    public void balanceGrid() {
        this.myTank.setCapacity(this.size() * this.myTank.fluidPerDuct);
    }

    public float getThroughPutModifier() {
        return 1.0f;
    }

    public int getMaxFluidPerDuct() {
        return 3000;
    }

    @Override
    public void destroyNode(IMultiBlock iMultiBlock) {
        if (this.hasValidFluid()) {
            ((TileFluidDuct)iMultiBlock).fluidForGrid = this.getNodeShare((TileFluidDuct)iMultiBlock);
        }
        super.destroyNode(iMultiBlock);
    }

    @Override
    public boolean canAddBlock(IMultiBlock iMultiBlock) {
        return iMultiBlock instanceof TileFluidDuct && FluidHelper.isFluidEqualOrNull((FluidStack)((TileFluidDuct)iMultiBlock).getConnectionFluid(), (FluidStack)this.myTank.getFluid());
    }

    @Override
    public void tickGrid() {
        block11: {
            super.tickGrid();
            if (this.worldGrid.worldObj.func_82737_E() % 4L == 0L) {
                this.updateAllRenders();
            }
            if (this.myTank.getFluid() != null && this.nodeSet.size() > 0) {
                this.toDistribute = Math.min(this.myTank.getFluidAmount() / this.size(), this.getFluidThroughput());
                if (this.toDistribute <= 0) {
                    this.toDistribute = Math.min(this.myTank.getFluidAmount() % this.size(), this.getFluidThroughput());
                }
                if (this.toDistribute > 0) {
                    for (IMultiBlock iMultiBlock : this.nodeSet) {
                        if (!iMultiBlock.tickPass(0) || iMultiBlock.getGrid() == null) break;
                    }
                }
            }
            if (!this.nodeSet.isEmpty()) {
                for (IMultiBlock iMultiBlock : this.nodeSet) {
                    if (!iMultiBlock.tickPass(1) || iMultiBlock.getGrid() == null) break;
                }
            }
            if (!this.doesPassiveTicking) break block11;
            if (!this.nodeSet.isEmpty()) {
                for (IMultiBlock iMultiBlock : this.nodeSet) {
                    if (!iMultiBlock.tickPass(2) || iMultiBlock.getGrid() == null) break;
                }
            }
            if (!this.idleSet.isEmpty()) {
                for (IMultiBlock iMultiBlock : this.idleSet) {
                    if (!iMultiBlock.tickPass(2) || iMultiBlock.getGrid() == null) break;
                }
            }
        }
    }

    @Override
    public void mergeGrids(MultiBlockGrid multiBlockGrid) {
        super.mergeGrids(multiBlockGrid);
        FluidGrid fluidGrid = (FluidGrid)multiBlockGrid;
        this.doesPassiveTicking = this.doesPassiveTicking || fluidGrid.doesPassiveTicking;
        this.myTank.fill(fluidGrid.getFluid(), true);
        this.recentRenderUpdate = true;
    }

    @Override
    public boolean canGridsMerge(MultiBlockGrid multiBlockGrid) {
        return super.canGridsMerge(multiBlockGrid) && FluidHelper.isFluidEqualOrNull((FluidStack)((FluidGrid)multiBlockGrid).getFluid(), (FluidStack)this.getFluid());
    }

    public int getFluidThroughput() {
        if (this.myTank.getFluid() == null) {
            return 100;
        }
        int n = this.myTank.getCapacity();
        if (this.myTank.getFluid().amount >= n * 3 / 4) {
            return this.myTank.fluidThroughput;
        }
        if (this.myTank.getFluid().amount <= n / 4) {
            return this.myTank.fluidThroughput >> 1;
        }
        return (this.myTank.fluidThroughput >> 1) + (this.myTank.fluidThroughput >> 1) * (this.myTank.getFluid().amount - (n >> 2)) / (n >> 1);
    }

    public void fluidChanged() {
        this.balanceGrid();
    }

    public FluidStack getNodeShare(TileFluidDuct tileFluidDuct) {
        FluidStack fluidStack = this.myTank.getFluid().copy();
        fluidStack.amount = this.getNodeAmount(tileFluidDuct);
        return fluidStack;
    }

    public int getNodeAmount(TileFluidDuct tileFluidDuct) {
        return this.size() == 1 ? this.myTank.getFluidAmount() : (this.isFirstMultiblock(tileFluidDuct) ? this.myTank.getFluidAmount() / this.size() + this.myTank.getFluidAmount() % this.size() : this.myTank.getFluidAmount() / this.size());
    }

    public FluidStack getFluid() {
        return this.myTank.getFluid();
    }

    public boolean hasValidFluid() {
        return this.myTank.getFluid() != null;
    }

    public void updateAllRenders() {
        int n = this.renderFluidLevel;
        if (this.updateRender() && n != this.renderFluidLevel) {
            if (this.myTank.getFluid() != null) {
                this.myRenderFluid = this.myTank.getFluid().copy();
                this.myRenderFluid.amount = this.renderFluidLevel;
            } else {
                this.myRenderFluid = null;
            }
            for (IMultiBlock iMultiBlock : this.nodeSet) {
                ((TileFluidDuct)iMultiBlock).updateFluid();
            }
            for (IMultiBlock iMultiBlock : this.idleSet) {
                ((TileFluidDuct)iMultiBlock).updateFluid();
            }
        }
    }

    public boolean updateRender() {
        if (this.recentRenderUpdate && this.myTracker.hasDelayPassed(this.worldGrid.worldObj, 96)) {
            this.recentRenderUpdate = false;
        }
        if (this.myTank.getFluid() != null && this.myTank.getCapacity() > 0) {
            double d = 10000 * this.myTank.getFluid().amount / this.myTank.getCapacity();
            if (d >= 0.0) {
                int n = this.renderFluidLevel == 2 ? 500 : 700;
                if (d <= (double)n) {
                    this.renderFluidLevel = 1;
                    return true;
                }
            }
            if (d >= 500.0) {
                int n = this.renderFluidLevel == 3 ? 2000 : 2500;
                if (d <= (double)n) {
                    this.renderFluidLevel = 2;
                    return true;
                }
            }
            if (d >= 2000.0) {
                int n = this.renderFluidLevel == 4 ? 4000 : 4500;
                if (d <= (double)n) {
                    this.renderFluidLevel = 3;
                    return true;
                }
            }
            if (d >= 4000.0) {
                int n = this.renderFluidLevel == 5 ? 6000 : 6500;
                if (d <= (double)n) {
                    this.renderFluidLevel = 4;
                    return true;
                }
            }
            if (d >= 6000.0) {
                int n = this.renderFluidLevel == 6 ? 8000 : 8500;
                if (d <= (double)n) {
                    this.renderFluidLevel = 5;
                    return true;
                }
            }
            this.renderFluidLevel = 6;
            return true;
        }
        if (this.renderFluidLevel != 0 && !this.recentRenderUpdate) {
            this.renderFluidLevel = 0;
            this.recentRenderUpdate = true;
            this.myTracker.markTime(this.worldGrid.worldObj);
            return true;
        }
        return false;
    }

    public FluidStack getRenderFluid() {
        return this.myRenderFluid;
    }

    public static final class FluidRenderType {
        public static final byte EMPTY = 0;
        public static final byte LOW = 1;
        public static final byte LOW_MED = 2;
        public static final byte MEDIUM = 3;
        public static final byte MED_HIGH = 4;
        public static final byte HIGH = 5;
        public static final byte FULL = 6;
    }
}

