/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.relay;

import cofh.core.network.PacketCoFHBase;
import cofh.core.render.RenderUtils;
import cofh.lib.util.helpers.ServerHelper;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.render.RenderDuct;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Relay
extends Attachment {
    public static final byte NON_THRESHOLD = -1;
    int type = 0;
    int powerLevel;
    boolean invert = false;
    byte threshold = 0;

    public Relay(TileTDBase tileTDBase, byte by) {
        super(tileTDBase, by);
    }

    public Relay(TileTDBase tileTDBase, byte by, int n) {
        super(tileTDBase, by);
        this.type = n;
    }

    @Override
    public String getName() {
        return "item.thermaldynamics.relay.name";
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    public Cuboid6 getCuboid() {
        return TileTDBase.subSelection[this.side].copy();
    }

    @Override
    public TileTDBase.NeighborTypes getNeighborType() {
        return null;
    }

    @Override
    public BlockDuct.ConnectionTypes getRenderConnectionType() {
        return BlockDuct.ConnectionTypes.DUCT;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean render(int n, RenderBlocks renderBlocks) {
        if (n == 1) {
            return false;
        }
        Translation translation = RenderUtils.getRenderVector((double)((double)((TileEntity)this.tile).field_145851_c + 0.5), (double)((double)((TileEntity)this.tile).field_145848_d + 0.5), (double)((double)((TileEntity)this.tile).field_145849_e + 0.5)).translation();
        RenderDuct.modelConnection[1 + this.type][this.side].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)RenderDuct.signalTexture)});
        return true;
    }

    @Override
    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalDynamics.itemRelay);
    }

    @Override
    public List<ItemStack> getDrops() {
        LinkedList<ItemStack> linkedList = new LinkedList<ItemStack>();
        linkedList.add(this.getPickBlock());
        return linkedList;
    }

    @Override
    public void onNeighborChange() {
        super.onNeighborChange();
        if (this.type == 0) {
            int n = this.getRawRedstoneLevel();
            this.powerLevel = n = this.adjustPowerLevel(n);
        }
        if (this.tile.myGrid != null) {
            this.tile.myGrid.signalsUpToDate = false;
        }
    }

    public int adjustPowerLevel(int n) {
        if (this.threshold != -1) {
            int n2 = n = n > this.threshold ? 15 : 0;
        }
        if (this.invert) {
            n = 15 - n;
        }
        return n;
    }

    public int getRawRedstoneLevel() {
        int n = ((TileEntity)this.tile).field_145851_c + Facing.field_71586_b[this.side];
        int n2 = ((TileEntity)this.tile).field_145848_d + Facing.field_71587_c[this.side];
        int n3 = ((TileEntity)this.tile).field_145849_e + Facing.field_71585_d[this.side];
        int n4 = 0;
        Block block = this.tile.world().func_147439_a(n, n2, n3);
        if (this.type == 0) {
            n4 = Math.max(n4, this.tile.world().func_72878_l(n, n2, n3, (int)this.side));
            if (block == Blocks.field_150488_af) {
                n4 = Math.max(n4, this.tile.world().func_72805_g(n, n2, n3));
            }
        }
        if (this.type == 2) {
            Block block2;
            if (block.func_149740_M()) {
                n4 = block.func_149736_g(this.tile.world(), n, n2, n3, Direction.field_71579_d[this.side ^ 1]);
            } else if (block.isNormalCube((IBlockAccess)this.tile.world(), n, n2, n3) && (block2 = this.tile.world().func_147439_a(n += Facing.field_71586_b[this.side], n2 += Facing.field_71587_c[this.side], n3 += Facing.field_71585_d[this.side])).func_149740_M()) {
                n4 = block2.func_149736_g(this.tile.world(), n, n2, n3, Direction.field_71579_d[this.side ^ 1]);
            }
        }
        return n4;
    }

    public boolean isInput() {
        return this.type == 0;
    }

    public boolean isOutput() {
        return this.type == 1;
    }

    public int getPowerLevel() {
        if (this.type == 1 && this.tile.myGrid != null) {
            return this.adjustPowerLevel(this.tile.myGrid.redstoneLevel);
        }
        return this.powerLevel;
    }

    @Override
    public int getRSOutput() {
        return this.isOutput() ? this.getPowerLevel() : 0;
    }

    public void setPowerLevel(int n) {
        if (this.powerLevel != n) {
            this.powerLevel = n;
            this.tile.world().func_147460_e(((TileEntity)this.tile).field_145851_c + Facing.field_71586_b[this.side], ((TileEntity)this.tile).field_145848_d + Facing.field_71587_c[this.side], ((TileEntity)this.tile).field_145849_e + Facing.field_71585_d[this.side], this.tile.func_145838_q());
        }
    }

    @Override
    public void checkSignal() {
        MultiBlockGrid multiBlockGrid = this.tile.myGrid;
        if (multiBlockGrid == null) {
            return;
        }
        this.setPowerLevel(multiBlockGrid.redstoneLevel);
    }

    @Override
    public boolean respondsToSignallum() {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
        nBTTagCompound.func_74774_a("type", (byte)this.type);
        nBTTagCompound.func_74757_a("invert", this.invert);
        nBTTagCompound.func_74774_a("threshold", this.threshold);
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
        this.type = nBTTagCompound.func_74771_c("type");
        if (nBTTagCompound.func_150297_b("invert", 1)) {
            this.invert = nBTTagCompound.func_74767_n("invert");
        }
        if (nBTTagCompound.func_150297_b("threshold", 1)) {
            this.threshold = nBTTagCompound.func_74771_c("threshold");
        }
    }

    @Override
    public void addDescriptionToPacket(PacketCoFHBase packetCoFHBase) {
        packetCoFHBase.addByte(this.type);
    }

    @Override
    public void getDescriptionFromPacket(PacketCoFHBase packetCoFHBase) {
        this.type = packetCoFHBase.getByte();
    }

    @Override
    public boolean openGui(EntityPlayer entityPlayer) {
        if (ServerHelper.isClientWorld((World)this.tile.world())) {
            return true;
        }
        this.type ^= 1;
        if (this.tile.myGrid != null) {
            this.tile.myGrid.resetRelays();
        }
        this.tile.world().func_147459_d(((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e, this.tile.func_145838_q());
        this.onNeighborChange();
        this.tile.world().func_147471_g(this.tile.x(), this.tile.y(), this.tile.z());
        return true;
    }

    @Override
    public boolean shouldRSConnect() {
        return true;
    }

    @Override
    public boolean canAddToTile(TileTDBase tileTDBase) {
        return tileTDBase.getDuctType().frameType != 2;
    }
}

