/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.cover;

import cofh.thermaldynamics.ThermalDynamics;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class CoverHelper {
    public static HashMap<Fluid, Block> fluidToBlockMap;

    public static void initFluids() {
        fluidToBlockMap = new HashMap();
        fluidToBlockMap.put(FluidRegistry.WATER, Blocks.field_150355_j);
        fluidToBlockMap.put(FluidRegistry.LAVA, Blocks.field_150353_l);
        for (Object e : Block.field_149771_c) {
            Fluid fluid;
            if (!(e instanceof IFluidBlock) || (fluid = ((IFluidBlock)e).getFluid()) == null) continue;
            fluidToBlockMap.put(fluid, (Block)e);
        }
    }

    public static Block getFluidBlock(FluidStack fluidStack) {
        if (fluidStack == null) {
            return null;
        }
        if (fluidToBlockMap == null) {
            CoverHelper.initFluids();
        }
        return fluidToBlockMap.get(fluidStack.getFluid());
    }

    public static boolean isValid(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemBlock && CoverHelper.isValid(((ItemBlock)itemStack.func_77973_b()).field_150939_a, itemStack.func_77973_b().func_77647_b(itemStack.func_77960_j()))) {
            return true;
        }
        return CoverHelper.getFluidBlock(FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack)) != null;
    }

    public static boolean isValid(Block block, int n) {
        if (block == null) {
            return false;
        }
        return !block.hasTileEntity(n) && !block.func_149716_u();
    }

    public static ItemStack getCoverStack(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemBlock) {
            return CoverHelper.getCoverStack(((ItemBlock)itemStack.func_77973_b()).field_150939_a, itemStack.func_77973_b().func_77647_b(itemStack.func_77960_j()));
        }
        Block block = CoverHelper.getFluidBlock(FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack));
        if (block != null) {
            return CoverHelper.getCoverStack(block, 0);
        }
        return null;
    }

    public static ItemStack getCoverStack(Block block, int n) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74778_a("Block", Block.field_149771_c.func_148750_c((Object)block));
        nBTTagCompound.func_74774_a("Meta", (byte)n);
        ItemStack itemStack = new ItemStack((Item)ThermalDynamics.itemCover, 1);
        itemStack.func_77982_d(nBTTagCompound);
        return itemStack;
    }

    public static ItemStack getCoverItemStack(ItemStack itemStack, boolean bl) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null || !nBTTagCompound.func_150297_b("Meta", 1) || !nBTTagCompound.func_150297_b("Block", 8)) {
            return null;
        }
        byte by = nBTTagCompound.func_74771_c("Meta");
        Block block = Block.func_149684_b((String)nBTTagCompound.func_74779_i("Block"));
        if (block == Blocks.field_150350_a || by < 0 || by >= 16 || !CoverHelper.isValid(block, by)) {
            if (bl) {
                nBTTagCompound.func_82580_o("Meta");
                nBTTagCompound.func_82580_o("Block");
                if (nBTTagCompound.func_82582_d()) {
                    itemStack.func_77982_d(null);
                }
            }
            return null;
        }
        return new ItemStack(block, 1, (int)by);
    }
}

