/*
 * Decompiled with CFR 0.152.
 */
package am2.worldgen;

import am2.blocks.BlocksCommonProxy;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class AM2PoolGen {
    public void generate(World world, Random rand, int x, int y, int z) {
        if ((y = this.correctYCoord(world, x, y, z)) == -1) {
            return;
        }
        if (this.validPoolLocation(world, x, y, z)) {
            world.func_147449_b(x, y, z, (Block)BlocksCommonProxy.liquidEssence);
            world.func_147449_b(x - 1, y, z, (Block)BlocksCommonProxy.liquidEssence);
            world.func_147449_b(x, y, z - 1, (Block)BlocksCommonProxy.liquidEssence);
            world.func_147449_b(x - 1, y, z - 1, (Block)BlocksCommonProxy.liquidEssence);
            world.func_147468_f(x, y + 1, z);
            world.func_147468_f(x - 1, y + 1, z);
            world.func_147468_f(x, y + 1, z - 1);
            world.func_147468_f(x - 1, y + 1, z - 1);
        }
    }

    private int correctYCoord(World world, int x, int y, int z) {
        while (y > 0 && world.func_147437_c(x, y, z)) {
            --y;
        }
        if (y <= 0) {
            return -1;
        }
        while (y < world.field_73011_w.getActualHeight() && !world.func_147437_c(x, y + 1, z)) {
            ++y;
        }
        if (y > world.field_73011_w.getActualHeight()) {
            return -1;
        }
        return y;
    }

    private boolean validPoolLocation(World world, int x, int y, int z) {
        if (!this.biomeIsValid(world, x, y, z)) {
            return false;
        }
        int radius = 2;
        Block requiredBlock = world.func_72807_a((int)x, (int)z).field_76752_A;
        Block alternateBlock = world.func_72807_a((int)x, (int)z).field_76753_B;
        if (requiredBlock == null || alternateBlock == null) {
            return false;
        }
        for (int i = -radius; i < radius; ++i) {
            for (int k = -radius; k < radius; ++k) {
                Block blockBelow = world.func_147439_a(x + i, y - 1, z + k);
                Block block = world.func_147439_a(x + i, y, z + k);
                if (blockBelow == null || block == null) {
                    return false;
                }
                if (!blockBelow.func_149662_c()) {
                    return false;
                }
                if (block != requiredBlock && block != alternateBlock) {
                    return false;
                }
                Block blockAbove = world.func_147439_a(x, y + 1, z);
                if (blockAbove == null) continue;
                if (blockAbove.func_149662_c()) {
                    return false;
                }
                if (!blockAbove.func_149688_o().func_76230_c()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean biomeIsValid(World world, int x, int y, int z) {
        BiomeDictionary.Type[] types;
        BiomeGenBase biome = world.func_72807_a(x, z);
        for (BiomeDictionary.Type type : types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) {
            if (type != BiomeDictionary.Type.END && type != BiomeDictionary.Type.MUSHROOM && type != BiomeDictionary.Type.NETHER && type != BiomeDictionary.Type.WATER && type != BiomeDictionary.Type.WASTELAND) continue;
            return false;
        }
        return true;
    }
}

