/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shapes;

import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellCastResult;
import am2.items.ItemsCommonProxy;
import am2.spell.SpellUtils;
import am2.utility.InventoryUtilities;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Binding
implements ISpellShape {
    @Override
    public int getID() {
        return 2;
    }

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, int side, boolean giveXP, int useCount) {
        if (!(caster instanceof EntityPlayer)) {
            return SpellCastResult.EFFECT_FAILED;
        }
        EntityPlayer player = (EntityPlayer)caster;
        ItemStack heldStack = player.func_71045_bC();
        if (heldStack == null || heldStack.func_77973_b() != ItemsCommonProxy.spell || !(SpellUtils.instance.getShapeForStage(stack, 0) instanceof Binding)) {
            return SpellCastResult.EFFECT_FAILED;
        }
        int bindingType = this.getBindingType(heldStack);
        switch (bindingType) {
            case 1: {
                heldStack = InventoryUtilities.replaceItem(heldStack, ItemsCommonProxy.BoundAxe);
                break;
            }
            case 0: {
                heldStack = InventoryUtilities.replaceItem(heldStack, ItemsCommonProxy.BoundPickaxe);
                break;
            }
            case 2: {
                heldStack = InventoryUtilities.replaceItem(heldStack, ItemsCommonProxy.BoundSword);
                break;
            }
            case 3: {
                heldStack = InventoryUtilities.replaceItem(heldStack, ItemsCommonProxy.BoundShovel);
                break;
            }
            case 4: {
                heldStack = InventoryUtilities.replaceItem(heldStack, ItemsCommonProxy.BoundHoe);
                break;
            }
            case 5: {
                heldStack = InventoryUtilities.replaceItem(heldStack, (Item)Items.field_151031_f);
            }
        }
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, heldStack);
        return SpellCastResult.SUCCESS;
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[7];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 4);
        objectArray[1] = Items.field_151041_m;
        objectArray[2] = Items.field_151051_r;
        objectArray[3] = Items.field_151019_K;
        objectArray[4] = Items.field_151006_E;
        objectArray[5] = Items.field_151046_w;
        objectArray[6] = new ItemStack((Item)ItemsCommonProxy.bindingCatalyst, 1, Short.MAX_VALUE);
        return objectArray;
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 1.0f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return true;
    }

    @Override
    public String getSoundForAffinity(Affinity affinity, ItemStack stack, World world) {
        return "arsmagica2:spell.binding.cast";
    }

    public void setBindingType(ItemStack craftStack, ItemStack addedBindingCatalyst) {
        SpellUtils.instance.setSpellMetadata(craftStack, "binding_type", "" + addedBindingCatalyst.func_77960_j());
    }

    public int getBindingType(ItemStack spellStack) {
        int type = 0;
        try {
            type = Integer.parseInt(SpellUtils.instance.getSpellMetadata(spellStack, "binding_type"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return type;
    }
}

