/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleOrbitEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class Storm
implements ISpellComponent {
    private final Random rand = new Random();

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        this.applyEffect(caster, world);
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        this.applyEffect(caster, world);
        return true;
    }

    private void applyEffect(EntityLivingBase caster, World world) {
        float rainStrength = world.func_72867_j(1.0f);
        if ((double)rainStrength > 0.9) {
            if (!world.field_72995_K) {
                int xzradius = 50;
                int random = this.rand.nextInt(100);
                if (random < 20) {
                    int randPosX = (int)caster.field_70165_t + this.rand.nextInt(xzradius * 2) - xzradius;
                    int randPosZ = (int)caster.field_70161_v + this.rand.nextInt(xzradius * 2) - xzradius;
                    int posY = (int)caster.field_70163_u;
                    while (!world.func_72937_j(randPosX, posY, randPosZ)) {
                        ++posY;
                    }
                    while (world.func_147439_a(randPosX, posY - 1, randPosZ) == Blocks.field_150350_a) {
                        --posY;
                    }
                    EntityLightningBolt bolt = new EntityLightningBolt(world, (double)randPosX, (double)posY, (double)randPosZ);
                    world.func_72942_c((Entity)bolt);
                } else if (random < 80) {
                    List entities = world.func_72872_a(IMob.class, caster.field_70121_D.func_72314_b((double)xzradius, 10.0, (double)xzradius));
                    if (entities.size() <= 0) {
                        return;
                    }
                    Entity target = (Entity)entities.get(this.rand.nextInt(entities.size()));
                    if (target != null && world.func_72937_j((int)target.field_70165_t, (int)target.field_70163_u, (int)target.field_70161_v)) {
                        if (caster instanceof EntityPlayer) {
                            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)caster)), 1.0f);
                        }
                        EntityLightningBolt bolt = new EntityLightningBolt(world, target.field_70165_t, target.field_70163_u, target.field_70161_v);
                        world.func_72942_c((Entity)bolt);
                    }
                }
            }
        } else if (!world.field_72995_K) {
            world.func_72912_H().func_76084_b(true);
        }
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 15.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "symbols", x, y - 1.0, z));
        if (particle != null) {
            particle.AddParticleController(new ParticleOrbitEntity(particle, target, 0.2f, 2, false).SetTargetDistance(1.0));
            particle.setMaxAge(40);
            particle.setParticleScale(0.1f);
            if (colorModifier > -1) {
                particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.LIGHTNING, Affinity.NATURE);
    }

    @Override
    public int getID() {
        return 52;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 16);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 5);
        objectArray[2] = Items.field_151073_bk;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 1.0E-5f;
    }
}

