/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.RitualShapeHelper;
import am2.api.ArsMagicaApi;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.entities.EntityRiftStorage;
import am2.items.ItemsCommonProxy;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Rift
implements ISpellComponent,
IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        ItemStack[] reagents;
        if (world.func_147439_a(blockx, blocky, blockz) == Blocks.field_150474_ac && (reagents = RitualShapeHelper.instance.checkForRitual(this, world, blockx, blocky, blockz)) != null) {
            if (!world.field_72995_K) {
                world.func_147468_f(blockx, blocky, blockz);
                RitualShapeHelper.instance.consumeRitualReagents(this, world, blockx, blocky, blockz);
                RitualShapeHelper.instance.consumeRitualShape(this, world, blockx, blocky, blockz);
                EntityItem item = new EntityItem(world);
                item.func_70107_b((double)blockx + 0.5, (double)blocky + 0.5, (double)blockz + 0.5);
                item.func_92058_a(new ItemStack((Block)BlocksCommonProxy.inertSpawner));
                world.func_72838_d((Entity)item);
            }
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        EntityRiftStorage storage = new EntityRiftStorage(world);
        int storageLevel = Math.min(1 + SpellUtils.instance.countModifiers(SpellModifiers.BUFF_POWER, stack, 0), 3);
        storage.setStorageLevel(storageLevel);
        if (blockFace == 1) {
            storage.func_70107_b((double)blockx + 0.5, (double)blocky + 1.5, (double)blockz + 0.5);
        } else if (blockFace == 2) {
            storage.func_70107_b((double)blockx + 0.5, (double)blocky + 0.5, (double)blockz - 1.5);
        } else if (blockFace == 3) {
            storage.func_70107_b((double)blockx + 0.5, (double)blocky + 0.5, (double)blockz + 1.5);
        } else if (blockFace == 4) {
            storage.func_70107_b((double)blockx - 1.5, (double)blocky + 0.5, (double)blockz + 0.5);
        } else if (blockFace == 5) {
            storage.func_70107_b((double)blockx + 1.5, (double)blocky + 0.5, (double)blockz + 0.5);
        } else {
            storage.func_70107_b((double)blockx + 0.5, (double)blocky - 1.5, (double)blockz + 0.5);
        }
        world.func_72838_d((Entity)storage);
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 90.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.NONE);
    }

    @Override
    public int getID() {
        return 48;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[4];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 15);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 13);
        objectArray[2] = Blocks.field_150486_ae;
        objectArray[3] = Items.field_151061_bv;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.corruption;
    }

    @Override
    public ItemStack[] getReagents() {
        ItemStack[] itemStackArray = new ItemStack[2];
        itemStackArray[0] = new ItemStack((Item)ItemsCommonProxy.mobFocus);
        itemStackArray[1] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 9);
        return itemStackArray;
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }
}

