/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleConverge;
import am2.playerextensions.ExtendedProperties;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Mark
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        ExtendedProperties.For(caster).setMarkLocation(impactX, impactY, impactZ, caster.field_70170_p.field_73011_w.field_76574_g);
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        ExtendedProperties.For(caster).setMarkLocation(target.field_70165_t, target.field_70163_u, target.field_70161_v, caster.field_70170_p.field_73011_w.field_76574_g);
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 5.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 0.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        boolean offset = true;
        this.SetupParticle(world, caster.field_70165_t - 0.5, caster.field_70163_u + (double)offset, caster.field_70161_v, 0.2, 0.0, colorModifier);
        this.SetupParticle(world, caster.field_70165_t + 0.5, caster.field_70163_u + (double)offset, caster.field_70161_v, -0.2, 0.0, colorModifier);
        this.SetupParticle(world, caster.field_70165_t, caster.field_70163_u + (double)offset, caster.field_70161_v - 0.5, 0.0, 0.2, colorModifier);
        this.SetupParticle(world, caster.field_70165_t, caster.field_70163_u + (double)offset, caster.field_70161_v + 0.5, 0.0, -0.2, colorModifier);
    }

    private void SetupParticle(World world, double x, double y, double z, double motionx, double motionz, int colorModifier) {
        AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "symbols", x, y, z));
        if (effect != null) {
            effect.AddParticleController(new ParticleConverge(effect, motionx, -0.1, motionz, 1, true));
            effect.setMaxAge(40);
            effect.setIgnoreMaxAge(false);
            effect.setParticleScale(0.1f);
            if (colorModifier > -1) {
                effect.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.NONE);
    }

    @Override
    public int getID() {
        return 37;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 14);
        objectArray[1] = new ItemStack((Item)Items.field_151148_bJ, 1, Short.MAX_VALUE);
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }
}

