/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.RitualShapeHelper;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleApproachEntity;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class LifeTap
implements ISpellComponent,
IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        ItemStack[] reagents;
        if (world.func_147439_a(blockx, blocky, blockz) == Blocks.field_150474_ac && (reagents = RitualShapeHelper.instance.checkForRitual(this, world, blockx, blocky, blockz)) != null) {
            if (!world.field_72995_K) {
                world.func_147468_f(blockx, blocky, blockz);
                RitualShapeHelper.instance.consumeRitualReagents(this, world, blockx, blocky, blockz);
                RitualShapeHelper.instance.consumeRitualShape(this, world, blockx, blocky, blockz);
                EntityItem item = new EntityItem(world);
                item.func_70107_b((double)blockx + 0.5, (double)blocky + 0.5, (double)blockz + 0.5);
                item.func_92058_a(new ItemStack((Block)BlocksCommonProxy.inertSpawner));
                world.func_72838_d((Entity)item);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (!world.field_72995_K) {
            double damage = SpellUtils.instance.getModifiedDouble_Mul(2.0, stack, caster, target, world, 0, SpellModifiers.DAMAGE);
            float manaRefunded = (float)(damage * 0.01 * (double)ExtendedProperties.For(caster).getMaxMana());
            if (caster.func_70097_a(DamageSource.field_76380_i, (float)((int)Math.floor(damage)))) {
                ExtendedProperties.For(caster).setCurrentMana(Math.min(ExtendedProperties.For(caster).getCurrentMana() + manaRefunded, ExtendedProperties.For(caster).getMaxMana()));
                ExtendedProperties.For(caster).forceSync();
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 0.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 50.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "sparkle2", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(2.0, 2.0, 2.0);
            particle.setMaxAge(15);
            particle.setParticleScale(0.1f);
            particle.AddParticleController(new ParticleApproachEntity(particle, target, 0.1, 0.1, 1, false));
            if (rand.nextBoolean()) {
                particle.setRGBColorF(0.4f, 0.1f, 0.5f);
            } else {
                particle.setRGBColorF(0.1f, 0.5f, 0.1f);
            }
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.LIFE, Affinity.ENDER);
    }

    @Override
    public int getID() {
        return 32;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 0);
        objectArray[1] = BlocksCommonProxy.aum;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.corruption;
    }

    @Override
    public ItemStack[] getReagents() {
        ItemStack[] itemStackArray = new ItemStack[2];
        itemStackArray[0] = new ItemStack((Item)ItemsCommonProxy.mobFocus);
        itemStackArray[1] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 9);
        return itemStackArray;
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }
}

